/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the segments associated with the service insertion action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceInsertionSegments implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceInsertionSegments.Builder, ServiceInsertionSegments> {
    private static final SdkField<List<String>> SEND_VIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SendVia")
            .getter(getter(ServiceInsertionSegments::sendVia))
            .setter(setter(Builder::sendVia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendVia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SEND_TO_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SendTo")
            .getter(getter(ServiceInsertionSegments::sendTo))
            .setter(setter(Builder::sendTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendTo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SEND_VIA_FIELD, SEND_TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> sendVia;

    private final List<String> sendTo;

    private ServiceInsertionSegments(BuilderImpl builder) {
        this.sendVia = builder.sendVia;
        this.sendTo = builder.sendTo;
    }

    /**
     * For responses, this returns true if the service returned a value for the SendVia property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSendVia() {
        return sendVia != null && !(sendVia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of segments associated with the <code>send-via</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSendVia} method.
     * </p>
     * 
     * @return The list of segments associated with the <code>send-via</code> action.
     */
    public final List<String> sendVia() {
        return sendVia;
    }

    /**
     * For responses, this returns true if the service returned a value for the SendTo property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSendTo() {
        return sendTo != null && !(sendTo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of segments associated with the <code>send-to</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSendTo} method.
     * </p>
     * 
     * @return The list of segments associated with the <code>send-to</code> action.
     */
    public final List<String> sendTo() {
        return sendTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSendVia() ? sendVia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSendTo() ? sendTo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInsertionSegments)) {
            return false;
        }
        ServiceInsertionSegments other = (ServiceInsertionSegments) obj;
        return hasSendVia() == other.hasSendVia() && Objects.equals(sendVia(), other.sendVia())
                && hasSendTo() == other.hasSendTo() && Objects.equals(sendTo(), other.sendTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceInsertionSegments").add("SendVia", hasSendVia() ? sendVia() : null)
                .add("SendTo", hasSendTo() ? sendTo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendVia":
            return Optional.ofNullable(clazz.cast(sendVia()));
        case "SendTo":
            return Optional.ofNullable(clazz.cast(sendTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceInsertionSegments, T> g) {
        return obj -> g.apply((ServiceInsertionSegments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceInsertionSegments> {
        /**
         * <p>
         * The list of segments associated with the <code>send-via</code> action.
         * </p>
         * 
         * @param sendVia
         *        The list of segments associated with the <code>send-via</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendVia(Collection<String> sendVia);

        /**
         * <p>
         * The list of segments associated with the <code>send-via</code> action.
         * </p>
         * 
         * @param sendVia
         *        The list of segments associated with the <code>send-via</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendVia(String... sendVia);

        /**
         * <p>
         * The list of segments associated with the <code>send-to</code> action.
         * </p>
         * 
         * @param sendTo
         *        The list of segments associated with the <code>send-to</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendTo(Collection<String> sendTo);

        /**
         * <p>
         * The list of segments associated with the <code>send-to</code> action.
         * </p>
         * 
         * @param sendTo
         *        The list of segments associated with the <code>send-to</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendTo(String... sendTo);
    }

    static final class BuilderImpl implements Builder {
        private List<String> sendVia = DefaultSdkAutoConstructList.getInstance();

        private List<String> sendTo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceInsertionSegments model) {
            sendVia(model.sendVia);
            sendTo(model.sendTo);
        }

        public final Collection<String> getSendVia() {
            if (sendVia instanceof SdkAutoConstructList) {
                return null;
            }
            return sendVia;
        }

        public final void setSendVia(Collection<String> sendVia) {
            this.sendVia = ConstrainedStringListCopier.copy(sendVia);
        }

        @Override
        public final Builder sendVia(Collection<String> sendVia) {
            this.sendVia = ConstrainedStringListCopier.copy(sendVia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendVia(String... sendVia) {
            sendVia(Arrays.asList(sendVia));
            return this;
        }

        public final Collection<String> getSendTo() {
            if (sendTo instanceof SdkAutoConstructList) {
                return null;
            }
            return sendTo;
        }

        public final void setSendTo(Collection<String> sendTo) {
            this.sendTo = ConstrainedStringListCopier.copy(sendTo);
        }

        @Override
        public final Builder sendTo(Collection<String> sendTo) {
            this.sendTo = ConstrainedStringListCopier.copy(sendTo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendTo(String... sendTo) {
            sendTo(Arrays.asList(sendTo));
            return this;
        }

        @Override
        public ServiceInsertionSegments build() {
            return new ServiceInsertionSegments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
