/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of an existing map resource in your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMapsResponseEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListMapsResponseEntry.Builder, ListMapsResponseEntry> {
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(ListMapsResponseEntry::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListMapsResponseEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(ListMapsResponseEntry::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(ListMapsResponseEntry::pricingPlanAsString))
            .setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(ListMapsResponseEntry::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(ListMapsResponseEntry::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_NAME_FIELD,
            DESCRIPTION_FIELD, DATA_SOURCE_FIELD, PRICING_PLAN_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mapName;

    private final String description;

    private final String dataSource;

    private final String pricingPlan;

    private final Instant createTime;

    private final Instant updateTime;

    private ListMapsResponseEntry(BuilderImpl builder) {
        this.mapName = builder.mapName;
        this.description = builder.description;
        this.dataSource = builder.dataSource;
        this.pricingPlan = builder.pricingPlan;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The name of the associated map resource.
     * </p>
     * 
     * @return The name of the associated map resource.
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * The description for the map resource.
     * </p>
     * 
     * @return The description for the map resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the data provider for the associated map tiles.
     * </p>
     * 
     * @return Specifies the data provider for the associated map tiles.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * No longer used. Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * <p>
     * No longer used. Always returns <code>RequestBasedUsage</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return No longer used. Always returns <code>RequestBasedUsage</code>.
     * @see PricingPlan
     * @deprecated Deprecated. Always returns RequestBasedUsage.
     */
    @Deprecated
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * <p>
     * The timestamp for when the map resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the map resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The timestamp for when the map resource was last updated in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the map resource was last updated in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMapsResponseEntry)) {
            return false;
        }
        ListMapsResponseEntry other = (ListMapsResponseEntry) obj;
        return Objects.equals(mapName(), other.mapName()) && Objects.equals(description(), other.description())
                && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMapsResponseEntry").add("MapName", mapName()).add("Description", description())
                .add("DataSource", dataSource()).add("PricingPlan", pricingPlanAsString()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMapsResponseEntry, T> g) {
        return obj -> g.apply((ListMapsResponseEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListMapsResponseEntry> {
        /**
         * <p>
         * The name of the associated map resource.
         * </p>
         * 
         * @param mapName
         *        The name of the associated map resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * The description for the map resource.
         * </p>
         * 
         * @param description
         *        The description for the map resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the data provider for the associated map tiles.
         * </p>
         * 
         * @param dataSource
         *        Specifies the data provider for the associated map tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * No longer used. Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(String pricingPlan);

        /**
         * <p>
         * No longer used. Always returns <code>RequestBasedUsage</code>.
         * </p>
         * 
         * @param pricingPlan
         *        No longer used. Always returns <code>RequestBasedUsage</code>.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         * @deprecated Deprecated. Always returns RequestBasedUsage.
         */
        @Deprecated
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * <p>
         * The timestamp for when the map resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the map resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The timestamp for when the map resource was last updated in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the map resource was last updated in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String mapName;

        private String description;

        private String dataSource;

        private String pricingPlan;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMapsResponseEntry model) {
            mapName(model.mapName);
            description(model.description);
            dataSource(model.dataSource);
            pricingPlan(model.pricingPlan);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getMapName() {
            return mapName;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ListMapsResponseEntry build() {
            return new ListMapsResponseEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
