/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastGeofenceEventsResponse extends LocationResponse implements
        ToCopyableBuilder<ForecastGeofenceEventsResponse.Builder, ForecastGeofenceEventsResponse> {
    private static final SdkField<List<ForecastedEvent>> FORECASTED_EVENTS_FIELD = SdkField
            .<List<ForecastedEvent>> builder(MarshallingType.LIST)
            .memberName("ForecastedEvents")
            .getter(getter(ForecastGeofenceEventsResponse::forecastedEvents))
            .setter(setter(Builder::forecastedEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastedEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastedEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastedEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ForecastGeofenceEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(ForecastGeofenceEventsResponse::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final SdkField<String> SPEED_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpeedUnit").getter(getter(ForecastGeofenceEventsResponse::speedUnitAsString))
            .setter(setter(Builder::speedUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECASTED_EVENTS_FIELD,
            NEXT_TOKEN_FIELD, DISTANCE_UNIT_FIELD, SPEED_UNIT_FIELD));

    private final List<ForecastedEvent> forecastedEvents;

    private final String nextToken;

    private final String distanceUnit;

    private final String speedUnit;

    private ForecastGeofenceEventsResponse(BuilderImpl builder) {
        super(builder);
        this.forecastedEvents = builder.forecastedEvents;
        this.nextToken = builder.nextToken;
        this.distanceUnit = builder.distanceUnit;
        this.speedUnit = builder.speedUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastedEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastedEvents() {
        return forecastedEvents != null && !(forecastedEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of forecasted events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastedEvents} method.
     * </p>
     * 
     * @return The list of forecasted events.
     */
    public final List<ForecastedEvent> forecastedEvents() {
        return forecastedEvents;
    }

    /**
     * <p>
     * The pagination token specifying which page of results to return in the response. If no token is provided, the
     * default page is the first page.
     * </p>
     * 
     * @return The pagination token specifying which page of results to return in the response. If no token is provided,
     *         the default page is the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The distance unit for the forecasted events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the forecasted events.
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit for the forecasted events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the forecasted events.
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The speed unit for the forecasted events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #speedUnit} will
     * return {@link SpeedUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #speedUnitAsString}.
     * </p>
     * 
     * @return The speed unit for the forecasted events.
     * @see SpeedUnit
     */
    public final SpeedUnit speedUnit() {
        return SpeedUnit.fromValue(speedUnit);
    }

    /**
     * <p>
     * The speed unit for the forecasted events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #speedUnit} will
     * return {@link SpeedUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #speedUnitAsString}.
     * </p>
     * 
     * @return The speed unit for the forecasted events.
     * @see SpeedUnit
     */
    public final String speedUnitAsString() {
        return speedUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastedEvents() ? forecastedEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(speedUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastGeofenceEventsResponse)) {
            return false;
        }
        ForecastGeofenceEventsResponse other = (ForecastGeofenceEventsResponse) obj;
        return hasForecastedEvents() == other.hasForecastedEvents()
                && Objects.equals(forecastedEvents(), other.forecastedEvents()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString())
                && Objects.equals(speedUnitAsString(), other.speedUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ForecastGeofenceEventsResponse")
                .add("ForecastedEvents", hasForecastedEvents() ? forecastedEvents() : null).add("NextToken", nextToken())
                .add("DistanceUnit", distanceUnitAsString()).add("SpeedUnit", speedUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastedEvents":
            return Optional.ofNullable(clazz.cast(forecastedEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        case "SpeedUnit":
            return Optional.ofNullable(clazz.cast(speedUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastGeofenceEventsResponse, T> g) {
        return obj -> g.apply((ForecastGeofenceEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ForecastGeofenceEventsResponse> {
        /**
         * <p>
         * The list of forecasted events.
         * </p>
         * 
         * @param forecastedEvents
         *        The list of forecasted events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedEvents(Collection<ForecastedEvent> forecastedEvents);

        /**
         * <p>
         * The list of forecasted events.
         * </p>
         * 
         * @param forecastedEvents
         *        The list of forecasted events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedEvents(ForecastedEvent... forecastedEvents);

        /**
         * <p>
         * The list of forecasted events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.location.model.ForecastedEvent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.location.model.ForecastedEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.location.model.ForecastedEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #forecastedEvents(List<ForecastedEvent>)}.
         * 
         * @param forecastedEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.location.model.ForecastedEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastedEvents(java.util.Collection<ForecastedEvent>)
         */
        Builder forecastedEvents(Consumer<ForecastedEvent.Builder>... forecastedEvents);

        /**
         * <p>
         * The pagination token specifying which page of results to return in the response. If no token is provided, the
         * default page is the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token specifying which page of results to return in the response. If no token is
         *        provided, the default page is the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The distance unit for the forecasted events.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the forecasted events.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit for the forecasted events.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the forecasted events.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The speed unit for the forecasted events.
         * </p>
         * 
         * @param speedUnit
         *        The speed unit for the forecasted events.
         * @see SpeedUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeedUnit
         */
        Builder speedUnit(String speedUnit);

        /**
         * <p>
         * The speed unit for the forecasted events.
         * </p>
         * 
         * @param speedUnit
         *        The speed unit for the forecasted events.
         * @see SpeedUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeedUnit
         */
        Builder speedUnit(SpeedUnit speedUnit);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<ForecastedEvent> forecastedEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String distanceUnit;

        private String speedUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastGeofenceEventsResponse model) {
            super(model);
            forecastedEvents(model.forecastedEvents);
            nextToken(model.nextToken);
            distanceUnit(model.distanceUnit);
            speedUnit(model.speedUnit);
        }

        public final List<ForecastedEvent.Builder> getForecastedEvents() {
            List<ForecastedEvent.Builder> result = ForecastedEventsListCopier.copyToBuilder(this.forecastedEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastedEvents(Collection<ForecastedEvent.BuilderImpl> forecastedEvents) {
            this.forecastedEvents = ForecastedEventsListCopier.copyFromBuilder(forecastedEvents);
        }

        @Override
        public final Builder forecastedEvents(Collection<ForecastedEvent> forecastedEvents) {
            this.forecastedEvents = ForecastedEventsListCopier.copy(forecastedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastedEvents(ForecastedEvent... forecastedEvents) {
            forecastedEvents(Arrays.asList(forecastedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastedEvents(Consumer<ForecastedEvent.Builder>... forecastedEvents) {
            forecastedEvents(Stream.of(forecastedEvents).map(c -> ForecastedEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final String getSpeedUnit() {
            return speedUnit;
        }

        public final void setSpeedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
        }

        @Override
        public final Builder speedUnit(String speedUnit) {
            this.speedUnit = speedUnit;
            return this;
        }

        @Override
        public final Builder speedUnit(SpeedUnit speedUnit) {
            this.speedUnit(speedUnit == null ? null : speedUnit.toString());
            return this;
        }

        @Override
        public ForecastGeofenceEventsResponse build() {
            return new ForecastGeofenceEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
