/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSnapshotInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceSnapshotInfo.Builder, InstanceSnapshotInfo> {
    private static final SdkField<String> FROM_BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromBundleId").getter(getter(InstanceSnapshotInfo::fromBundleId)).setter(setter(Builder::fromBundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBundleId").build()).build();

    private static final SdkField<String> FROM_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromBlueprintId").getter(getter(InstanceSnapshotInfo::fromBlueprintId))
            .setter(setter(Builder::fromBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBlueprintId").build()).build();

    private static final SdkField<List<DiskInfo>> FROM_DISK_INFO_FIELD = SdkField
            .<List<DiskInfo>> builder(MarshallingType.LIST)
            .memberName("fromDiskInfo")
            .getter(getter(InstanceSnapshotInfo::fromDiskInfo))
            .setter(setter(Builder::fromDiskInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DiskInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DiskInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_BUNDLE_ID_FIELD,
            FROM_BLUEPRINT_ID_FIELD, FROM_DISK_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fromBundleId;

    private final String fromBlueprintId;

    private final List<DiskInfo> fromDiskInfo;

    private InstanceSnapshotInfo(BuilderImpl builder) {
        this.fromBundleId = builder.fromBundleId;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromDiskInfo = builder.fromDiskInfo;
    }

    /**
     * <p>
     * The bundle ID from which the source instance was created (<code>micro_x_x</code>).
     * </p>
     * 
     * @return The bundle ID from which the source instance was created (<code>micro_x_x</code>).
     */
    public final String fromBundleId() {
        return fromBundleId;
    }

    /**
     * <p>
     * The blueprint ID from which the source instance (<code>amazon_linux_2023</code>).
     * </p>
     * 
     * @return The blueprint ID from which the source instance (<code>amazon_linux_2023</code>).
     */
    public final String fromBlueprintId() {
        return fromBlueprintId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FromDiskInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFromDiskInfo() {
        return fromDiskInfo != null && !(fromDiskInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects describing the disks that were attached to the source instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFromDiskInfo} method.
     * </p>
     * 
     * @return A list of objects describing the disks that were attached to the source instance.
     */
    public final List<DiskInfo> fromDiskInfo() {
        return fromDiskInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(fromBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFromDiskInfo() ? fromDiskInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshotInfo)) {
            return false;
        }
        InstanceSnapshotInfo other = (InstanceSnapshotInfo) obj;
        return Objects.equals(fromBundleId(), other.fromBundleId()) && Objects.equals(fromBlueprintId(), other.fromBlueprintId())
                && hasFromDiskInfo() == other.hasFromDiskInfo() && Objects.equals(fromDiskInfo(), other.fromDiskInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSnapshotInfo").add("FromBundleId", fromBundleId())
                .add("FromBlueprintId", fromBlueprintId()).add("FromDiskInfo", hasFromDiskInfo() ? fromDiskInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromBundleId":
            return Optional.ofNullable(clazz.cast(fromBundleId()));
        case "fromBlueprintId":
            return Optional.ofNullable(clazz.cast(fromBlueprintId()));
        case "fromDiskInfo":
            return Optional.ofNullable(clazz.cast(fromDiskInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSnapshotInfo, T> g) {
        return obj -> g.apply((InstanceSnapshotInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSnapshotInfo> {
        /**
         * <p>
         * The bundle ID from which the source instance was created (<code>micro_x_x</code>).
         * </p>
         * 
         * @param fromBundleId
         *        The bundle ID from which the source instance was created (<code>micro_x_x</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromBundleId(String fromBundleId);

        /**
         * <p>
         * The blueprint ID from which the source instance (<code>amazon_linux_2023</code>).
         * </p>
         * 
         * @param fromBlueprintId
         *        The blueprint ID from which the source instance (<code>amazon_linux_2023</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromBlueprintId(String fromBlueprintId);

        /**
         * <p>
         * A list of objects describing the disks that were attached to the source instance.
         * </p>
         * 
         * @param fromDiskInfo
         *        A list of objects describing the disks that were attached to the source instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskInfo(Collection<DiskInfo> fromDiskInfo);

        /**
         * <p>
         * A list of objects describing the disks that were attached to the source instance.
         * </p>
         * 
         * @param fromDiskInfo
         *        A list of objects describing the disks that were attached to the source instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskInfo(DiskInfo... fromDiskInfo);

        /**
         * <p>
         * A list of objects describing the disks that were attached to the source instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.DiskInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lightsail.model.DiskInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.DiskInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #fromDiskInfo(List<DiskInfo>)}.
         * 
         * @param fromDiskInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.DiskInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromDiskInfo(java.util.Collection<DiskInfo>)
         */
        Builder fromDiskInfo(Consumer<DiskInfo.Builder>... fromDiskInfo);
    }

    static final class BuilderImpl implements Builder {
        private String fromBundleId;

        private String fromBlueprintId;

        private List<DiskInfo> fromDiskInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshotInfo model) {
            fromBundleId(model.fromBundleId);
            fromBlueprintId(model.fromBlueprintId);
            fromDiskInfo(model.fromDiskInfo);
        }

        public final String getFromBundleId() {
            return fromBundleId;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final String getFromBlueprintId() {
            return fromBlueprintId;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final List<DiskInfo.Builder> getFromDiskInfo() {
            List<DiskInfo.Builder> result = DiskInfoListCopier.copyToBuilder(this.fromDiskInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFromDiskInfo(Collection<DiskInfo.BuilderImpl> fromDiskInfo) {
            this.fromDiskInfo = DiskInfoListCopier.copyFromBuilder(fromDiskInfo);
        }

        @Override
        public final Builder fromDiskInfo(Collection<DiskInfo> fromDiskInfo) {
            this.fromDiskInfo = DiskInfoListCopier.copy(fromDiskInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromDiskInfo(DiskInfo... fromDiskInfo) {
            fromDiskInfo(Arrays.asList(fromDiskInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromDiskInfo(Consumer<DiskInfo.Builder>... fromDiskInfo) {
            fromDiskInfo(Stream.of(fromDiskInfo).map(c -> DiskInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceSnapshotInfo build() {
            return new InstanceSnapshotInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
