/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options you can specify when you create a new version of a grant, such as activation override behavior. For more
 * information, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html">Granted
 * licenses in License Manager</a> in the <i>License Manager User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Options implements SdkPojo, Serializable, ToCopyableBuilder<Options.Builder, Options> {
    private static final SdkField<String> ACTIVATION_OVERRIDE_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActivationOverrideBehavior")
            .getter(getter(Options::activationOverrideBehaviorAsString))
            .setter(setter(Builder::activationOverrideBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationOverrideBehavior").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACTIVATION_OVERRIDE_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activationOverrideBehavior;

    private Options(BuilderImpl builder) {
        this.activationOverrideBehavior = builder.activationOverrideBehavior;
    }

    /**
     * <p>
     * An activation option for your grant that determines the behavior of activating a grant. Activation options can
     * only be used with granted licenses sourced from the Amazon Web Services Marketplace. Additionally, the operation
     * must specify the value of <code>ACTIVE</code> for the <code>Status</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when activating
     * a grant.
     * </p>
     * </li>
     * <li>
     * <p>
     * As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a grant for
     * a grantee account in your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * As a grantee, if the grantor creating the distributed grant doesn’t specify an
     * <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the grant.
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>DISTRIBUTED_GRANTS_ONLY</dt>
     * <dd>
     * <p>
     * Use this value to activate a grant without replacing any member account’s active grants for the same product.
     * </p>
     * </dd>
     * <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
     * <dd>
     * <p>
     * Use this value to activate a grant and disable other active grants in any member accounts for the same product.
     * This action will also replace their previously activated grants with this activated grant.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activationOverrideBehavior} will return {@link ActivationOverrideBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #activationOverrideBehaviorAsString}.
     * </p>
     * 
     * @return An activation option for your grant that determines the behavior of activating a grant. Activation
     *         options can only be used with granted licenses sourced from the Amazon Web Services Marketplace.
     *         Additionally, the operation must specify the value of <code>ACTIVE</code> for the <code>Status</code>
     *         parameter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
     *         activating a grant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a
     *         grant for a grantee account in your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         As a grantee, if the grantor creating the distributed grant doesn’t specify an
     *         <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the
     *         grant.
     *         </p>
     *         </li>
     *         </ul>
     *         <dl>
     *         <dt>DISTRIBUTED_GRANTS_ONLY</dt>
     *         <dd>
     *         <p>
     *         Use this value to activate a grant without replacing any member account’s active grants for the same
     *         product.
     *         </p>
     *         </dd>
     *         <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
     *         <dd>
     *         <p>
     *         Use this value to activate a grant and disable other active grants in any member accounts for the same
     *         product. This action will also replace their previously activated grants with this activated grant.
     *         </p>
     *         </dd>
     * @see ActivationOverrideBehavior
     */
    public final ActivationOverrideBehavior activationOverrideBehavior() {
        return ActivationOverrideBehavior.fromValue(activationOverrideBehavior);
    }

    /**
     * <p>
     * An activation option for your grant that determines the behavior of activating a grant. Activation options can
     * only be used with granted licenses sourced from the Amazon Web Services Marketplace. Additionally, the operation
     * must specify the value of <code>ACTIVE</code> for the <code>Status</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when activating
     * a grant.
     * </p>
     * </li>
     * <li>
     * <p>
     * As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a grant for
     * a grantee account in your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * As a grantee, if the grantor creating the distributed grant doesn’t specify an
     * <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the grant.
     * </p>
     * </li>
     * </ul>
     * <dl>
     * <dt>DISTRIBUTED_GRANTS_ONLY</dt>
     * <dd>
     * <p>
     * Use this value to activate a grant without replacing any member account’s active grants for the same product.
     * </p>
     * </dd>
     * <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
     * <dd>
     * <p>
     * Use this value to activate a grant and disable other active grants in any member accounts for the same product.
     * This action will also replace their previously activated grants with this activated grant.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activationOverrideBehavior} will return {@link ActivationOverrideBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #activationOverrideBehaviorAsString}.
     * </p>
     * 
     * @return An activation option for your grant that determines the behavior of activating a grant. Activation
     *         options can only be used with granted licenses sourced from the Amazon Web Services Marketplace.
     *         Additionally, the operation must specify the value of <code>ACTIVE</code> for the <code>Status</code>
     *         parameter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
     *         activating a grant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a
     *         grant for a grantee account in your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         As a grantee, if the grantor creating the distributed grant doesn’t specify an
     *         <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the
     *         grant.
     *         </p>
     *         </li>
     *         </ul>
     *         <dl>
     *         <dt>DISTRIBUTED_GRANTS_ONLY</dt>
     *         <dd>
     *         <p>
     *         Use this value to activate a grant without replacing any member account’s active grants for the same
     *         product.
     *         </p>
     *         </dd>
     *         <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
     *         <dd>
     *         <p>
     *         Use this value to activate a grant and disable other active grants in any member accounts for the same
     *         product. This action will also replace their previously activated grants with this activated grant.
     *         </p>
     *         </dd>
     * @see ActivationOverrideBehavior
     */
    public final String activationOverrideBehaviorAsString() {
        return activationOverrideBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationOverrideBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options) obj;
        return Objects.equals(activationOverrideBehaviorAsString(), other.activationOverrideBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Options").add("ActivationOverrideBehavior", activationOverrideBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationOverrideBehavior":
            return Optional.ofNullable(clazz.cast(activationOverrideBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Options, T> g) {
        return obj -> g.apply((Options) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Options> {
        /**
         * <p>
         * An activation option for your grant that determines the behavior of activating a grant. Activation options
         * can only be used with granted licenses sourced from the Amazon Web Services Marketplace. Additionally, the
         * operation must specify the value of <code>ACTIVE</code> for the <code>Status</code> parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
         * activating a grant.
         * </p>
         * </li>
         * <li>
         * <p>
         * As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a grant
         * for a grantee account in your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * As a grantee, if the grantor creating the distributed grant doesn’t specify an
         * <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the grant.
         * </p>
         * </li>
         * </ul>
         * <dl>
         * <dt>DISTRIBUTED_GRANTS_ONLY</dt>
         * <dd>
         * <p>
         * Use this value to activate a grant without replacing any member account’s active grants for the same product.
         * </p>
         * </dd>
         * <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
         * <dd>
         * <p>
         * Use this value to activate a grant and disable other active grants in any member accounts for the same
         * product. This action will also replace their previously activated grants with this activated grant.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param activationOverrideBehavior
         *        An activation option for your grant that determines the behavior of activating a grant. Activation
         *        options can only be used with granted licenses sourced from the Amazon Web Services Marketplace.
         *        Additionally, the operation must specify the value of <code>ACTIVE</code> for the <code>Status</code>
         *        parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
         *        activating a grant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate
         *        a grant for a grantee account in your organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        As a grantee, if the grantor creating the distributed grant doesn’t specify an
         *        <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the
         *        grant.
         *        </p>
         *        </li>
         *        </ul>
         *        <dl>
         *        <dt>DISTRIBUTED_GRANTS_ONLY</dt>
         *        <dd>
         *        <p>
         *        Use this value to activate a grant without replacing any member account’s active grants for the same
         *        product.
         *        </p>
         *        </dd>
         *        <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
         *        <dd>
         *        <p>
         *        Use this value to activate a grant and disable other active grants in any member accounts for the same
         *        product. This action will also replace their previously activated grants with this activated grant.
         *        </p>
         *        </dd>
         * @see ActivationOverrideBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationOverrideBehavior
         */
        Builder activationOverrideBehavior(String activationOverrideBehavior);

        /**
         * <p>
         * An activation option for your grant that determines the behavior of activating a grant. Activation options
         * can only be used with granted licenses sourced from the Amazon Web Services Marketplace. Additionally, the
         * operation must specify the value of <code>ACTIVE</code> for the <code>Status</code> parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
         * activating a grant.
         * </p>
         * </li>
         * <li>
         * <p>
         * As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate a grant
         * for a grantee account in your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * As a grantee, if the grantor creating the distributed grant doesn’t specify an
         * <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the grant.
         * </p>
         * </li>
         * </ul>
         * <dl>
         * <dt>DISTRIBUTED_GRANTS_ONLY</dt>
         * <dd>
         * <p>
         * Use this value to activate a grant without replacing any member account’s active grants for the same product.
         * </p>
         * </dd>
         * <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
         * <dd>
         * <p>
         * Use this value to activate a grant and disable other active grants in any member accounts for the same
         * product. This action will also replace their previously activated grants with this activated grant.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param activationOverrideBehavior
         *        An activation option for your grant that determines the behavior of activating a grant. Activation
         *        options can only be used with granted licenses sourced from the Amazon Web Services Marketplace.
         *        Additionally, the operation must specify the value of <code>ACTIVE</code> for the <code>Status</code>
         *        parameter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        As a license administrator, you can optionally specify an <code>ActivationOverrideBehavior</code> when
         *        activating a grant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        As a grantor, you can optionally specify an <code>ActivationOverrideBehavior</code> when you activate
         *        a grant for a grantee account in your organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        As a grantee, if the grantor creating the distributed grant doesn’t specify an
         *        <code>ActivationOverrideBehavior</code>, you can optionally specify one when you are activating the
         *        grant.
         *        </p>
         *        </li>
         *        </ul>
         *        <dl>
         *        <dt>DISTRIBUTED_GRANTS_ONLY</dt>
         *        <dd>
         *        <p>
         *        Use this value to activate a grant without replacing any member account’s active grants for the same
         *        product.
         *        </p>
         *        </dd>
         *        <dt>ALL_GRANTS_PERMITTED_BY_ISSUER</dt>
         *        <dd>
         *        <p>
         *        Use this value to activate a grant and disable other active grants in any member accounts for the same
         *        product. This action will also replace their previously activated grants with this activated grant.
         *        </p>
         *        </dd>
         * @see ActivationOverrideBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationOverrideBehavior
         */
        Builder activationOverrideBehavior(ActivationOverrideBehavior activationOverrideBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String activationOverrideBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Options model) {
            activationOverrideBehavior(model.activationOverrideBehavior);
        }

        public final String getActivationOverrideBehavior() {
            return activationOverrideBehavior;
        }

        public final void setActivationOverrideBehavior(String activationOverrideBehavior) {
            this.activationOverrideBehavior = activationOverrideBehavior;
        }

        @Override
        public final Builder activationOverrideBehavior(String activationOverrideBehavior) {
            this.activationOverrideBehavior = activationOverrideBehavior;
            return this;
        }

        @Override
        public final Builder activationOverrideBehavior(ActivationOverrideBehavior activationOverrideBehavior) {
            this.activationOverrideBehavior(activationOverrideBehavior == null ? null : activationOverrideBehavior.toString());
            return this;
        }

        @Override
        public Options build() {
            return new Options(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
