/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantAttributesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingState;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Participant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Participant> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(Participant.getter(Participant::participantId)).setter(Participant.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(Participant.getter(Participant::userId)).setter(Participant.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Participant.getter(Participant::stateAsString)).setter(Participant.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstJoinTime").getter(Participant.getter(Participant::firstJoinTime)).setter(Participant.setter(Builder::firstJoinTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(Participant.getter(Participant::attributes)).setter(Participant.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("published").getter(Participant.getter(Participant::published)).setter(Participant.setter(Builder::published)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()}).build();
    private static final SdkField<String> ISP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ispName").getter(Participant.getter(Participant::ispName)).setter(Participant.setter(Builder::ispName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ispName").build()}).build();
    private static final SdkField<String> OS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osName").getter(Participant.getter(Participant::osName)).setter(Participant.setter(Builder::osName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osName").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(Participant.getter(Participant::osVersion)).setter(Participant.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<String> BROWSER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserName").getter(Participant.getter(Participant::browserName)).setter(Participant.setter(Builder::browserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserName").build()}).build();
    private static final SdkField<String> BROWSER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserVersion").getter(Participant.getter(Participant::browserVersion)).setter(Participant.setter(Builder::browserVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserVersion").build()}).build();
    private static final SdkField<String> SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sdkVersion").getter(Participant.getter(Participant::sdkVersion)).setter(Participant.setter(Builder::sdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdkVersion").build()}).build();
    private static final SdkField<String> RECORDING_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingS3BucketName").getter(Participant.getter(Participant::recordingS3BucketName)).setter(Participant.setter(Builder::recordingS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingS3BucketName").build()}).build();
    private static final SdkField<String> RECORDING_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingS3Prefix").getter(Participant.getter(Participant::recordingS3Prefix)).setter(Participant.setter(Builder::recordingS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingS3Prefix").build()}).build();
    private static final SdkField<String> RECORDING_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordingState").getter(Participant.getter(Participant::recordingStateAsString)).setter(Participant.setter(Builder::recordingState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD, USER_ID_FIELD, STATE_FIELD, FIRST_JOIN_TIME_FIELD, ATTRIBUTES_FIELD, PUBLISHED_FIELD, ISP_NAME_FIELD, OS_NAME_FIELD, OS_VERSION_FIELD, BROWSER_NAME_FIELD, BROWSER_VERSION_FIELD, SDK_VERSION_FIELD, RECORDING_S3_BUCKET_NAME_FIELD, RECORDING_S3_PREFIX_FIELD, RECORDING_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String participantId;
    private final String userId;
    private final String state;
    private final Instant firstJoinTime;
    private final Map<String, String> attributes;
    private final Boolean published;
    private final String ispName;
    private final String osName;
    private final String osVersion;
    private final String browserName;
    private final String browserVersion;
    private final String sdkVersion;
    private final String recordingS3BucketName;
    private final String recordingS3Prefix;
    private final String recordingState;

    private Participant(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.userId = builder.userId;
        this.state = builder.state;
        this.firstJoinTime = builder.firstJoinTime;
        this.attributes = builder.attributes;
        this.published = builder.published;
        this.ispName = builder.ispName;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.browserName = builder.browserName;
        this.browserVersion = builder.browserVersion;
        this.sdkVersion = builder.sdkVersion;
        this.recordingS3BucketName = builder.recordingS3BucketName;
        this.recordingS3Prefix = builder.recordingS3Prefix;
        this.recordingState = builder.recordingState;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String userId() {
        return this.userId;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant firstJoinTime() {
        return this.firstJoinTime;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final Boolean published() {
        return this.published;
    }

    public final String ispName() {
        return this.ispName;
    }

    public final String osName() {
        return this.osName;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final String browserName() {
        return this.browserName;
    }

    public final String browserVersion() {
        return this.browserVersion;
    }

    public final String sdkVersion() {
        return this.sdkVersion;
    }

    public final String recordingS3BucketName() {
        return this.recordingS3BucketName;
    }

    public final String recordingS3Prefix() {
        return this.recordingS3Prefix;
    }

    public final ParticipantRecordingState recordingState() {
        return ParticipantRecordingState.fromValue(this.recordingState);
    }

    public final String recordingStateAsString() {
        return this.recordingState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.published());
        hashCode = 31 * hashCode + Objects.hashCode(this.ispName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)obj;
        return Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.firstJoinTime(), other.firstJoinTime()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.published(), other.published()) && Objects.equals(this.ispName(), other.ispName()) && Objects.equals(this.osName(), other.osName()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.browserName(), other.browserName()) && Objects.equals(this.browserVersion(), other.browserVersion()) && Objects.equals(this.sdkVersion(), other.sdkVersion()) && Objects.equals(this.recordingS3BucketName(), other.recordingS3BucketName()) && Objects.equals(this.recordingS3Prefix(), other.recordingS3Prefix()) && Objects.equals(this.recordingStateAsString(), other.recordingStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Participant").add("ParticipantId", (Object)this.participantId()).add("UserId", (Object)this.userId()).add("State", (Object)this.stateAsString()).add("FirstJoinTime", (Object)this.firstJoinTime()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Published", (Object)this.published()).add("IspName", (Object)this.ispName()).add("OsName", (Object)this.osName()).add("OsVersion", (Object)this.osVersion()).add("BrowserName", (Object)this.browserName()).add("BrowserVersion", (Object)this.browserVersion()).add("SdkVersion", (Object)this.sdkVersion()).add("RecordingS3BucketName", (Object)this.recordingS3BucketName()).add("RecordingS3Prefix", (Object)this.recordingS3Prefix()).add("RecordingState", (Object)this.recordingStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "firstJoinTime": {
                return Optional.ofNullable(clazz.cast(this.firstJoinTime()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "published": {
                return Optional.ofNullable(clazz.cast(this.published()));
            }
            case "ispName": {
                return Optional.ofNullable(clazz.cast(this.ispName()));
            }
            case "osName": {
                return Optional.ofNullable(clazz.cast(this.osName()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "browserName": {
                return Optional.ofNullable(clazz.cast(this.browserName()));
            }
            case "browserVersion": {
                return Optional.ofNullable(clazz.cast(this.browserVersion()));
            }
            case "sdkVersion": {
                return Optional.ofNullable(clazz.cast(this.sdkVersion()));
            }
            case "recordingS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.recordingS3BucketName()));
            }
            case "recordingS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.recordingS3Prefix()));
            }
            case "recordingState": {
                return Optional.ofNullable(clazz.cast(this.recordingStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantId;
        private String userId;
        private String state;
        private Instant firstJoinTime;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Boolean published;
        private String ispName;
        private String osName;
        private String osVersion;
        private String browserName;
        private String browserVersion;
        private String sdkVersion;
        private String recordingS3BucketName;
        private String recordingS3Prefix;
        private String recordingState;

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            this.participantId(model.participantId);
            this.userId(model.userId);
            this.state(model.state);
            this.firstJoinTime(model.firstJoinTime);
            this.attributes(model.attributes);
            this.published(model.published);
            this.ispName(model.ispName);
            this.osName(model.osName);
            this.osVersion(model.osVersion);
            this.browserName(model.browserName);
            this.browserVersion(model.browserVersion);
            this.sdkVersion(model.sdkVersion);
            this.recordingS3BucketName(model.recordingS3BucketName);
            this.recordingS3Prefix(model.recordingS3Prefix);
            this.recordingState(model.recordingState);
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getFirstJoinTime() {
            return this.firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final Boolean getPublished() {
            return this.published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getIspName() {
            return this.ispName;
        }

        public final void setIspName(String ispName) {
            this.ispName = ispName;
        }

        @Override
        public final Builder ispName(String ispName) {
            this.ispName = ispName;
            return this;
        }

        public final String getOsName() {
            return this.osName;
        }

        public final void setOsName(String osName) {
            this.osName = osName;
        }

        @Override
        public final Builder osName(String osName) {
            this.osName = osName;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getBrowserName() {
            return this.browserName;
        }

        public final void setBrowserName(String browserName) {
            this.browserName = browserName;
        }

        @Override
        public final Builder browserName(String browserName) {
            this.browserName = browserName;
            return this;
        }

        public final String getBrowserVersion() {
            return this.browserVersion;
        }

        public final void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        @Override
        public final Builder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public final String getSdkVersion() {
            return this.sdkVersion;
        }

        public final void setSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
        }

        @Override
        public final Builder sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public final String getRecordingS3BucketName() {
            return this.recordingS3BucketName;
        }

        public final void setRecordingS3BucketName(String recordingS3BucketName) {
            this.recordingS3BucketName = recordingS3BucketName;
        }

        @Override
        public final Builder recordingS3BucketName(String recordingS3BucketName) {
            this.recordingS3BucketName = recordingS3BucketName;
            return this;
        }

        public final String getRecordingS3Prefix() {
            return this.recordingS3Prefix;
        }

        public final void setRecordingS3Prefix(String recordingS3Prefix) {
            this.recordingS3Prefix = recordingS3Prefix;
        }

        @Override
        public final Builder recordingS3Prefix(String recordingS3Prefix) {
            this.recordingS3Prefix = recordingS3Prefix;
            return this;
        }

        public final String getRecordingState() {
            return this.recordingState;
        }

        public final void setRecordingState(String recordingState) {
            this.recordingState = recordingState;
        }

        @Override
        public final Builder recordingState(String recordingState) {
            this.recordingState = recordingState;
            return this;
        }

        @Override
        public final Builder recordingState(ParticipantRecordingState recordingState) {
            this.recordingState(recordingState == null ? null : recordingState.toString());
            return this;
        }

        public Participant build() {
            return new Participant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Participant> {
        public Builder participantId(String var1);

        public Builder userId(String var1);

        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder firstJoinTime(Instant var1);

        public Builder attributes(Map<String, String> var1);

        public Builder published(Boolean var1);

        public Builder ispName(String var1);

        public Builder osName(String var1);

        public Builder osVersion(String var1);

        public Builder browserName(String var1);

        public Builder browserVersion(String var1);

        public Builder sdkVersion(String var1);

        public Builder recordingS3BucketName(String var1);

        public Builder recordingS3Prefix(String var1);

        public Builder recordingState(String var1);

        public Builder recordingState(ParticipantRecordingState var1);
    }
}

