/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelCompositeModelsResponse;

public class ListAssetModelCompositeModelsPublisher
implements SdkPublisher<ListAssetModelCompositeModelsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssetModelCompositeModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetModelCompositeModelsPublisher(IoTSiteWiseAsyncClient client, ListAssetModelCompositeModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetModelCompositeModelsPublisher(IoTSiteWiseAsyncClient client, ListAssetModelCompositeModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetModelCompositeModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetModelCompositeModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries() {
        Function<ListAssetModelCompositeModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelCompositeModelSummaries() != null) {
                return response.assetModelCompositeModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetModelCompositeModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetModelCompositeModelsResponseFetcher
    implements AsyncPageFetcher<ListAssetModelCompositeModelsResponse> {
        private ListAssetModelCompositeModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelCompositeModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetModelCompositeModelsResponse> nextPage(ListAssetModelCompositeModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelCompositeModelsPublisher.this.client.listAssetModelCompositeModels(ListAssetModelCompositeModelsPublisher.this.firstRequest);
            }
            return ListAssetModelCompositeModelsPublisher.this.client.listAssetModelCompositeModels((ListAssetModelCompositeModelsRequest)((Object)ListAssetModelCompositeModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

