/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelPropertySummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetModelPropertiesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListAssetModelPropertiesResponse> {
    private static final SdkField<List<AssetModelPropertySummary>> ASSET_MODEL_PROPERTY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetModelPropertySummaries").getter(ListAssetModelPropertiesResponse.getter(ListAssetModelPropertiesResponse::assetModelPropertySummaries)).setter(ListAssetModelPropertiesResponse.setter(Builder::assetModelPropertySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelPropertySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetModelPropertySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssetModelPropertiesResponse.getter(ListAssetModelPropertiesResponse::nextToken)).setter(ListAssetModelPropertiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_PROPERTY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssetModelPropertySummary> assetModelPropertySummaries;
    private final String nextToken;

    private ListAssetModelPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelPropertySummaries = builder.assetModelPropertySummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssetModelPropertySummaries() {
        return this.assetModelPropertySummaries != null && !(this.assetModelPropertySummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetModelPropertySummary> assetModelPropertySummaries() {
        return this.assetModelPropertySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetModelPropertySummaries() ? this.assetModelPropertySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetModelPropertiesResponse)) {
            return false;
        }
        ListAssetModelPropertiesResponse other = (ListAssetModelPropertiesResponse)((Object)obj);
        return this.hasAssetModelPropertySummaries() == other.hasAssetModelPropertySummaries() && Objects.equals(this.assetModelPropertySummaries(), other.assetModelPropertySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetModelPropertiesResponse").add("AssetModelPropertySummaries", this.hasAssetModelPropertySummaries() ? this.assetModelPropertySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelPropertySummaries": {
                return Optional.ofNullable(clazz.cast(this.assetModelPropertySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetModelPropertiesResponse, T> g) {
        return obj -> g.apply((ListAssetModelPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<AssetModelPropertySummary> assetModelPropertySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetModelPropertiesResponse model) {
            super(model);
            this.assetModelPropertySummaries(model.assetModelPropertySummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AssetModelPropertySummary.Builder> getAssetModelPropertySummaries() {
            List<AssetModelPropertySummary.Builder> result = AssetModelPropertySummariesCopier.copyToBuilder(this.assetModelPropertySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelPropertySummaries(Collection<AssetModelPropertySummary.BuilderImpl> assetModelPropertySummaries) {
            this.assetModelPropertySummaries = AssetModelPropertySummariesCopier.copyFromBuilder(assetModelPropertySummaries);
        }

        @Override
        public final Builder assetModelPropertySummaries(Collection<AssetModelPropertySummary> assetModelPropertySummaries) {
            this.assetModelPropertySummaries = AssetModelPropertySummariesCopier.copy(assetModelPropertySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelPropertySummaries(AssetModelPropertySummary ... assetModelPropertySummaries) {
            this.assetModelPropertySummaries(Arrays.asList(assetModelPropertySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelPropertySummaries(Consumer<AssetModelPropertySummary.Builder> ... assetModelPropertySummaries) {
            this.assetModelPropertySummaries(Stream.of(assetModelPropertySummaries).map(c -> (AssetModelPropertySummary)((AssetModelPropertySummary.Builder)AssetModelPropertySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetModelPropertiesResponse build() {
            return new ListAssetModelPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetModelPropertiesResponse> {
        public Builder assetModelPropertySummaries(Collection<AssetModelPropertySummary> var1);

        public Builder assetModelPropertySummaries(AssetModelPropertySummary ... var1);

        public Builder assetModelPropertySummaries(Consumer<AssetModelPropertySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

