/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModel;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetHierarchiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetProperty;
import software.amazon.awssdk.services.iotsitewise.model.AssetStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetId)).setter(DescribeAssetResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetArn").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetArn)).setter(DescribeAssetResponse.setter(Builder::assetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetArn").build()}).build();
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetName").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetName)).setter(DescribeAssetResponse.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()}).build();
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetModelId)).setter(DescribeAssetResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<List<AssetProperty>> ASSET_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetProperties").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetProperties)).setter(DescribeAssetResponse.setter(Builder::assetProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetHierarchy>> ASSET_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetHierarchies").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetHierarchies)).setter(DescribeAssetResponse.setter(Builder::assetHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetCompositeModel>> ASSET_COMPOSITE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetCompositeModels").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetCompositeModels)).setter(DescribeAssetResponse.setter(Builder::assetCompositeModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetCompositeModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> ASSET_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("assetCreationDate").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetCreationDate)).setter(DescribeAssetResponse.setter(Builder::assetCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCreationDate").build()}).build();
    private static final SdkField<Instant> ASSET_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("assetLastUpdateDate").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetLastUpdateDate)).setter(DescribeAssetResponse.setter(Builder::assetLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetLastUpdateDate").build()}).build();
    private static final SdkField<AssetStatus> ASSET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetStatus").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetStatus)).setter(DescribeAssetResponse.setter(Builder::assetStatus)).constructor(AssetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetStatus").build()}).build();
    private static final SdkField<String> ASSET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetDescription").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetDescription)).setter(DescribeAssetResponse.setter(Builder::assetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetDescription").build()}).build();
    private static final SdkField<List<AssetCompositeModelSummary>> ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetCompositeModelSummaries").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetCompositeModelSummaries)).setter(DescribeAssetResponse.setter(Builder::assetCompositeModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetCompositeModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetExternalId").getter(DescribeAssetResponse.getter(DescribeAssetResponse::assetExternalId)).setter(DescribeAssetResponse.setter(Builder::assetExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_ARN_FIELD, ASSET_NAME_FIELD, ASSET_MODEL_ID_FIELD, ASSET_PROPERTIES_FIELD, ASSET_HIERARCHIES_FIELD, ASSET_COMPOSITE_MODELS_FIELD, ASSET_CREATION_DATE_FIELD, ASSET_LAST_UPDATE_DATE_FIELD, ASSET_STATUS_FIELD, ASSET_DESCRIPTION_FIELD, ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD, ASSET_EXTERNAL_ID_FIELD));
    private final String assetId;
    private final String assetArn;
    private final String assetName;
    private final String assetModelId;
    private final List<AssetProperty> assetProperties;
    private final List<AssetHierarchy> assetHierarchies;
    private final List<AssetCompositeModel> assetCompositeModels;
    private final Instant assetCreationDate;
    private final Instant assetLastUpdateDate;
    private final AssetStatus assetStatus;
    private final String assetDescription;
    private final List<AssetCompositeModelSummary> assetCompositeModelSummaries;
    private final String assetExternalId;

    private DescribeAssetResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetArn = builder.assetArn;
        this.assetName = builder.assetName;
        this.assetModelId = builder.assetModelId;
        this.assetProperties = builder.assetProperties;
        this.assetHierarchies = builder.assetHierarchies;
        this.assetCompositeModels = builder.assetCompositeModels;
        this.assetCreationDate = builder.assetCreationDate;
        this.assetLastUpdateDate = builder.assetLastUpdateDate;
        this.assetStatus = builder.assetStatus;
        this.assetDescription = builder.assetDescription;
        this.assetCompositeModelSummaries = builder.assetCompositeModelSummaries;
        this.assetExternalId = builder.assetExternalId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetArn() {
        return this.assetArn;
    }

    public final String assetName() {
        return this.assetName;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final boolean hasAssetProperties() {
        return this.assetProperties != null && !(this.assetProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetProperty> assetProperties() {
        return this.assetProperties;
    }

    public final boolean hasAssetHierarchies() {
        return this.assetHierarchies != null && !(this.assetHierarchies instanceof SdkAutoConstructList);
    }

    public final List<AssetHierarchy> assetHierarchies() {
        return this.assetHierarchies;
    }

    public final boolean hasAssetCompositeModels() {
        return this.assetCompositeModels != null && !(this.assetCompositeModels instanceof SdkAutoConstructList);
    }

    public final List<AssetCompositeModel> assetCompositeModels() {
        return this.assetCompositeModels;
    }

    public final Instant assetCreationDate() {
        return this.assetCreationDate;
    }

    public final Instant assetLastUpdateDate() {
        return this.assetLastUpdateDate;
    }

    public final AssetStatus assetStatus() {
        return this.assetStatus;
    }

    public final String assetDescription() {
        return this.assetDescription;
    }

    public final boolean hasAssetCompositeModelSummaries() {
        return this.assetCompositeModelSummaries != null && !(this.assetCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetCompositeModelSummary> assetCompositeModelSummaries() {
        return this.assetCompositeModelSummaries;
    }

    public final String assetExternalId() {
        return this.assetExternalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetProperties() ? this.assetProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetHierarchies() ? this.assetHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetCompositeModels() ? this.assetCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetCompositeModelSummaries() ? this.assetCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assetExternalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetResponse)) {
            return false;
        }
        DescribeAssetResponse other = (DescribeAssetResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetArn(), other.assetArn()) && Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.assetModelId(), other.assetModelId()) && this.hasAssetProperties() == other.hasAssetProperties() && Objects.equals(this.assetProperties(), other.assetProperties()) && this.hasAssetHierarchies() == other.hasAssetHierarchies() && Objects.equals(this.assetHierarchies(), other.assetHierarchies()) && this.hasAssetCompositeModels() == other.hasAssetCompositeModels() && Objects.equals(this.assetCompositeModels(), other.assetCompositeModels()) && Objects.equals(this.assetCreationDate(), other.assetCreationDate()) && Objects.equals(this.assetLastUpdateDate(), other.assetLastUpdateDate()) && Objects.equals(this.assetStatus(), other.assetStatus()) && Objects.equals(this.assetDescription(), other.assetDescription()) && this.hasAssetCompositeModelSummaries() == other.hasAssetCompositeModelSummaries() && Objects.equals(this.assetCompositeModelSummaries(), other.assetCompositeModelSummaries()) && Objects.equals(this.assetExternalId(), other.assetExternalId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetResponse").add("AssetId", (Object)this.assetId()).add("AssetArn", (Object)this.assetArn()).add("AssetName", (Object)this.assetName()).add("AssetModelId", (Object)this.assetModelId()).add("AssetProperties", this.hasAssetProperties() ? this.assetProperties() : null).add("AssetHierarchies", this.hasAssetHierarchies() ? this.assetHierarchies() : null).add("AssetCompositeModels", this.hasAssetCompositeModels() ? this.assetCompositeModels() : null).add("AssetCreationDate", (Object)this.assetCreationDate()).add("AssetLastUpdateDate", (Object)this.assetLastUpdateDate()).add("AssetStatus", (Object)this.assetStatus()).add("AssetDescription", (Object)this.assetDescription()).add("AssetCompositeModelSummaries", this.hasAssetCompositeModelSummaries() ? this.assetCompositeModelSummaries() : null).add("AssetExternalId", (Object)this.assetExternalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetArn": {
                return Optional.ofNullable(clazz.cast(this.assetArn()));
            }
            case "assetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "assetProperties": {
                return Optional.ofNullable(clazz.cast(this.assetProperties()));
            }
            case "assetHierarchies": {
                return Optional.ofNullable(clazz.cast(this.assetHierarchies()));
            }
            case "assetCompositeModels": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModels()));
            }
            case "assetCreationDate": {
                return Optional.ofNullable(clazz.cast(this.assetCreationDate()));
            }
            case "assetLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.assetLastUpdateDate()));
            }
            case "assetStatus": {
                return Optional.ofNullable(clazz.cast(this.assetStatus()));
            }
            case "assetDescription": {
                return Optional.ofNullable(clazz.cast(this.assetDescription()));
            }
            case "assetCompositeModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelSummaries()));
            }
            case "assetExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetExternalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetResponse, T> g) {
        return obj -> g.apply((DescribeAssetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetArn;
        private String assetName;
        private String assetModelId;
        private List<AssetProperty> assetProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetHierarchy> assetHierarchies = DefaultSdkAutoConstructList.getInstance();
        private List<AssetCompositeModel> assetCompositeModels = DefaultSdkAutoConstructList.getInstance();
        private Instant assetCreationDate;
        private Instant assetLastUpdateDate;
        private AssetStatus assetStatus;
        private String assetDescription;
        private List<AssetCompositeModelSummary> assetCompositeModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String assetExternalId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.assetArn(model.assetArn);
            this.assetName(model.assetName);
            this.assetModelId(model.assetModelId);
            this.assetProperties(model.assetProperties);
            this.assetHierarchies(model.assetHierarchies);
            this.assetCompositeModels(model.assetCompositeModels);
            this.assetCreationDate(model.assetCreationDate);
            this.assetLastUpdateDate(model.assetLastUpdateDate);
            this.assetStatus(model.assetStatus);
            this.assetDescription(model.assetDescription);
            this.assetCompositeModelSummaries(model.assetCompositeModelSummaries);
            this.assetExternalId(model.assetExternalId);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetArn() {
            return this.assetArn;
        }

        public final void setAssetArn(String assetArn) {
            this.assetArn = assetArn;
        }

        @Override
        public final Builder assetArn(String assetArn) {
            this.assetArn = assetArn;
            return this;
        }

        public final String getAssetName() {
            return this.assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final List<AssetProperty.Builder> getAssetProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.assetProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetProperties(Collection<AssetProperty.BuilderImpl> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copyFromBuilder(assetProperties);
        }

        @Override
        public final Builder assetProperties(Collection<AssetProperty> assetProperties) {
            this.assetProperties = AssetPropertiesCopier.copy(assetProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(AssetProperty ... assetProperties) {
            this.assetProperties(Arrays.asList(assetProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetProperties(Consumer<AssetProperty.Builder> ... assetProperties) {
            this.assetProperties(Stream.of(assetProperties).map(c -> (AssetProperty)((AssetProperty.Builder)AssetProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetHierarchy.Builder> getAssetHierarchies() {
            List<AssetHierarchy.Builder> result = AssetHierarchiesCopier.copyToBuilder(this.assetHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetHierarchies(Collection<AssetHierarchy.BuilderImpl> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copyFromBuilder(assetHierarchies);
        }

        @Override
        public final Builder assetHierarchies(Collection<AssetHierarchy> assetHierarchies) {
            this.assetHierarchies = AssetHierarchiesCopier.copy(assetHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(AssetHierarchy ... assetHierarchies) {
            this.assetHierarchies(Arrays.asList(assetHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetHierarchies(Consumer<AssetHierarchy.Builder> ... assetHierarchies) {
            this.assetHierarchies(Stream.of(assetHierarchies).map(c -> (AssetHierarchy)((AssetHierarchy.Builder)AssetHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetCompositeModel.Builder> getAssetCompositeModels() {
            List<AssetCompositeModel.Builder> result = AssetCompositeModelsCopier.copyToBuilder(this.assetCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModels(Collection<AssetCompositeModel.BuilderImpl> assetCompositeModels) {
            this.assetCompositeModels = AssetCompositeModelsCopier.copyFromBuilder(assetCompositeModels);
        }

        @Override
        public final Builder assetCompositeModels(Collection<AssetCompositeModel> assetCompositeModels) {
            this.assetCompositeModels = AssetCompositeModelsCopier.copy(assetCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModels(AssetCompositeModel ... assetCompositeModels) {
            this.assetCompositeModels(Arrays.asList(assetCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModels(Consumer<AssetCompositeModel.Builder> ... assetCompositeModels) {
            this.assetCompositeModels(Stream.of(assetCompositeModels).map(c -> (AssetCompositeModel)((AssetCompositeModel.Builder)AssetCompositeModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getAssetCreationDate() {
            return this.assetCreationDate;
        }

        public final void setAssetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
        }

        @Override
        public final Builder assetCreationDate(Instant assetCreationDate) {
            this.assetCreationDate = assetCreationDate;
            return this;
        }

        public final Instant getAssetLastUpdateDate() {
            return this.assetLastUpdateDate;
        }

        public final void setAssetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
        }

        @Override
        public final Builder assetLastUpdateDate(Instant assetLastUpdateDate) {
            this.assetLastUpdateDate = assetLastUpdateDate;
            return this;
        }

        public final AssetStatus.Builder getAssetStatus() {
            return this.assetStatus != null ? this.assetStatus.toBuilder() : null;
        }

        public final void setAssetStatus(AssetStatus.BuilderImpl assetStatus) {
            this.assetStatus = assetStatus != null ? assetStatus.build() : null;
        }

        @Override
        public final Builder assetStatus(AssetStatus assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public final String getAssetDescription() {
            return this.assetDescription;
        }

        public final void setAssetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
        }

        @Override
        public final Builder assetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        public final List<AssetCompositeModelSummary.Builder> getAssetCompositeModelSummaries() {
            List<AssetCompositeModelSummary.Builder> result = AssetCompositeModelSummariesCopier.copyToBuilder(this.assetCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelSummaries(Collection<AssetCompositeModelSummary.BuilderImpl> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copyFromBuilder(assetCompositeModelSummaries);
        }

        @Override
        public final Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copy(assetCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(AssetCompositeModelSummary ... assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries(Arrays.asList(assetCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder> ... assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries(Stream.of(assetCompositeModelSummaries).map(c -> (AssetCompositeModelSummary)((AssetCompositeModelSummary.Builder)AssetCompositeModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssetExternalId() {
            return this.assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        @Override
        public DescribeAssetResponse build() {
            return new DescribeAssetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetResponse> {
        public Builder assetId(String var1);

        public Builder assetArn(String var1);

        public Builder assetName(String var1);

        public Builder assetModelId(String var1);

        public Builder assetProperties(Collection<AssetProperty> var1);

        public Builder assetProperties(AssetProperty ... var1);

        public Builder assetProperties(Consumer<AssetProperty.Builder> ... var1);

        public Builder assetHierarchies(Collection<AssetHierarchy> var1);

        public Builder assetHierarchies(AssetHierarchy ... var1);

        public Builder assetHierarchies(Consumer<AssetHierarchy.Builder> ... var1);

        public Builder assetCompositeModels(Collection<AssetCompositeModel> var1);

        public Builder assetCompositeModels(AssetCompositeModel ... var1);

        public Builder assetCompositeModels(Consumer<AssetCompositeModel.Builder> ... var1);

        public Builder assetCreationDate(Instant var1);

        public Builder assetLastUpdateDate(Instant var1);

        public Builder assetStatus(AssetStatus var1);

        default public Builder assetStatus(Consumer<AssetStatus.Builder> assetStatus) {
            return this.assetStatus((AssetStatus)((AssetStatus.Builder)AssetStatus.builder().applyMutation(assetStatus)).build());
        }

        public Builder assetDescription(String var1);

        public Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> var1);

        public Builder assetCompositeModelSummaries(AssetCompositeModelSummary ... var1);

        public Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder> ... var1);

        public Builder assetExternalId(String var1);
    }
}

