/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single row in the query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Row implements SdkPojo, Serializable, ToCopyableBuilder<Row.Builder, Row> {
    private static final SdkField<List<Datum>> DATA_FIELD = SdkField
            .<List<Datum>> builder(MarshallingType.LIST)
            .memberName("data")
            .getter(getter(Row::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Datum> builder(MarshallingType.SDK_POJO)
                                            .constructor(Datum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Datum> data;

    private Row(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * For responses, this returns true if the service returned a value for the Data property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of data points in a single row of the result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasData} method.
     * </p>
     * 
     * @return List of data points in a single row of the result set.
     */
    public final List<Datum> data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row) obj;
        return hasData() == other.hasData() && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Row").add("Data", hasData() ? data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Row> {
        /**
         * <p>
         * List of data points in a single row of the result set.
         * </p>
         * 
         * @param data
         *        List of data points in a single row of the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<Datum> data);

        /**
         * <p>
         * List of data points in a single row of the result set.
         * </p>
         * 
         * @param data
         *        List of data points in a single row of the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Datum... data);

        /**
         * <p>
         * List of data points in a single row of the result set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.Datum.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotsitewise.model.Datum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.Datum.Builder#build()} is called immediately and its
         * result is passed to {@link #data(List<Datum>)}.
         * 
         * @param data
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.Datum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(java.util.Collection<Datum>)
         */
        Builder data(Consumer<Datum.Builder>... data);
    }

    static final class BuilderImpl implements Builder {
        private List<Datum> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            data(model.data);
        }

        public final List<Datum.Builder> getData() {
            List<Datum.Builder> result = DatumListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<Datum.BuilderImpl> data) {
            this.data = DatumListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<Datum> data) {
            this.data = DatumListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Datum... data) {
            data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<Datum.Builder>... data) {
            data(Stream.of(data).map(c -> Datum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Row build() {
            return new Row(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
