/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains asset property value notification information. When the notification state is enabled, IoT SiteWise
 * publishes property value updates to a unique MQTT topic. For more information, see <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting with
 * other services</a> in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyNotification.Builder, PropertyNotification> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(PropertyNotification::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(PropertyNotification::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topic;

    private final String state;

    private PropertyNotification(BuilderImpl builder) {
        this.topic = builder.topic;
        this.state = builder.state;
    }

    /**
     * <p>
     * The MQTT topic to which IoT SiteWise publishes property value update notifications.
     * </p>
     * 
     * @return The MQTT topic to which IoT SiteWise publishes property value update notifications.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The current notification state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PropertyNotificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current notification state.
     * @see PropertyNotificationState
     */
    public final PropertyNotificationState state() {
        return PropertyNotificationState.fromValue(state);
    }

    /**
     * <p>
     * The current notification state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PropertyNotificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current notification state.
     * @see PropertyNotificationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyNotification)) {
            return false;
        }
        PropertyNotification other = (PropertyNotification) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyNotification").add("Topic", topic()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyNotification, T> g) {
        return obj -> g.apply((PropertyNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyNotification> {
        /**
         * <p>
         * The MQTT topic to which IoT SiteWise publishes property value update notifications.
         * </p>
         * 
         * @param topic
         *        The MQTT topic to which IoT SiteWise publishes property value update notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The current notification state.
         * </p>
         * 
         * @param state
         *        The current notification state.
         * @see PropertyNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyNotificationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current notification state.
         * </p>
         * 
         * @param state
         *        The current notification state.
         * @see PropertyNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyNotificationState
         */
        Builder state(PropertyNotificationState state);
    }

    static final class BuilderImpl implements Builder {
        private String topic;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyNotification model) {
            topic(model.topic);
            state(model.state);
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PropertyNotificationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public PropertyNotification build() {
            return new PropertyNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
