/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains aggregated asset property values (for example, average, minimum, and maximum).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatedValue implements SdkPojo, Serializable, ToCopyableBuilder<AggregatedValue.Builder, AggregatedValue> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(AggregatedValue::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("quality")
            .getter(getter(AggregatedValue::qualityAsString)).setter(setter(Builder::quality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()).build();

    private static final SdkField<Aggregates> VALUE_FIELD = SdkField.<Aggregates> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(AggregatedValue::value)).setter(setter(Builder::value))
            .constructor(Aggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            QUALITY_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String quality;

    private final Aggregates value;

    private AggregatedValue(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
        this.value = builder.value;
    }

    /**
     * <p>
     * The date the aggregating computations occurred, in Unix epoch time.
     * </p>
     * 
     * @return The date the aggregating computations occurred, in Unix epoch time.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The quality of the aggregated data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the aggregated data.
     * @see Quality
     */
    public final Quality quality() {
        return Quality.fromValue(quality);
    }

    /**
     * <p>
     * The quality of the aggregated data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the aggregated data.
     * @see Quality
     */
    public final String qualityAsString() {
        return quality;
    }

    /**
     * <p>
     * The value of the aggregates.
     * </p>
     * 
     * @return The value of the aggregates.
     */
    public final Aggregates value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(qualityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedValue)) {
            return false;
        }
        AggregatedValue other = (AggregatedValue) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(qualityAsString(), other.qualityAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregatedValue").add("Timestamp", timestamp()).add("Quality", qualityAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "quality":
            return Optional.ofNullable(clazz.cast(qualityAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedValue, T> g) {
        return obj -> g.apply((AggregatedValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatedValue> {
        /**
         * <p>
         * The date the aggregating computations occurred, in Unix epoch time.
         * </p>
         * 
         * @param timestamp
         *        The date the aggregating computations occurred, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The quality of the aggregated data.
         * </p>
         * 
         * @param quality
         *        The quality of the aggregated data.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(String quality);

        /**
         * <p>
         * The quality of the aggregated data.
         * </p>
         * 
         * @param quality
         *        The quality of the aggregated data.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(Quality quality);

        /**
         * <p>
         * The value of the aggregates.
         * </p>
         * 
         * @param value
         *        The value of the aggregates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Aggregates value);

        /**
         * <p>
         * The value of the aggregates.
         * </p>
         * This is a convenience method that creates an instance of the {@link Aggregates.Builder} avoiding the need to
         * create one manually via {@link Aggregates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Aggregates.Builder#build()} is called immediately and its result
         * is passed to {@link #value(Aggregates)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Aggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Aggregates)
         */
        default Builder value(Consumer<Aggregates.Builder> value) {
            return value(Aggregates.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String quality;

        private Aggregates value;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedValue model) {
            timestamp(model.timestamp);
            quality(model.quality);
            value(model.value);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getQuality() {
            return quality;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        @Override
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final Aggregates.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(Aggregates.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Aggregates value) {
            this.value = value;
            return this;
        }

        @Override
        public AggregatedValue build() {
            return new AggregatedValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
