/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an asset property value (of a single type).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertyVariant implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertyVariant.Builder, AssetPropertyVariant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(AssetPropertyVariant::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<String> INTEGER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integerValue").getter(getter(AssetPropertyVariant::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<String> DOUBLE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("doubleValue").getter(getter(AssetPropertyVariant::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<String> BOOLEAN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("booleanValue").getter(getter(AssetPropertyVariant::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final String integerValue;

    private final String doubleValue;

    private final String booleanValue;

    private final Type type;

    private AssetPropertyVariant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * Optional. The string value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @return Optional. The string value of the value entry. Accepts substitution templates.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @return Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
     */
    public final String integerValue() {
        return integerValue;
    }

    /**
     * <p>
     * Optional. A string that contains the double value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @return Optional. A string that contains the double value of the value entry. Accepts substitution templates.
     */
    public final String doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value entry.
     * Accepts substitution templates.
     * </p>
     * 
     * @return Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value
     *         entry. Accepts substitution templates.
     */
    public final String booleanValue() {
        return booleanValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyVariant)) {
            return false;
        }
        AssetPropertyVariant other = (AssetPropertyVariant) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(integerValue(), other.integerValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(booleanValue(), other.booleanValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertyVariant").add("StringValue", stringValue()).add("IntegerValue", integerValue())
                .add("DoubleValue", doubleValue()).add("BooleanValue", booleanValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * Optional. The string value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @param stringValue
     *        Optional. The string value of the value entry. Accepts substitution templates.
     */
    public static AssetPropertyVariant fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #integerValue()} initialized to the given value.
     *
     * <p>
     * Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @param integerValue
     *        Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
     */
    public static AssetPropertyVariant fromIntegerValue(String integerValue) {
        return builder().integerValue(integerValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * Optional. A string that contains the double value of the value entry. Accepts substitution templates.
     * </p>
     * 
     * @param doubleValue
     *        Optional. A string that contains the double value of the value entry. Accepts substitution templates.
     */
    public static AssetPropertyVariant fromDoubleValue(String doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value entry.
     * Accepts substitution templates.
     * </p>
     * 
     * @param booleanValue
     *        Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value
     *        entry. Accepts substitution templates.
     */
    public static AssetPropertyVariant fromBooleanValue(String booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyVariant, T> g) {
        return obj -> g.apply((AssetPropertyVariant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertyVariant> {
        /**
         * <p>
         * Optional. The string value of the value entry. Accepts substitution templates.
         * </p>
         * 
         * @param stringValue
         *        Optional. The string value of the value entry. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
         * </p>
         * 
         * @param integerValue
         *        Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(String integerValue);

        /**
         * <p>
         * Optional. A string that contains the double value of the value entry. Accepts substitution templates.
         * </p>
         * 
         * @param doubleValue
         *        Optional. A string that contains the double value of the value entry. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(String doubleValue);

        /**
         * <p>
         * Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value
         * entry. Accepts substitution templates.
         * </p>
         * 
         * @param booleanValue
         *        Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the
         *        value entry. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(String booleanValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private String integerValue;

        private String doubleValue;

        private String booleanValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyVariant model) {
            stringValue(model.stringValue);
            integerValue(model.integerValue);
            doubleValue(model.doubleValue);
            booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final String getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(String integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(String integerValue) {
            Object oldValue = this.integerValue;
            this.integerValue = integerValue;
            handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final String getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(String doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(String doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final String getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(String booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(String booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        @Override
        public AssetPropertyVariant build() {
            return new AssetPropertyVariant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssetPropertyVariant#type()
     */
    public enum Type {
        STRING_VALUE,

        INTEGER_VALUE,

        DOUBLE_VALUE,

        BOOLEAN_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
