/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowExecutionResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetWorkflowExecutionResponse.Builder, GetWorkflowExecutionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetWorkflowExecutionResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBuildVersionArn").getter(getter(GetWorkflowExecutionResponse::workflowBuildVersionArn))
            .setter(setter(Builder::workflowBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build())
            .build();

    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowExecutionId").getter(getter(GetWorkflowExecutionResponse::workflowExecutionId))
            .setter(setter(Builder::workflowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build())
            .build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(GetWorkflowExecutionResponse::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetWorkflowExecutionResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GetWorkflowExecutionResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Integer> TOTAL_STEP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalStepCount").getter(getter(GetWorkflowExecutionResponse::totalStepCount))
            .setter(setter(Builder::totalStepCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepCount").build()).build();

    private static final SdkField<Integer> TOTAL_STEPS_SUCCEEDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalStepsSucceeded").getter(getter(GetWorkflowExecutionResponse::totalStepsSucceeded))
            .setter(setter(Builder::totalStepsSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsSucceeded").build())
            .build();

    private static final SdkField<Integer> TOTAL_STEPS_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalStepsFailed").getter(getter(GetWorkflowExecutionResponse::totalStepsFailed))
            .setter(setter(Builder::totalStepsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsFailed").build()).build();

    private static final SdkField<Integer> TOTAL_STEPS_SKIPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalStepsSkipped").getter(getter(GetWorkflowExecutionResponse::totalStepsSkipped))
            .setter(setter(Builder::totalStepsSkipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsSkipped").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(GetWorkflowExecutionResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endTime").getter(getter(GetWorkflowExecutionResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> PARALLEL_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parallelGroup").getter(getter(GetWorkflowExecutionResponse::parallelGroup))
            .setter(setter(Builder::parallelGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            WORKFLOW_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, TYPE_FIELD,
            STATUS_FIELD, MESSAGE_FIELD, TOTAL_STEP_COUNT_FIELD, TOTAL_STEPS_SUCCEEDED_FIELD, TOTAL_STEPS_FAILED_FIELD,
            TOTAL_STEPS_SKIPPED_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARALLEL_GROUP_FIELD));

    private final String requestIdValue;

    private final String workflowBuildVersionArn;

    private final String workflowExecutionId;

    private final String imageBuildVersionArn;

    private final String type;

    private final String status;

    private final String message;

    private final Integer totalStepCount;

    private final Integer totalStepsSucceeded;

    private final Integer totalStepsFailed;

    private final Integer totalStepsSkipped;

    private final String startTime;

    private final String endTime;

    private final String parallelGroup;

    private GetWorkflowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.type = builder.type;
        this.status = builder.status;
        this.message = builder.message;
        this.totalStepCount = builder.totalStepCount;
        this.totalStepsSucceeded = builder.totalStepsSucceeded;
        this.totalStepsFailed = builder.totalStepsFailed;
        this.totalStepsSkipped = builder.totalStepsSkipped;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parallelGroup = builder.parallelGroup;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines the
     * specified runtime instance of the workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines
     *         the specified runtime instance of the workflow.
     */
    public final String workflowBuildVersionArn() {
        return workflowBuildVersionArn;
    }

    /**
     * <p>
     * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
     * </p>
     * 
     * @return The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
     *         workflow.
     */
    public final String workflowExecutionId() {
        return workflowExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the
     * workflow created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of
     *         the workflow created.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current runtime status for the specified runtime instance of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current runtime status for the specified runtime instance of the workflow.
     * @see WorkflowExecutionStatus
     */
    public final WorkflowExecutionStatus status() {
        return WorkflowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current runtime status for the specified runtime instance of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current runtime status for the specified runtime instance of the workflow.
     * @see WorkflowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The output message from the specified runtime instance of the workflow, if applicable.
     * </p>
     * 
     * @return The output message from the specified runtime instance of the workflow, if applicable.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The total number of steps in the specified runtime instance of the workflow that ran. This number should equal
     * the sum of the step counts for steps that succeeded, were skipped, and failed.
     * </p>
     * 
     * @return The total number of steps in the specified runtime instance of the workflow that ran. This number should
     *         equal the sum of the step counts for steps that succeeded, were skipped, and failed.
     */
    public final Integer totalStepCount() {
        return totalStepCount;
    }

    /**
     * <p>
     * A runtime count for the number of steps that ran successfully in the specified runtime instance of the workflow.
     * </p>
     * 
     * @return A runtime count for the number of steps that ran successfully in the specified runtime instance of the
     *         workflow.
     */
    public final Integer totalStepsSucceeded() {
        return totalStepsSucceeded;
    }

    /**
     * <p>
     * A runtime count for the number of steps that failed in the specified runtime instance of the workflow.
     * </p>
     * 
     * @return A runtime count for the number of steps that failed in the specified runtime instance of the workflow.
     */
    public final Integer totalStepsFailed() {
        return totalStepsFailed;
    }

    /**
     * <p>
     * A runtime count for the number of steps that were skipped in the specified runtime instance of the workflow.
     * </p>
     * 
     * @return A runtime count for the number of steps that were skipped in the specified runtime instance of the
     *         workflow.
     */
    public final Integer totalStepsSkipped() {
        return totalStepsSkipped;
    }

    /**
     * <p>
     * The timestamp when the specified runtime instance of the workflow started.
     * </p>
     * 
     * @return The timestamp when the specified runtime instance of the workflow started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the specified runtime instance of the workflow finished.
     * </p>
     * 
     * @return The timestamp when the specified runtime instance of the workflow finished.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * Test workflows are defined within named runtime groups. The parallel group is a named group that contains one or
     * more test workflows.
     * </p>
     * 
     * @return Test workflows are defined within named runtime groups. The parallel group is a named group that contains
     *         one or more test workflows.
     */
    public final String parallelGroup() {
        return parallelGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(totalStepCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalStepsSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(totalStepsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(totalStepsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(parallelGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowExecutionResponse)) {
            return false;
        }
        GetWorkflowExecutionResponse other = (GetWorkflowExecutionResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(workflowBuildVersionArn(), other.workflowBuildVersionArn())
                && Objects.equals(workflowExecutionId(), other.workflowExecutionId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(totalStepCount(), other.totalStepCount())
                && Objects.equals(totalStepsSucceeded(), other.totalStepsSucceeded())
                && Objects.equals(totalStepsFailed(), other.totalStepsFailed())
                && Objects.equals(totalStepsSkipped(), other.totalStepsSkipped())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(parallelGroup(), other.parallelGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowExecutionResponse").add("RequestId", requestId())
                .add("WorkflowBuildVersionArn", workflowBuildVersionArn()).add("WorkflowExecutionId", workflowExecutionId())
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("Message", message()).add("TotalStepCount", totalStepCount())
                .add("TotalStepsSucceeded", totalStepsSucceeded()).add("TotalStepsFailed", totalStepsFailed())
                .add("TotalStepsSkipped", totalStepsSkipped()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("ParallelGroup", parallelGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "workflowBuildVersionArn":
            return Optional.ofNullable(clazz.cast(workflowBuildVersionArn()));
        case "workflowExecutionId":
            return Optional.ofNullable(clazz.cast(workflowExecutionId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "totalStepCount":
            return Optional.ofNullable(clazz.cast(totalStepCount()));
        case "totalStepsSucceeded":
            return Optional.ofNullable(clazz.cast(totalStepsSucceeded()));
        case "totalStepsFailed":
            return Optional.ofNullable(clazz.cast(totalStepsFailed()));
        case "totalStepsSkipped":
            return Optional.ofNullable(clazz.cast(totalStepsSkipped()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "parallelGroup":
            return Optional.ofNullable(clazz.cast(parallelGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowExecutionResponse, T> g) {
        return obj -> g.apply((GetWorkflowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkflowExecutionResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines the
         * specified runtime instance of the workflow.
         * </p>
         * 
         * @param workflowBuildVersionArn
         *        The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that
         *        defines the specified runtime instance of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBuildVersionArn(String workflowBuildVersionArn);

        /**
         * <p>
         * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
         * </p>
         * 
         * @param workflowExecutionId
         *        The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionId(String workflowExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the
         * workflow created.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance
         *        of the workflow created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
         * </p>
         * 
         * @param type
         *        The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
         * </p>
         * 
         * @param type
         *        The type of workflow that Image Builder ran for the specified runtime instance of the workflow.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);

        /**
         * <p>
         * The current runtime status for the specified runtime instance of the workflow.
         * </p>
         * 
         * @param status
         *        The current runtime status for the specified runtime instance of the workflow.
         * @see WorkflowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current runtime status for the specified runtime instance of the workflow.
         * </p>
         * 
         * @param status
         *        The current runtime status for the specified runtime instance of the workflow.
         * @see WorkflowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowExecutionStatus
         */
        Builder status(WorkflowExecutionStatus status);

        /**
         * <p>
         * The output message from the specified runtime instance of the workflow, if applicable.
         * </p>
         * 
         * @param message
         *        The output message from the specified runtime instance of the workflow, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The total number of steps in the specified runtime instance of the workflow that ran. This number should
         * equal the sum of the step counts for steps that succeeded, were skipped, and failed.
         * </p>
         * 
         * @param totalStepCount
         *        The total number of steps in the specified runtime instance of the workflow that ran. This number
         *        should equal the sum of the step counts for steps that succeeded, were skipped, and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStepCount(Integer totalStepCount);

        /**
         * <p>
         * A runtime count for the number of steps that ran successfully in the specified runtime instance of the
         * workflow.
         * </p>
         * 
         * @param totalStepsSucceeded
         *        A runtime count for the number of steps that ran successfully in the specified runtime instance of the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStepsSucceeded(Integer totalStepsSucceeded);

        /**
         * <p>
         * A runtime count for the number of steps that failed in the specified runtime instance of the workflow.
         * </p>
         * 
         * @param totalStepsFailed
         *        A runtime count for the number of steps that failed in the specified runtime instance of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStepsFailed(Integer totalStepsFailed);

        /**
         * <p>
         * A runtime count for the number of steps that were skipped in the specified runtime instance of the workflow.
         * </p>
         * 
         * @param totalStepsSkipped
         *        A runtime count for the number of steps that were skipped in the specified runtime instance of the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStepsSkipped(Integer totalStepsSkipped);

        /**
         * <p>
         * The timestamp when the specified runtime instance of the workflow started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the specified runtime instance of the workflow started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The timestamp when the specified runtime instance of the workflow finished.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the specified runtime instance of the workflow finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * Test workflows are defined within named runtime groups. The parallel group is a named group that contains one
         * or more test workflows.
         * </p>
         * 
         * @param parallelGroup
         *        Test workflows are defined within named runtime groups. The parallel group is a named group that
         *        contains one or more test workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelGroup(String parallelGroup);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private String workflowBuildVersionArn;

        private String workflowExecutionId;

        private String imageBuildVersionArn;

        private String type;

        private String status;

        private String message;

        private Integer totalStepCount;

        private Integer totalStepsSucceeded;

        private Integer totalStepsFailed;

        private Integer totalStepsSkipped;

        private String startTime;

        private String endTime;

        private String parallelGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowExecutionResponse model) {
            super(model);
            requestId(model.requestIdValue);
            workflowBuildVersionArn(model.workflowBuildVersionArn);
            workflowExecutionId(model.workflowExecutionId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            type(model.type);
            status(model.status);
            message(model.message);
            totalStepCount(model.totalStepCount);
            totalStepsSucceeded(model.totalStepsSucceeded);
            totalStepsFailed(model.totalStepsFailed);
            totalStepsSkipped(model.totalStepsSkipped);
            startTime(model.startTime);
            endTime(model.endTime);
            parallelGroup(model.parallelGroup);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getTotalStepCount() {
            return totalStepCount;
        }

        public final void setTotalStepCount(Integer totalStepCount) {
            this.totalStepCount = totalStepCount;
        }

        @Override
        public final Builder totalStepCount(Integer totalStepCount) {
            this.totalStepCount = totalStepCount;
            return this;
        }

        public final Integer getTotalStepsSucceeded() {
            return totalStepsSucceeded;
        }

        public final void setTotalStepsSucceeded(Integer totalStepsSucceeded) {
            this.totalStepsSucceeded = totalStepsSucceeded;
        }

        @Override
        public final Builder totalStepsSucceeded(Integer totalStepsSucceeded) {
            this.totalStepsSucceeded = totalStepsSucceeded;
            return this;
        }

        public final Integer getTotalStepsFailed() {
            return totalStepsFailed;
        }

        public final void setTotalStepsFailed(Integer totalStepsFailed) {
            this.totalStepsFailed = totalStepsFailed;
        }

        @Override
        public final Builder totalStepsFailed(Integer totalStepsFailed) {
            this.totalStepsFailed = totalStepsFailed;
            return this;
        }

        public final Integer getTotalStepsSkipped() {
            return totalStepsSkipped;
        }

        public final void setTotalStepsSkipped(Integer totalStepsSkipped) {
            this.totalStepsSkipped = totalStepsSkipped;
        }

        @Override
        public final Builder totalStepsSkipped(Integer totalStepsSkipped) {
            this.totalStepsSkipped = totalStepsSkipped;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getParallelGroup() {
            return parallelGroup;
        }

        public final void setParallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
        }

        @Override
        public final Builder parallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
            return this;
        }

        @Override
        public GetWorkflowExecutionResponse build() {
            return new GetWorkflowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
