/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.identitystore.model.AttributeOperation;
import software.amazon.awssdk.services.identitystore.model.AttributeOperationsCopier;
import software.amazon.awssdk.services.identitystore.model.IdentitystoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends IdentitystoreRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityStoreId").getter(UpdateUserRequest.getter(UpdateUserRequest::identityStoreId)).setter(UpdateUserRequest.setter(Builder::identityStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<AttributeOperation>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(UpdateUserRequest.getter(UpdateUserRequest::operations)).setter(UpdateUserRequest.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD, USER_ID_FIELD, OPERATIONS_FIELD));
    private final String identityStoreId;
    private final String userId;
    private final List<AttributeOperation> operations;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.identityStoreId = builder.identityStoreId;
        this.userId = builder.userId;
        this.operations = builder.operations;
    }

    public final String identityStoreId() {
        return this.identityStoreId;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<AttributeOperation> operations() {
        return this.operations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.identityStoreId(), other.identityStoreId()) && Objects.equals(this.userId(), other.userId()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("IdentityStoreId", (Object)this.identityStoreId()).add("UserId", (Object)this.userId()).add("Operations", this.hasOperations() ? this.operations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityStoreId": {
                return Optional.ofNullable(clazz.cast(this.identityStoreId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IdentitystoreRequest.BuilderImpl
    implements Builder {
        private String identityStoreId;
        private String userId;
        private List<AttributeOperation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.identityStoreId(model.identityStoreId);
            this.userId(model.userId);
            this.operations(model.operations);
        }

        public final String getIdentityStoreId() {
            return this.identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<AttributeOperation.Builder> getOperations() {
            List<AttributeOperation.Builder> result = AttributeOperationsCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<AttributeOperation.BuilderImpl> operations) {
            this.operations = AttributeOperationsCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<AttributeOperation> operations) {
            this.operations = AttributeOperationsCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(AttributeOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<AttributeOperation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (AttributeOperation)((AttributeOperation.Builder)AttributeOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IdentitystoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder identityStoreId(String var1);

        public Builder userId(String var1);

        public Builder operations(Collection<AttributeOperation> var1);

        public Builder operations(AttributeOperation ... var1);

        public Builder operations(Consumer<AttributeOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

