/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The full name of the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Name implements SdkPojo, Serializable, ToCopyableBuilder<Name.Builder, Name> {
    private static final SdkField<String> FORMATTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Formatted").getter(getter(Name::formatted)).setter(setter(Builder::formatted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formatted").build()).build();

    private static final SdkField<String> FAMILY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FamilyName").getter(getter(Name::familyName)).setter(setter(Builder::familyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FamilyName").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(Name::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MiddleName").getter(getter(Name::middleName)).setter(setter(Builder::middleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()).build();

    private static final SdkField<String> HONORIFIC_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HonorificPrefix").getter(getter(Name::honorificPrefix)).setter(setter(Builder::honorificPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorificPrefix").build()).build();

    private static final SdkField<String> HONORIFIC_SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HonorificSuffix").getter(getter(Name::honorificSuffix)).setter(setter(Builder::honorificSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorificSuffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMATTED_FIELD,
            FAMILY_NAME_FIELD, GIVEN_NAME_FIELD, MIDDLE_NAME_FIELD, HONORIFIC_PREFIX_FIELD, HONORIFIC_SUFFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String formatted;

    private final String familyName;

    private final String givenName;

    private final String middleName;

    private final String honorificPrefix;

    private final String honorificSuffix;

    private Name(BuilderImpl builder) {
        this.formatted = builder.formatted;
        this.familyName = builder.familyName;
        this.givenName = builder.givenName;
        this.middleName = builder.middleName;
        this.honorificPrefix = builder.honorificPrefix;
        this.honorificSuffix = builder.honorificSuffix;
    }

    /**
     * <p>
     * A string containing a formatted version of the name for display.
     * </p>
     * 
     * @return A string containing a formatted version of the name for display.
     */
    public final String formatted() {
        return formatted;
    }

    /**
     * <p>
     * The family name of the user.
     * </p>
     * 
     * @return The family name of the user.
     */
    public final String familyName() {
        return familyName;
    }

    /**
     * <p>
     * The given name of the user.
     * </p>
     * 
     * @return The given name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * The middle name of the user.
     * </p>
     * 
     * @return The middle name of the user.
     */
    public final String middleName() {
        return middleName;
    }

    /**
     * <p>
     * The honorific prefix of the user. For example, "Dr."
     * </p>
     * 
     * @return The honorific prefix of the user. For example, "Dr."
     */
    public final String honorificPrefix() {
        return honorificPrefix;
    }

    /**
     * <p>
     * The honorific suffix of the user. For example, "M.D."
     * </p>
     * 
     * @return The honorific suffix of the user. For example, "M.D."
     */
    public final String honorificSuffix() {
        return honorificSuffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatted());
        hashCode = 31 * hashCode + Objects.hashCode(familyName());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(honorificPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(honorificSuffix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Name)) {
            return false;
        }
        Name other = (Name) obj;
        return Objects.equals(formatted(), other.formatted()) && Objects.equals(familyName(), other.familyName())
                && Objects.equals(givenName(), other.givenName()) && Objects.equals(middleName(), other.middleName())
                && Objects.equals(honorificPrefix(), other.honorificPrefix())
                && Objects.equals(honorificSuffix(), other.honorificSuffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Name").add("Formatted", formatted() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FamilyName", familyName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MiddleName", middleName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HonorificPrefix", honorificPrefix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HonorificSuffix", honorificSuffix() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Formatted":
            return Optional.ofNullable(clazz.cast(formatted()));
        case "FamilyName":
            return Optional.ofNullable(clazz.cast(familyName()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "MiddleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "HonorificPrefix":
            return Optional.ofNullable(clazz.cast(honorificPrefix()));
        case "HonorificSuffix":
            return Optional.ofNullable(clazz.cast(honorificSuffix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Name, T> g) {
        return obj -> g.apply((Name) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Name> {
        /**
         * <p>
         * A string containing a formatted version of the name for display.
         * </p>
         * 
         * @param formatted
         *        A string containing a formatted version of the name for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatted(String formatted);

        /**
         * <p>
         * The family name of the user.
         * </p>
         * 
         * @param familyName
         *        The family name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder familyName(String familyName);

        /**
         * <p>
         * The given name of the user.
         * </p>
         * 
         * @param givenName
         *        The given name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The middle name of the user.
         * </p>
         * 
         * @param middleName
         *        The middle name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(String middleName);

        /**
         * <p>
         * The honorific prefix of the user. For example, "Dr."
         * </p>
         * 
         * @param honorificPrefix
         *        The honorific prefix of the user. For example, "Dr."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorificPrefix(String honorificPrefix);

        /**
         * <p>
         * The honorific suffix of the user. For example, "M.D."
         * </p>
         * 
         * @param honorificSuffix
         *        The honorific suffix of the user. For example, "M.D."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorificSuffix(String honorificSuffix);
    }

    static final class BuilderImpl implements Builder {
        private String formatted;

        private String familyName;

        private String givenName;

        private String middleName;

        private String honorificPrefix;

        private String honorificSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(Name model) {
            formatted(model.formatted);
            familyName(model.familyName);
            givenName(model.givenName);
            middleName(model.middleName);
            honorificPrefix(model.honorificPrefix);
            honorificSuffix(model.honorificSuffix);
        }

        public final String getFormatted() {
            return formatted;
        }

        public final void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        @Override
        public final Builder formatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public final String getFamilyName() {
            return familyName;
        }

        public final void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        @Override
        public final Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getMiddleName() {
            return middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getHonorificPrefix() {
            return honorificPrefix;
        }

        public final void setHonorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
        }

        @Override
        public final Builder honorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
            return this;
        }

        public final String getHonorificSuffix() {
            return honorificSuffix;
        }

        public final void setHonorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
        }

        @Override
        public final Builder honorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
            return this;
        }

        @Override
        public Name build() {
            return new Name(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
