/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationsAccessReportRequest extends IamRequest implements
        ToCopyableBuilder<GetOrganizationsAccessReportRequest.Builder, GetOrganizationsAccessReportRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetOrganizationsAccessReportRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(GetOrganizationsAccessReportRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetOrganizationsAccessReportRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> SORT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortKey").getter(getter(GetOrganizationsAccessReportRequest::sortKeyAsString))
            .setter(setter(Builder::sortKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, MAX_ITEMS_FIELD,
            MARKER_FIELD, SORT_KEY_FIELD));

    private final String jobId;

    private final Integer maxItems;

    private final String marker;

    private final String sortKey;

    private GetOrganizationsAccessReportRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.sortKey = builder.sortKey;
    }

    /**
     * <p>
     * The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.
     * </p>
     * 
     * @return The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The key that is used to sort the results. If you choose the namespace key, the results are returned in
     * alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortKey} will
     * return {@link SortKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortKeyAsString}.
     * </p>
     * 
     * @return The key that is used to sort the results. If you choose the namespace key, the results are returned in
     *         alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
     * @see SortKeyType
     */
    public final SortKeyType sortKey() {
        return SortKeyType.fromValue(sortKey);
    }

    /**
     * <p>
     * The key that is used to sort the results. If you choose the namespace key, the results are returned in
     * alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortKey} will
     * return {@link SortKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortKeyAsString}.
     * </p>
     * 
     * @return The key that is used to sort the results. If you choose the namespace key, the results are returned in
     *         alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
     * @see SortKeyType
     */
    public final String sortKeyAsString() {
        return sortKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(sortKeyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationsAccessReportRequest)) {
            return false;
        }
        GetOrganizationsAccessReportRequest other = (GetOrganizationsAccessReportRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(marker(), other.marker()) && Objects.equals(sortKeyAsString(), other.sortKeyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationsAccessReportRequest").add("JobId", jobId()).add("MaxItems", maxItems())
                .add("Marker", marker()).add("SortKey", sortKeyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "SortKey":
            return Optional.ofNullable(clazz.cast(sortKeyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationsAccessReportRequest, T> g) {
        return obj -> g.apply((GetOrganizationsAccessReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetOrganizationsAccessReportRequest> {
        /**
         * <p>
         * The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.
         * </p>
         * 
         * @param jobId
         *        The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The key that is used to sort the results. If you choose the namespace key, the results are returned in
         * alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
         * </p>
         * 
         * @param sortKey
         *        The key that is used to sort the results. If you choose the namespace key, the results are returned in
         *        alphabetical order. If you choose the time key, the results are sorted numerically by the date and
         *        time.
         * @see SortKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKeyType
         */
        Builder sortKey(String sortKey);

        /**
         * <p>
         * The key that is used to sort the results. If you choose the namespace key, the results are returned in
         * alphabetical order. If you choose the time key, the results are sorted numerically by the date and time.
         * </p>
         * 
         * @param sortKey
         *        The key that is used to sort the results. If you choose the namespace key, the results are returned in
         *        alphabetical order. If you choose the time key, the results are sorted numerically by the date and
         *        time.
         * @see SortKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKeyType
         */
        Builder sortKey(SortKeyType sortKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxItems;

        private String marker;

        private String sortKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationsAccessReportRequest model) {
            super(model);
            jobId(model.jobId);
            maxItems(model.maxItems);
            marker(model.marker);
            sortKey(model.sortKey);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getSortKey() {
            return sortKey;
        }

        public final void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        @Override
        public final Builder sortKey(String sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        @Override
        public final Builder sortKey(SortKeyType sortKey) {
            this.sortKey(sortKey == null ? null : sortKey.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOrganizationsAccessReportRequest build() {
            return new GetOrganizationsAccessReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
