/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggFunction {
    AVG("avg"),
    COUNT_DISTINCT("countDistinct"),
    COUNT("count"),
    FIRST("first"),
    LAST("last"),
    KURTOSIS("kurtosis"),
    MAX("max"),
    MIN("min"),
    SKEWNESS("skewness"),
    STDDEV_SAMP("stddev_samp"),
    STDDEV_POP("stddev_pop"),
    SUM("sum"),
    SUM_DISTINCT("sumDistinct"),
    VAR_SAMP("var_samp"),
    VAR_POP("var_pop"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggFunction> VALUE_MAP;
    private final String value;

    private AggFunction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggFunction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggFunction> knownValues() {
        EnumSet<AggFunction> knownValues = EnumSet.allOf(AggFunction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggFunction.class, AggFunction::toString);
    }
}

