/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies additional connection options for the Amazon S3 data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3SourceAdditionalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<S3SourceAdditionalOptions.Builder, S3SourceAdditionalOptions> {
    private static final SdkField<Long> BOUNDED_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BoundedSize").getter(getter(S3SourceAdditionalOptions::boundedSize))
            .setter(setter(Builder::boundedSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedSize").build()).build();

    private static final SdkField<Long> BOUNDED_FILES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BoundedFiles").getter(getter(S3SourceAdditionalOptions::boundedFiles))
            .setter(setter(Builder::boundedFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundedFiles").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDED_SIZE_FIELD,
            BOUNDED_FILES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long boundedSize;

    private final Long boundedFiles;

    private S3SourceAdditionalOptions(BuilderImpl builder) {
        this.boundedSize = builder.boundedSize;
        this.boundedFiles = builder.boundedFiles;
    }

    /**
     * <p>
     * Sets the upper limit for the target size of the dataset in bytes that will be processed.
     * </p>
     * 
     * @return Sets the upper limit for the target size of the dataset in bytes that will be processed.
     */
    public final Long boundedSize() {
        return boundedSize;
    }

    /**
     * <p>
     * Sets the upper limit for the target number of files that will be processed.
     * </p>
     * 
     * @return Sets the upper limit for the target number of files that will be processed.
     */
    public final Long boundedFiles() {
        return boundedFiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundedSize());
        hashCode = 31 * hashCode + Objects.hashCode(boundedFiles());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceAdditionalOptions)) {
            return false;
        }
        S3SourceAdditionalOptions other = (S3SourceAdditionalOptions) obj;
        return Objects.equals(boundedSize(), other.boundedSize()) && Objects.equals(boundedFiles(), other.boundedFiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3SourceAdditionalOptions").add("BoundedSize", boundedSize())
                .add("BoundedFiles", boundedFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundedSize":
            return Optional.ofNullable(clazz.cast(boundedSize()));
        case "BoundedFiles":
            return Optional.ofNullable(clazz.cast(boundedFiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3SourceAdditionalOptions, T> g) {
        return obj -> g.apply((S3SourceAdditionalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3SourceAdditionalOptions> {
        /**
         * <p>
         * Sets the upper limit for the target size of the dataset in bytes that will be processed.
         * </p>
         * 
         * @param boundedSize
         *        Sets the upper limit for the target size of the dataset in bytes that will be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundedSize(Long boundedSize);

        /**
         * <p>
         * Sets the upper limit for the target number of files that will be processed.
         * </p>
         * 
         * @param boundedFiles
         *        Sets the upper limit for the target number of files that will be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundedFiles(Long boundedFiles);
    }

    static final class BuilderImpl implements Builder {
        private Long boundedSize;

        private Long boundedFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceAdditionalOptions model) {
            boundedSize(model.boundedSize);
            boundedFiles(model.boundedFiles);
        }

        public final Long getBoundedSize() {
            return boundedSize;
        }

        public final void setBoundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
        }

        @Override
        public final Builder boundedSize(Long boundedSize) {
            this.boundedSize = boundedSize;
            return this;
        }

        public final Long getBoundedFiles() {
            return boundedFiles;
        }

        public final void setBoundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
        }

        @Override
        public final Builder boundedFiles(Long boundedFiles) {
            this.boundedFiles = boundedFiles;
            return this;
        }

        @Override
        public S3SourceAdditionalOptions build() {
            return new S3SourceAdditionalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
