/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataflowGraphRequest extends GlueRequest implements
        ToCopyableBuilder<GetDataflowGraphRequest.Builder, GetDataflowGraphRequest> {
    private static final SdkField<String> PYTHON_SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PythonScript").getter(getter(GetDataflowGraphRequest::pythonScript))
            .setter(setter(Builder::pythonScript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonScript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PYTHON_SCRIPT_FIELD));

    private final String pythonScript;

    private GetDataflowGraphRequest(BuilderImpl builder) {
        super(builder);
        this.pythonScript = builder.pythonScript;
    }

    /**
     * <p>
     * The Python script to transform.
     * </p>
     * 
     * @return The Python script to transform.
     */
    public final String pythonScript() {
        return pythonScript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pythonScript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowGraphRequest)) {
            return false;
        }
        GetDataflowGraphRequest other = (GetDataflowGraphRequest) obj;
        return Objects.equals(pythonScript(), other.pythonScript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataflowGraphRequest").add("PythonScript", pythonScript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PythonScript":
            return Optional.ofNullable(clazz.cast(pythonScript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowGraphRequest, T> g) {
        return obj -> g.apply((GetDataflowGraphRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataflowGraphRequest> {
        /**
         * <p>
         * The Python script to transform.
         * </p>
         * 
         * @param pythonScript
         *        The Python script to transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonScript(String pythonScript);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String pythonScript;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowGraphRequest model) {
            super(model);
            pythonScript(model.pythonScript);
        }

        public final String getPythonScript() {
            return pythonScript;
        }

        public final void setPythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
        }

        @Override
        public final Builder pythonScript(String pythonScript) {
            this.pythonScript = pythonScript;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataflowGraphRequest build() {
            return new GetDataflowGraphRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
