/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of credentials that allow remote access to an instance in an EC2 managed fleet. These credentials are returned
 * in response to a call to <a>GetInstanceAccess</a>, which requests access for instances that are running game servers
 * with the Amazon GameLift server SDK version 4.x or earlier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceCredentials.Builder, InstanceCredentials> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(InstanceCredentials::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Secret")
            .getter(getter(InstanceCredentials::secret)).setter(setter(Builder::secret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(USER_NAME_FIELD, SECRET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String secret;

    private InstanceCredentials(BuilderImpl builder) {
        this.userName = builder.userName;
        this.secret = builder.secret;
    }

    /**
     * <p>
     * A user name for logging in.
     * </p>
     * 
     * @return A user name for logging in.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux
     * instances, it's a private key for use with SSH.
     * </p>
     * 
     * @return Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For
     *         Linux instances, it's a private key for use with SSH.
     */
    public final String secret() {
        return secret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(secret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCredentials)) {
            return false;
        }
        InstanceCredentials other = (InstanceCredentials) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(secret(), other.secret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceCredentials").add("UserName", userName()).add("Secret", secret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Secret":
            return Optional.ofNullable(clazz.cast(secret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCredentials, T> g) {
        return obj -> g.apply((InstanceCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceCredentials> {
        /**
         * <p>
         * A user name for logging in.
         * </p>
         * 
         * @param userName
         *        A user name for logging in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop. For Linux
         * instances, it's a private key for use with SSH.
         * </p>
         * 
         * @param secret
         *        Secret string. For Windows instances, the secret is a password for use with Windows Remote Desktop.
         *        For Linux instances, it's a private key for use with SSH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secret(String secret);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String secret;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCredentials model) {
            userName(model.userName);
            secret(model.secret);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getSecret() {
            return secret;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public InstanceCredentials build() {
            return new InstanceCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
