/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * Configuration details for a set of container groups, for use when creating a fleet with compute type
 * <code>CONTAINER</code>.
 * </p>
 * <p>
 * <b>Used with:</b> <a>CreateFleet</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerGroupsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerGroupsConfiguration.Builder, ContainerGroupsConfiguration> {
    private static final SdkField<List<String>> CONTAINER_GROUP_DEFINITION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerGroupDefinitionNames")
            .getter(getter(ContainerGroupsConfiguration::containerGroupDefinitionNames))
            .setter(setter(Builder::containerGroupDefinitionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConnectionPortRange> CONNECTION_PORT_RANGE_FIELD = SdkField
            .<ConnectionPortRange> builder(MarshallingType.SDK_POJO).memberName("ConnectionPortRange")
            .getter(getter(ContainerGroupsConfiguration::connectionPortRange)).setter(setter(Builder::connectionPortRange))
            .constructor(ConnectionPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPortRange").build())
            .build();

    private static final SdkField<Integer> DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredReplicaContainerGroupsPerInstance")
            .getter(getter(ContainerGroupsConfiguration::desiredReplicaContainerGroupsPerInstance))
            .setter(setter(Builder::desiredReplicaContainerGroupsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DesiredReplicaContainerGroupsPerInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTAINER_GROUP_DEFINITION_NAMES_FIELD, CONNECTION_PORT_RANGE_FIELD,
            DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> containerGroupDefinitionNames;

    private final ConnectionPortRange connectionPortRange;

    private final Integer desiredReplicaContainerGroupsPerInstance;

    private ContainerGroupsConfiguration(BuilderImpl builder) {
        this.containerGroupDefinitionNames = builder.containerGroupDefinitionNames;
        this.connectionPortRange = builder.connectionPortRange;
        this.desiredReplicaContainerGroupsPerInstance = builder.desiredReplicaContainerGroupsPerInstance;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerGroupDefinitionNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerGroupDefinitionNames() {
        return containerGroupDefinitionNames != null && !(containerGroupDefinitionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of container group definition names to deploy to a new container fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerGroupDefinitionNames} method.
     * </p>
     * 
     * @return The list of container group definition names to deploy to a new container fleet.
     */
    public final List<String> containerGroupDefinitionNames() {
        return containerGroupDefinitionNames;
    }

    /**
     * <p>
     * A set of ports to allow inbound traffic, including game clients, to connect to processes running in the container
     * fleet.
     * </p>
     * <p>
     * Connection ports are dynamically mapped to container ports, which are assigned to individual processes running in
     * a container. The connection port range must have enough ports to map to all container ports across a fleet
     * instance. To calculate the minimum connection ports needed, use the following formula:
     * </p>
     * <p>
     * <i>[Total number of container ports as defined for containers in the replica container group] * [Desired or
     * calculated number of replica container groups per instance] + [Total number of container ports as defined for
     * containers in the daemon container group]</i>
     * </p>
     * <p>
     * As a best practice, double the minimum number of connection ports.
     * </p>
     * <note>
     * <p>
     * Use the fleet's <code>EC2InboundPermissions</code> property to control external access to connection ports. Set
     * this property to the connection port numbers that you want to open access to. See <a>IpPermission</a> for more
     * details.
     * </p>
     * </note>
     * 
     * @return A set of ports to allow inbound traffic, including game clients, to connect to processes running in the
     *         container fleet. </p>
     *         <p>
     *         Connection ports are dynamically mapped to container ports, which are assigned to individual processes
     *         running in a container. The connection port range must have enough ports to map to all container ports
     *         across a fleet instance. To calculate the minimum connection ports needed, use the following formula:
     *         </p>
     *         <p>
     *         <i>[Total number of container ports as defined for containers in the replica container group] * [Desired
     *         or calculated number of replica container groups per instance] + [Total number of container ports as
     *         defined for containers in the daemon container group]</i>
     *         </p>
     *         <p>
     *         As a best practice, double the minimum number of connection ports.
     *         </p>
     *         <note>
     *         <p>
     *         Use the fleet's <code>EC2InboundPermissions</code> property to control external access to connection
     *         ports. Set this property to the connection port numbers that you want to open access to. See
     *         <a>IpPermission</a> for more details.
     *         </p>
     */
    public final ConnectionPortRange connectionPortRange() {
        return connectionPortRange;
    }

    /**
     * <p>
     * The number of times to replicate the replica container group on each instance in a container fleet. By default,
     * Amazon GameLift calculates the maximum number of replica container groups that can fit on a fleet instance (based
     * on CPU and memory resources). Leave this parameter empty if you want to use the maximum number, or specify a
     * desired number to override the maximum. The desired number is used if it's less than the maximum number.
     * </p>
     * 
     * @return The number of times to replicate the replica container group on each instance in a container fleet. By
     *         default, Amazon GameLift calculates the maximum number of replica container groups that can fit on a
     *         fleet instance (based on CPU and memory resources). Leave this parameter empty if you want to use the
     *         maximum number, or specify a desired number to override the maximum. The desired number is used if it's
     *         less than the maximum number.
     */
    public final Integer desiredReplicaContainerGroupsPerInstance() {
        return desiredReplicaContainerGroupsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerGroupDefinitionNames() ? containerGroupDefinitionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(desiredReplicaContainerGroupsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupsConfiguration)) {
            return false;
        }
        ContainerGroupsConfiguration other = (ContainerGroupsConfiguration) obj;
        return hasContainerGroupDefinitionNames() == other.hasContainerGroupDefinitionNames()
                && Objects.equals(containerGroupDefinitionNames(), other.containerGroupDefinitionNames())
                && Objects.equals(connectionPortRange(), other.connectionPortRange())
                && Objects.equals(desiredReplicaContainerGroupsPerInstance(), other.desiredReplicaContainerGroupsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ContainerGroupsConfiguration")
                .add("ContainerGroupDefinitionNames", hasContainerGroupDefinitionNames() ? containerGroupDefinitionNames() : null)
                .add("ConnectionPortRange", connectionPortRange())
                .add("DesiredReplicaContainerGroupsPerInstance", desiredReplicaContainerGroupsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerGroupDefinitionNames":
            return Optional.ofNullable(clazz.cast(containerGroupDefinitionNames()));
        case "ConnectionPortRange":
            return Optional.ofNullable(clazz.cast(connectionPortRange()));
        case "DesiredReplicaContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(desiredReplicaContainerGroupsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupsConfiguration, T> g) {
        return obj -> g.apply((ContainerGroupsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerGroupsConfiguration> {
        /**
         * <p>
         * The list of container group definition names to deploy to a new container fleet.
         * </p>
         * 
         * @param containerGroupDefinitionNames
         *        The list of container group definition names to deploy to a new container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionNames(Collection<String> containerGroupDefinitionNames);

        /**
         * <p>
         * The list of container group definition names to deploy to a new container fleet.
         * </p>
         * 
         * @param containerGroupDefinitionNames
         *        The list of container group definition names to deploy to a new container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionNames(String... containerGroupDefinitionNames);

        /**
         * <p>
         * A set of ports to allow inbound traffic, including game clients, to connect to processes running in the
         * container fleet.
         * </p>
         * <p>
         * Connection ports are dynamically mapped to container ports, which are assigned to individual processes
         * running in a container. The connection port range must have enough ports to map to all container ports across
         * a fleet instance. To calculate the minimum connection ports needed, use the following formula:
         * </p>
         * <p>
         * <i>[Total number of container ports as defined for containers in the replica container group] * [Desired or
         * calculated number of replica container groups per instance] + [Total number of container ports as defined for
         * containers in the daemon container group]</i>
         * </p>
         * <p>
         * As a best practice, double the minimum number of connection ports.
         * </p>
         * <note>
         * <p>
         * Use the fleet's <code>EC2InboundPermissions</code> property to control external access to connection ports.
         * Set this property to the connection port numbers that you want to open access to. See <a>IpPermission</a> for
         * more details.
         * </p>
         * </note>
         * 
         * @param connectionPortRange
         *        A set of ports to allow inbound traffic, including game clients, to connect to processes running in
         *        the container fleet. </p>
         *        <p>
         *        Connection ports are dynamically mapped to container ports, which are assigned to individual processes
         *        running in a container. The connection port range must have enough ports to map to all container ports
         *        across a fleet instance. To calculate the minimum connection ports needed, use the following formula:
         *        </p>
         *        <p>
         *        <i>[Total number of container ports as defined for containers in the replica container group] *
         *        [Desired or calculated number of replica container groups per instance] + [Total number of container
         *        ports as defined for containers in the daemon container group]</i>
         *        </p>
         *        <p>
         *        As a best practice, double the minimum number of connection ports.
         *        </p>
         *        <note>
         *        <p>
         *        Use the fleet's <code>EC2InboundPermissions</code> property to control external access to connection
         *        ports. Set this property to the connection port numbers that you want to open access to. See
         *        <a>IpPermission</a> for more details.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPortRange(ConnectionPortRange connectionPortRange);

        /**
         * <p>
         * A set of ports to allow inbound traffic, including game clients, to connect to processes running in the
         * container fleet.
         * </p>
         * <p>
         * Connection ports are dynamically mapped to container ports, which are assigned to individual processes
         * running in a container. The connection port range must have enough ports to map to all container ports across
         * a fleet instance. To calculate the minimum connection ports needed, use the following formula:
         * </p>
         * <p>
         * <i>[Total number of container ports as defined for containers in the replica container group] * [Desired or
         * calculated number of replica container groups per instance] + [Total number of container ports as defined for
         * containers in the daemon container group]</i>
         * </p>
         * <p>
         * As a best practice, double the minimum number of connection ports.
         * </p>
         * <note>
         * <p>
         * Use the fleet's <code>EC2InboundPermissions</code> property to control external access to connection ports.
         * Set this property to the connection port numbers that you want to open access to. See <a>IpPermission</a> for
         * more details.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ConnectionPortRange.Builder}
         * avoiding the need to create one manually via {@link ConnectionPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionPortRange(ConnectionPortRange)}.
         * 
         * @param connectionPortRange
         *        a consumer that will call methods on {@link ConnectionPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPortRange(ConnectionPortRange)
         */
        default Builder connectionPortRange(Consumer<ConnectionPortRange.Builder> connectionPortRange) {
            return connectionPortRange(ConnectionPortRange.builder().applyMutation(connectionPortRange).build());
        }

        /**
         * <p>
         * The number of times to replicate the replica container group on each instance in a container fleet. By
         * default, Amazon GameLift calculates the maximum number of replica container groups that can fit on a fleet
         * instance (based on CPU and memory resources). Leave this parameter empty if you want to use the maximum
         * number, or specify a desired number to override the maximum. The desired number is used if it's less than the
         * maximum number.
         * </p>
         * 
         * @param desiredReplicaContainerGroupsPerInstance
         *        The number of times to replicate the replica container group on each instance in a container fleet. By
         *        default, Amazon GameLift calculates the maximum number of replica container groups that can fit on a
         *        fleet instance (based on CPU and memory resources). Leave this parameter empty if you want to use the
         *        maximum number, or specify a desired number to override the maximum. The desired number is used if
         *        it's less than the maximum number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance);
    }

    static final class BuilderImpl implements Builder {
        private List<String> containerGroupDefinitionNames = DefaultSdkAutoConstructList.getInstance();

        private ConnectionPortRange connectionPortRange;

        private Integer desiredReplicaContainerGroupsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupsConfiguration model) {
            containerGroupDefinitionNames(model.containerGroupDefinitionNames);
            connectionPortRange(model.connectionPortRange);
            desiredReplicaContainerGroupsPerInstance(model.desiredReplicaContainerGroupsPerInstance);
        }

        public final Collection<String> getContainerGroupDefinitionNames() {
            if (containerGroupDefinitionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return containerGroupDefinitionNames;
        }

        public final void setContainerGroupDefinitionNames(Collection<String> containerGroupDefinitionNames) {
            this.containerGroupDefinitionNames = ContainerGroupDefinitionNameOrArnLimitedListCopier
                    .copy(containerGroupDefinitionNames);
        }

        @Override
        public final Builder containerGroupDefinitionNames(Collection<String> containerGroupDefinitionNames) {
            this.containerGroupDefinitionNames = ContainerGroupDefinitionNameOrArnLimitedListCopier
                    .copy(containerGroupDefinitionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionNames(String... containerGroupDefinitionNames) {
            containerGroupDefinitionNames(Arrays.asList(containerGroupDefinitionNames));
            return this;
        }

        public final ConnectionPortRange.Builder getConnectionPortRange() {
            return connectionPortRange != null ? connectionPortRange.toBuilder() : null;
        }

        public final void setConnectionPortRange(ConnectionPortRange.BuilderImpl connectionPortRange) {
            this.connectionPortRange = connectionPortRange != null ? connectionPortRange.build() : null;
        }

        @Override
        public final Builder connectionPortRange(ConnectionPortRange connectionPortRange) {
            this.connectionPortRange = connectionPortRange;
            return this;
        }

        public final Integer getDesiredReplicaContainerGroupsPerInstance() {
            return desiredReplicaContainerGroupsPerInstance;
        }

        public final void setDesiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
        }

        @Override
        public final Builder desiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
            return this;
        }

        @Override
        public ContainerGroupsConfiguration build() {
            return new ContainerGroupsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
