/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * Describes attributes of containers that are deployed to a fleet with compute type <code>CONTAINER</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerAttributes.Builder, ContainerAttributes> {
    private static final SdkField<List<ContainerPortMapping>> CONTAINER_PORT_MAPPINGS_FIELD = SdkField
            .<List<ContainerPortMapping>> builder(MarshallingType.LIST)
            .memberName("ContainerPortMappings")
            .getter(getter(ContainerAttributes::containerPortMappings))
            .setter(setter(Builder::containerPortMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPortMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerPortMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerPortMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONTAINER_PORT_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ContainerPortMapping> containerPortMappings;

    private ContainerAttributes(BuilderImpl builder) {
        this.containerPortMappings = builder.containerPortMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerPortMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerPortMappings() {
        return containerPortMappings != null && !(containerPortMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects to a game
     * via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a connection port to a port
     * on the container that hosts the game session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerPortMappings} method.
     * </p>
     * 
     * @return Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects to
     *         a game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a connection
     *         port to a port on the container that hosts the game session.
     */
    public final List<ContainerPortMapping> containerPortMappings() {
        return containerPortMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerPortMappings() ? containerPortMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerAttributes)) {
            return false;
        }
        ContainerAttributes other = (ContainerAttributes) obj;
        return hasContainerPortMappings() == other.hasContainerPortMappings()
                && Objects.equals(containerPortMappings(), other.containerPortMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerAttributes")
                .add("ContainerPortMappings", hasContainerPortMappings() ? containerPortMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerPortMappings":
            return Optional.ofNullable(clazz.cast(containerPortMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerAttributes, T> g) {
        return obj -> g.apply((ContainerAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerAttributes> {
        /**
         * <p>
         * Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects to a
         * game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a connection port to
         * a port on the container that hosts the game session.
         * </p>
         * 
         * @param containerPortMappings
         *        Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects
         *        to a game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a
         *        connection port to a port on the container that hosts the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPortMappings(Collection<ContainerPortMapping> containerPortMappings);

        /**
         * <p>
         * Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects to a
         * game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a connection port to
         * a port on the container that hosts the game session.
         * </p>
         * 
         * @param containerPortMappings
         *        Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects
         *        to a game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a
         *        connection port to a port on the container that hosts the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPortMappings(ContainerPortMapping... containerPortMappings);

        /**
         * <p>
         * Describes how container ports map to connection ports on the fleet instance. Incoming traffic connects to a
         * game via a connection port. A <code>ContainerPortMapping</code> directs the traffic from a connection port to
         * a port on the container that hosts the game session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerPortMapping.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.gamelift.model.ContainerPortMapping#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerPortMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #containerPortMappings(List<ContainerPortMapping>)}.
         * 
         * @param containerPortMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerPortMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerPortMappings(java.util.Collection<ContainerPortMapping>)
         */
        Builder containerPortMappings(Consumer<ContainerPortMapping.Builder>... containerPortMappings);
    }

    static final class BuilderImpl implements Builder {
        private List<ContainerPortMapping> containerPortMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerAttributes model) {
            containerPortMappings(model.containerPortMappings);
        }

        public final List<ContainerPortMapping.Builder> getContainerPortMappings() {
            List<ContainerPortMapping.Builder> result = ContainerPortMappingListCopier.copyToBuilder(this.containerPortMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerPortMappings(Collection<ContainerPortMapping.BuilderImpl> containerPortMappings) {
            this.containerPortMappings = ContainerPortMappingListCopier.copyFromBuilder(containerPortMappings);
        }

        @Override
        public final Builder containerPortMappings(Collection<ContainerPortMapping> containerPortMappings) {
            this.containerPortMappings = ContainerPortMappingListCopier.copy(containerPortMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerPortMappings(ContainerPortMapping... containerPortMappings) {
            containerPortMappings(Arrays.asList(containerPortMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerPortMappings(Consumer<ContainerPortMapping.Builder>... containerPortMappings) {
            containerPortMappings(Stream.of(containerPortMappings)
                    .map(c -> ContainerPortMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContainerAttributes build() {
            return new ContainerAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
