/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClaimGameServerRequest extends GameLiftRequest implements
        ToCopyableBuilder<ClaimGameServerRequest.Builder, ClaimGameServerRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(ClaimGameServerRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<String> GAME_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerId").getter(getter(ClaimGameServerRequest::gameServerId))
            .setter(setter(Builder::gameServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerId").build()).build();

    private static final SdkField<String> GAME_SERVER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerData").getter(getter(ClaimGameServerRequest::gameServerData))
            .setter(setter(Builder::gameServerData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerData").build()).build();

    private static final SdkField<ClaimFilterOption> FILTER_OPTION_FIELD = SdkField
            .<ClaimFilterOption> builder(MarshallingType.SDK_POJO).memberName("FilterOption")
            .getter(getter(ClaimGameServerRequest::filterOption)).setter(setter(Builder::filterOption))
            .constructor(ClaimFilterOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            GAME_SERVER_ID_FIELD, GAME_SERVER_DATA_FIELD, FILTER_OPTION_FIELD));

    private final String gameServerGroupName;

    private final String gameServerId;

    private final String gameServerData;

    private final ClaimFilterOption filterOption;

    private ClaimGameServerRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.gameServerId = builder.gameServerId;
        this.gameServerData = builder.gameServerData;
        this.filterOption = builder.filterOption;
    }

    /**
     * <p>
     * A unique identifier for the game server group where the game server is running. If you are not specifying a game
     * server to claim, this value identifies where you want Amazon GameLift FleetIQ to look for an available game
     * server to claim.
     * </p>
     * 
     * @return A unique identifier for the game server group where the game server is running. If you are not specifying
     *         a game server to claim, this value identifies where you want Amazon GameLift FleetIQ to look for an
     *         available game server to claim.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * A custom string that uniquely identifies the game server to claim. If this parameter is left empty, Amazon
     * GameLift FleetIQ searches for an available game server in the specified game server group.
     * </p>
     * 
     * @return A custom string that uniquely identifies the game server to claim. If this parameter is left empty,
     *         Amazon GameLift FleetIQ searches for an available game server in the specified game server group.
     */
    public final String gameServerId() {
        return gameServerId;
    }

    /**
     * <p>
     * A set of custom game server properties, formatted as a single string value. This data is passed to a game client
     * or service when it requests information on game servers.
     * </p>
     * 
     * @return A set of custom game server properties, formatted as a single string value. This data is passed to a game
     *         client or service when it requests information on game servers.
     */
    public final String gameServerData() {
        return gameServerData;
    }

    /**
     * <p>
     * Object that restricts how a claimed game server is chosen.
     * </p>
     * 
     * @return Object that restricts how a claimed game server is chosen.
     */
    public final ClaimFilterOption filterOption() {
        return filterOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerId());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerData());
        hashCode = 31 * hashCode + Objects.hashCode(filterOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimGameServerRequest)) {
            return false;
        }
        ClaimGameServerRequest other = (ClaimGameServerRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && Objects.equals(gameServerId(), other.gameServerId())
                && Objects.equals(gameServerData(), other.gameServerData())
                && Objects.equals(filterOption(), other.filterOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClaimGameServerRequest").add("GameServerGroupName", gameServerGroupName())
                .add("GameServerId", gameServerId()).add("GameServerData", gameServerData()).add("FilterOption", filterOption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "GameServerId":
            return Optional.ofNullable(clazz.cast(gameServerId()));
        case "GameServerData":
            return Optional.ofNullable(clazz.cast(gameServerData()));
        case "FilterOption":
            return Optional.ofNullable(clazz.cast(filterOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClaimGameServerRequest, T> g) {
        return obj -> g.apply((ClaimGameServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ClaimGameServerRequest> {
        /**
         * <p>
         * A unique identifier for the game server group where the game server is running. If you are not specifying a
         * game server to claim, this value identifies where you want Amazon GameLift FleetIQ to look for an available
         * game server to claim.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group where the game server is running. If you are not
         *        specifying a game server to claim, this value identifies where you want Amazon GameLift FleetIQ to
         *        look for an available game server to claim.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * A custom string that uniquely identifies the game server to claim. If this parameter is left empty, Amazon
         * GameLift FleetIQ searches for an available game server in the specified game server group.
         * </p>
         * 
         * @param gameServerId
         *        A custom string that uniquely identifies the game server to claim. If this parameter is left empty,
         *        Amazon GameLift FleetIQ searches for an available game server in the specified game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerId(String gameServerId);

        /**
         * <p>
         * A set of custom game server properties, formatted as a single string value. This data is passed to a game
         * client or service when it requests information on game servers.
         * </p>
         * 
         * @param gameServerData
         *        A set of custom game server properties, formatted as a single string value. This data is passed to a
         *        game client or service when it requests information on game servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerData(String gameServerData);

        /**
         * <p>
         * Object that restricts how a claimed game server is chosen.
         * </p>
         * 
         * @param filterOption
         *        Object that restricts how a claimed game server is chosen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOption(ClaimFilterOption filterOption);

        /**
         * <p>
         * Object that restricts how a claimed game server is chosen.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClaimFilterOption.Builder} avoiding the
         * need to create one manually via {@link ClaimFilterOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClaimFilterOption.Builder#build()} is called immediately and its
         * result is passed to {@link #filterOption(ClaimFilterOption)}.
         * 
         * @param filterOption
         *        a consumer that will call methods on {@link ClaimFilterOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterOption(ClaimFilterOption)
         */
        default Builder filterOption(Consumer<ClaimFilterOption.Builder> filterOption) {
            return filterOption(ClaimFilterOption.builder().applyMutation(filterOption).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private String gameServerId;

        private String gameServerData;

        private ClaimFilterOption filterOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimGameServerRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            gameServerId(model.gameServerId);
            gameServerData(model.gameServerData);
            filterOption(model.filterOption);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final String getGameServerId() {
            return gameServerId;
        }

        public final void setGameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
        }

        @Override
        public final Builder gameServerId(String gameServerId) {
            this.gameServerId = gameServerId;
            return this;
        }

        public final String getGameServerData() {
            return gameServerData;
        }

        public final void setGameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
        }

        @Override
        public final Builder gameServerData(String gameServerData) {
            this.gameServerData = gameServerData;
            return this;
        }

        public final ClaimFilterOption.Builder getFilterOption() {
            return filterOption != null ? filterOption.toBuilder() : null;
        }

        public final void setFilterOption(ClaimFilterOption.BuilderImpl filterOption) {
            this.filterOption = filterOption != null ? filterOption.build() : null;
        }

        @Override
        public final Builder filterOption(ClaimFilterOption filterOption) {
            this.filterOption = filterOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ClaimGameServerRequest build() {
            return new ClaimGameServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
