/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBatchImportJobsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetBatchImportJobsResponse.Builder, GetBatchImportJobsResponse> {
    private static final SdkField<List<BatchImport>> BATCH_IMPORTS_FIELD = SdkField
            .<List<BatchImport>> builder(MarshallingType.LIST)
            .memberName("batchImports")
            .getter(getter(GetBatchImportJobsResponse::batchImports))
            .setter(setter(Builder::batchImports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchImports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchImport> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchImport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetBatchImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_IMPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BatchImport> batchImports;

    private final String nextToken;

    private GetBatchImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchImports = builder.batchImports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchImports property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchImports() {
        return batchImports != null && !(batchImports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the details of each batch import job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchImports} method.
     * </p>
     * 
     * @return An array containing the details of each batch import job.
     */
    public final List<BatchImport> batchImports() {
        return batchImports;
    }

    /**
     * <p>
     * The next token for the subsequent resquest.
     * </p>
     * 
     * @return The next token for the subsequent resquest.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchImports() ? batchImports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchImportJobsResponse)) {
            return false;
        }
        GetBatchImportJobsResponse other = (GetBatchImportJobsResponse) obj;
        return hasBatchImports() == other.hasBatchImports() && Objects.equals(batchImports(), other.batchImports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBatchImportJobsResponse").add("BatchImports", hasBatchImports() ? batchImports() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchImports":
            return Optional.ofNullable(clazz.cast(batchImports()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBatchImportJobsResponse, T> g) {
        return obj -> g.apply((GetBatchImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBatchImportJobsResponse> {
        /**
         * <p>
         * An array containing the details of each batch import job.
         * </p>
         * 
         * @param batchImports
         *        An array containing the details of each batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchImports(Collection<BatchImport> batchImports);

        /**
         * <p>
         * An array containing the details of each batch import job.
         * </p>
         * 
         * @param batchImports
         *        An array containing the details of each batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchImports(BatchImport... batchImports);

        /**
         * <p>
         * An array containing the details of each batch import job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.BatchImport.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.BatchImport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.BatchImport.Builder#build()} is called immediately
         * and its result is passed to {@link #batchImports(List<BatchImport>)}.
         * 
         * @param batchImports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.BatchImport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchImports(java.util.Collection<BatchImport>)
         */
        Builder batchImports(Consumer<BatchImport.Builder>... batchImports);

        /**
         * <p>
         * The next token for the subsequent resquest.
         * </p>
         * 
         * @param nextToken
         *        The next token for the subsequent resquest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<BatchImport> batchImports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchImportJobsResponse model) {
            super(model);
            batchImports(model.batchImports);
            nextToken(model.nextToken);
        }

        public final List<BatchImport.Builder> getBatchImports() {
            List<BatchImport.Builder> result = BatchImportListCopier.copyToBuilder(this.batchImports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchImports(Collection<BatchImport.BuilderImpl> batchImports) {
            this.batchImports = BatchImportListCopier.copyFromBuilder(batchImports);
        }

        @Override
        public final Builder batchImports(Collection<BatchImport> batchImports) {
            this.batchImports = BatchImportListCopier.copy(batchImports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImports(BatchImport... batchImports) {
            batchImports(Arrays.asList(batchImports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImports(Consumer<BatchImport.Builder>... batchImports) {
            batchImports(Stream.of(batchImports).map(c -> BatchImport.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBatchImportJobsResponse build() {
            return new GetBatchImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
