/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventsByEventTypeResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<DeleteEventsByEventTypeResponse.Builder, DeleteEventsByEventTypeResponse> {
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(DeleteEventsByEventTypeResponse::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> EVENTS_DELETION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventsDeletionStatus").getter(getter(DeleteEventsByEventTypeResponse::eventsDeletionStatus))
            .setter(setter(Builder::eventsDeletionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsDeletionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_NAME_FIELD,
            EVENTS_DELETION_STATUS_FIELD));

    private final String eventTypeName;

    private final String eventsDeletionStatus;

    private DeleteEventsByEventTypeResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypeName = builder.eventTypeName;
        this.eventsDeletionStatus = builder.eventsDeletionStatus;
    }

    /**
     * <p>
     * Name of event type for which to delete the events.
     * </p>
     * 
     * @return Name of event type for which to delete the events.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The status of the delete request.
     * </p>
     * 
     * @return The status of the delete request.
     */
    public final String eventsDeletionStatus() {
        return eventsDeletionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventsDeletionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventsByEventTypeResponse)) {
            return false;
        }
        DeleteEventsByEventTypeResponse other = (DeleteEventsByEventTypeResponse) obj;
        return Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(eventsDeletionStatus(), other.eventsDeletionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEventsByEventTypeResponse").add("EventTypeName", eventTypeName())
                .add("EventsDeletionStatus", eventsDeletionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "eventsDeletionStatus":
            return Optional.ofNullable(clazz.cast(eventsDeletionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventsByEventTypeResponse, T> g) {
        return obj -> g.apply((DeleteEventsByEventTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteEventsByEventTypeResponse> {
        /**
         * <p>
         * Name of event type for which to delete the events.
         * </p>
         * 
         * @param eventTypeName
         *        Name of event type for which to delete the events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The status of the delete request.
         * </p>
         * 
         * @param eventsDeletionStatus
         *        The status of the delete request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsDeletionStatus(String eventsDeletionStatus);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String eventTypeName;

        private String eventsDeletionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventsByEventTypeResponse model) {
            super(model);
            eventTypeName(model.eventTypeName);
            eventsDeletionStatus(model.eventsDeletionStatus);
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventsDeletionStatus() {
            return eventsDeletionStatus;
        }

        public final void setEventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
        }

        @Override
        public final Builder eventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
            return this;
        }

        @Override
        public DeleteEventsByEventTypeResponse build() {
            return new DeleteEventsByEventTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
