/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.frauddetector.internal.FraudDetectorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.frauddetector.model.AccessDeniedException;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.ConflictException;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateListRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateListResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteListRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteListResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorException;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListElementsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetListsMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.InternalServerException;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.PutLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.ResourceNotFoundException;
import software.amazon.awssdk.services.frauddetector.model.ResourceUnavailableException;
import software.amazon.awssdk.services.frauddetector.model.SendEventRequest;
import software.amazon.awssdk.services.frauddetector.model.SendEventResponse;
import software.amazon.awssdk.services.frauddetector.model.TagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.TagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.ThrottlingException;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateListRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateListResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ValidationException;
import software.amazon.awssdk.services.frauddetector.transform.BatchCreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.BatchGetVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CancelBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CancelBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.CreateVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteBatchImportJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteBatchPredictionJobRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteEventsByEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteExternalModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteOutcomeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DeleteVariableRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.DescribeModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetBatchImportJobsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetBatchPredictionJobsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDeleteEventsByEventTypeStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetDetectorsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEntityTypesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventPredictionMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventPredictionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetEventTypesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetExternalModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetKmsEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetLabelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetListElementsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetListsMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetOutcomesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetRulesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.GetVariablesRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.ListEventPredictionsRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutDetectorRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutEntityTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutEventTypeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutExternalModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutKmsEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.PutOutcomeRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.SendEventRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateDetectorVersionStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateEventLabelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateListRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateModelVersionStatusRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleMetadataRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateRuleVersionRequestMarshaller;
import software.amazon.awssdk.services.frauddetector.transform.UpdateVariableRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link FraudDetectorClient}.
 *
 * @see FraudDetectorClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultFraudDetectorClient implements FraudDetectorClient {
    private static final Logger log = Logger.loggerFor(DefaultFraudDetectorClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFraudDetectorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     *
     * @param batchCreateVariableRequest
     * @return Result of the BatchCreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchCreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateVariableResponse batchCreateVariable(BatchCreateVariableRequest batchCreateVariableRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateVariableResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateVariableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateVariableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateVariable");

            return clientHandler.execute(new ClientExecutionParams<BatchCreateVariableRequest, BatchCreateVariableResponse>()
                    .withOperationName("BatchCreateVariable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchCreateVariableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchCreateVariableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     *
     * @param batchGetVariableRequest
     * @return Result of the BatchGetVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchGetVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetVariableResponse batchGetVariable(BatchGetVariableRequest batchGetVariableRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetVariableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetVariableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetVariableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetVariable");

            return clientHandler.execute(new ClientExecutionParams<BatchGetVariableRequest, BatchGetVariableResponse>()
                    .withOperationName("BatchGetVariable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetVariableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetVariableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an in-progress batch import job.
     * </p>
     *
     * @param cancelBatchImportJobRequest
     * @return Result of the CancelBatchImportJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CancelBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelBatchImportJobResponse cancelBatchImportJob(CancelBatchImportJobRequest cancelBatchImportJobRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelBatchImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBatchImportJob");

            return clientHandler.execute(new ClientExecutionParams<CancelBatchImportJobRequest, CancelBatchImportJobResponse>()
                    .withOperationName("CancelBatchImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelBatchImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelBatchImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified batch prediction job.
     * </p>
     *
     * @param cancelBatchPredictionJobRequest
     * @return Result of the CancelBatchPredictionJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CancelBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelBatchPredictionJobResponse cancelBatchPredictionJob(
            CancelBatchPredictionJobRequest cancelBatchPredictionJobRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelBatchPredictionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBatchPredictionJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelBatchPredictionJobRequest, CancelBatchPredictionJobResponse>()
                            .withOperationName("CancelBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelBatchPredictionJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelBatchPredictionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a batch import job.
     * </p>
     *
     * @param createBatchImportJobRequest
     * @return Result of the CreateBatchImportJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBatchImportJobResponse createBatchImportJob(CreateBatchImportJobRequest createBatchImportJobRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBatchImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchImportJob");

            return clientHandler.execute(new ClientExecutionParams<CreateBatchImportJobRequest, CreateBatchImportJobResponse>()
                    .withOperationName("CreateBatchImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBatchImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBatchImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a batch prediction job.
     * </p>
     *
     * @param createBatchPredictionJobRequest
     * @return Result of the CreateBatchPredictionJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBatchPredictionJobResponse createBatchPredictionJob(
            CreateBatchPredictionJobRequest createBatchPredictionJobRequest) throws ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBatchPredictionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchPredictionJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateBatchPredictionJobRequest, CreateBatchPredictionJobResponse>()
                            .withOperationName("CreateBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createBatchPredictionJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateBatchPredictionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     *
     * @param createDetectorVersionRequest
     * @return Result of the CreateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDetectorVersionResponse createDetectorVersion(CreateDetectorVersionRequest createDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDetectorVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDetectorVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateDetectorVersionRequest, CreateDetectorVersionResponse>()
                    .withOperationName("CreateDetectorVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDetectorVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDetectorVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a list.
     * </p>
     * <p>
     * List is a set of input data for a variable in your event dataset. You use the input data in a rule that's
     * associated with your detector. For more information, see <a
     * href="https://docs.aws.amazon.com/frauddetector/latest/ug/lists.html">Lists</a>.
     * </p>
     *
     * @param createListRequest
     * @return Result of the CreateList operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateListResponse createList(CreateListRequest createListRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateList");

            return clientHandler.execute(new ClientExecutionParams<CreateListRequest, CreateListResponse>()
                    .withOperationName("CreateList").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createListRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");

            return clientHandler.execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                    .withOperationName("CreateModel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     *
     * @param createModelVersionRequest
     * @return Result of the CreateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateModelVersionResponse createModelVersion(CreateModelVersionRequest createModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateModelVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModelVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateModelVersionRequest, CreateModelVersionResponse>()
                    .withOperationName("CreateModelVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createModelVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRule");

            return clientHandler.execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>()
                    .withOperationName("CreateRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     *
     * @param createVariableRequest
     * @return Result of the CreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateVariableResponse createVariable(CreateVariableRequest createVariableRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVariableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVariableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVariable");

            return clientHandler.execute(new ClientExecutionParams<CreateVariableRequest, CreateVariableResponse>()
                    .withOperationName("CreateVariable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVariableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVariableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified batch import job ID record. This action does not delete the data that was batch imported.
     * </p>
     *
     * @param deleteBatchImportJobRequest
     * @return Result of the DeleteBatchImportJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBatchImportJobResponse deleteBatchImportJob(DeleteBatchImportJobRequest deleteBatchImportJobRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBatchImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBatchImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBatchImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBatchImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBatchImportJob");

            return clientHandler.execute(new ClientExecutionParams<DeleteBatchImportJobRequest, DeleteBatchImportJobResponse>()
                    .withOperationName("DeleteBatchImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBatchImportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBatchImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a batch prediction job.
     * </p>
     *
     * @param deleteBatchPredictionJobRequest
     * @return Result of the DeleteBatchPredictionJob operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBatchPredictionJobResponse deleteBatchPredictionJob(
            DeleteBatchPredictionJobRequest deleteBatchPredictionJobRequest) throws ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBatchPredictionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBatchPredictionJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBatchPredictionJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBatchPredictionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBatchPredictionJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBatchPredictionJobRequest, DeleteBatchPredictionJobResponse>()
                            .withOperationName("DeleteBatchPredictionJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteBatchPredictionJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteBatchPredictionJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDetector");

            return clientHandler.execute(new ClientExecutionParams<DeleteDetectorRequest, DeleteDetectorResponse>()
                    .withOperationName("DeleteDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorVersionRequest
     * @return Result of the DeleteDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDetectorVersionResponse deleteDetectorVersion(DeleteDetectorVersionRequest deleteDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDetectorVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDetectorVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteDetectorVersionRequest, DeleteDetectorVersionResponse>()
                    .withOperationName("DeleteDetectorVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDetectorVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDetectorVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEntityTypeRequest
     * @return Result of the DeleteEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEntityTypeResponse deleteEntityType(DeleteEntityTypeRequest deleteEntityTypeRequest) throws ValidationException,
            ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEntityTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEntityTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEntityTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntityType");

            return clientHandler.execute(new ClientExecutionParams<DeleteEntityTypeRequest, DeleteEntityTypeResponse>()
                    .withOperationName("DeleteEntityType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteEntityTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEntityTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector. If <code>deleteAuditHistory</code> is <code>True</code>, event data is available
     * through search for up to 30 seconds after the delete operation is completed.
     * </p>
     *
     * @param deleteEventRequest
     * @return Result of the DeleteEvent operation returned by the service.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEventResponse deleteEvent(DeleteEventRequest deleteEventRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEventResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvent");

            return clientHandler.execute(new ClientExecutionParams<DeleteEventRequest, DeleteEventResponse>()
                    .withOperationName("DeleteEvent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteEventRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEventRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventTypeRequest
     * @return Result of the DeleteEventType operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEventTypeResponse deleteEventType(DeleteEventTypeRequest deleteEventTypeRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEventTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventType");

            return clientHandler.execute(new ClientExecutionParams<DeleteEventTypeRequest, DeleteEventTypeResponse>()
                    .withOperationName("DeleteEventType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteEventTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEventTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all events of a particular event type.
     * </p>
     *
     * @param deleteEventsByEventTypeRequest
     * @return Result of the DeleteEventsByEventType operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEventsByEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventsByEventTypeResponse deleteEventsByEventType(DeleteEventsByEventTypeRequest deleteEventsByEventTypeRequest)
            throws ConflictException, ValidationException, ResourceNotFoundException, InternalServerException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventsByEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventsByEventTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventsByEventTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventsByEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventsByEventType");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventsByEventTypeRequest, DeleteEventsByEventTypeResponse>()
                            .withOperationName("DeleteEventsByEventType").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEventsByEventTypeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventsByEventTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     *
     * @param deleteExternalModelRequest
     * @return Result of the DeleteExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteExternalModelResponse deleteExternalModel(DeleteExternalModelRequest deleteExternalModelRequest)
            throws ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteExternalModelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteExternalModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteExternalModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExternalModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExternalModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteExternalModelRequest, DeleteExternalModelResponse>()
                    .withOperationName("DeleteExternalModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteExternalModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteExternalModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteLabelRequest
     * @return Result of the DeleteLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLabelResponse deleteLabel(DeleteLabelRequest deleteLabelRequest) throws ValidationException, ConflictException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLabelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteLabelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLabel");

            return clientHandler.execute(new ClientExecutionParams<DeleteLabelRequest, DeleteLabelResponse>()
                    .withOperationName("DeleteLabel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteLabelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLabelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the list, provided it is not used in a rule.
     * </p>
     * <p>
     * When you delete a list, Amazon Fraud Detector permanently deletes that list and the elements in the list.
     * </p>
     *
     * @param deleteListRequest
     * @return Result of the DeleteList operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteListResponse deleteList(DeleteListRequest deleteListRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteList");

            return clientHandler.execute(new ClientExecutionParams<DeleteListRequest, DeleteListResponse>()
                    .withOperationName("DeleteList").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteListRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws ConflictException, ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                    .withOperationName("DeleteModel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelVersionRequest
     * @return Result of the DeleteModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteModelVersionResponse deleteModelVersion(DeleteModelVersionRequest deleteModelVersionRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteModelVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModelVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelVersionRequest, DeleteModelVersionResponse>()
                    .withOperationName("DeleteModelVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteModelVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteOutcomeRequest
     * @return Result of the DeleteOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteOutcomeResponse deleteOutcome(DeleteOutcomeRequest deleteOutcomeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOutcomeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOutcomeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOutcomeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOutcomeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutcome");

            return clientHandler.execute(new ClientExecutionParams<DeleteOutcomeRequest, DeleteOutcomeResponse>()
                    .withOperationName("DeleteOutcome").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOutcomeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOutcomeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConflictException, ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRule");

            return clientHandler.execute(new ClientExecutionParams<DeleteRuleRequest, DeleteRuleResponse>()
                    .withOperationName("DeleteRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteVariableRequest
     * @return Result of the DeleteVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVariableResponse deleteVariable(DeleteVariableRequest deleteVariableRequest) throws ValidationException,
            ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVariableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteVariableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVariable");

            return clientHandler.execute(new ClientExecutionParams<DeleteVariableRequest, DeleteVariableResponse>()
                    .withOperationName("DeleteVariable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVariableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVariableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     *
     * @param describeDetectorRequest
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDetector");

            return clientHandler.execute(new ClientExecutionParams<DescribeDetectorRequest, DescribeDetectorResponse>()
                    .withOperationName("DescribeDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return Result of the DescribeModelVersions operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeModelVersionsResponse describeModelVersions(DescribeModelVersionsRequest describeModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeModelVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeModelVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeModelVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeModelVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeModelVersions");

            return clientHandler.execute(new ClientExecutionParams<DescribeModelVersionsRequest, DescribeModelVersionsResponse>()
                    .withOperationName("DescribeModelVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeModelVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeModelVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     *
     * @param getBatchImportJobsRequest
     * @return Result of the GetBatchImportJobs operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBatchImportJobsResponse getBatchImportJobs(GetBatchImportJobsRequest getBatchImportJobsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBatchImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBatchImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBatchImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBatchImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBatchImportJobs");

            return clientHandler.execute(new ClientExecutionParams<GetBatchImportJobsRequest, GetBatchImportJobsResponse>()
                    .withOperationName("GetBatchImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBatchImportJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBatchImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     * @return Result of the GetBatchPredictionJobs operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBatchPredictionJobsResponse getBatchPredictionJobs(GetBatchPredictionJobsRequest getBatchPredictionJobsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBatchPredictionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBatchPredictionJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBatchPredictionJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBatchPredictionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBatchPredictionJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<GetBatchPredictionJobsRequest, GetBatchPredictionJobsResponse>()
                            .withOperationName("GetBatchPredictionJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getBatchPredictionJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetBatchPredictionJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the status of a <code>DeleteEventsByEventType</code> action.
     * </p>
     *
     * @param getDeleteEventsByEventTypeStatusRequest
     * @return Result of the GetDeleteEventsByEventTypeStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDeleteEventsByEventTypeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeleteEventsByEventTypeStatusResponse getDeleteEventsByEventTypeStatus(
            GetDeleteEventsByEventTypeStatusRequest getDeleteEventsByEventTypeStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeleteEventsByEventTypeStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeleteEventsByEventTypeStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeleteEventsByEventTypeStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDeleteEventsByEventTypeStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeleteEventsByEventTypeStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDeleteEventsByEventTypeStatusRequest, GetDeleteEventsByEventTypeStatusResponse>()
                            .withOperationName("GetDeleteEventsByEventTypeStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDeleteEventsByEventTypeStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDeleteEventsByEventTypeStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     *
     * @param getDetectorVersionRequest
     * @return Result of the GetDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDetectorVersionResponse getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDetectorVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDetectorVersion");

            return clientHandler.execute(new ClientExecutionParams<GetDetectorVersionRequest, GetDetectorVersionResponse>()
                    .withOperationName("GetDetectorVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDetectorVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDetectorVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getDetectorsRequest
     * @return Result of the GetDetectors operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDetectorsResponse getDetectors(GetDetectorsRequest getDetectorsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDetectorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDetectors");

            return clientHandler.execute(new ClientExecutionParams<GetDetectorsRequest, GetDetectorsResponse>()
                    .withOperationName("GetDetectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDetectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDetectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEntityTypesRequest
     * @return Result of the GetEntityTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEntityTypesResponse getEntityTypes(GetEntityTypesRequest getEntityTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEntityTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEntityTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEntityTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEntityTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEntityTypes");

            return clientHandler.execute(new ClientExecutionParams<GetEntityTypesRequest, GetEntityTypesResponse>()
                    .withOperationName("GetEntityTypes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEntityTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEntityTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.
     * </p>
     *
     * @param getEventRequest
     * @return Result of the GetEvent operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEventResponse getEvent(GetEventRequest getEventRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEvent");

            return clientHandler.execute(new ClientExecutionParams<GetEventRequest, GetEventResponse>()
                    .withOperationName("GetEvent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEventRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     *
     * @param getEventPredictionRequest
     * @return Result of the GetEventPrediction operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ResourceUnavailableException
     *         An exception indicating that the attached customer-owned (external) model threw an exception when Amazon
     *         Fraud Detector invoked the model.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventPrediction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventPredictionResponse getEventPrediction(GetEventPredictionRequest getEventPredictionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventPredictionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventPredictionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventPredictionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventPredictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventPrediction");

            return clientHandler.execute(new ClientExecutionParams<GetEventPredictionRequest, GetEventPredictionResponse>()
                    .withOperationName("GetEventPrediction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEventPredictionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventPredictionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector
     * version ID that was generated in the specified time period.
     * </p>
     *
     * @param getEventPredictionMetadataRequest
     * @return Result of the GetEventPredictionMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventPredictionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventPredictionMetadataResponse getEventPredictionMetadata(
            GetEventPredictionMetadataRequest getEventPredictionMetadataRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventPredictionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventPredictionMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventPredictionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventPredictionMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventPredictionMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEventPredictionMetadataRequest, GetEventPredictionMetadataResponse>()
                            .withOperationName("GetEventPredictionMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEventPredictionMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEventPredictionMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEventTypesRequest
     * @return Result of the GetEventTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEventTypesResponse getEventTypes(GetEventTypesRequest getEventTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventTypes");

            return clientHandler.execute(new ClientExecutionParams<GetEventTypesRequest, GetEventTypesResponse>()
                    .withOperationName("GetEventTypes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEventTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getExternalModelsRequest
     * @return Result of the GetExternalModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetExternalModelsResponse getExternalModels(GetExternalModelsRequest getExternalModelsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetExternalModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExternalModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExternalModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExternalModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExternalModels");

            return clientHandler.execute(new ClientExecutionParams<GetExternalModelsRequest, GetExternalModelsResponse>()
                    .withOperationName("GetExternalModels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getExternalModelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetExternalModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     * @return Result of the GetKMSEncryptionKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetKmsEncryptionKeyResponse getKMSEncryptionKey(GetKmsEncryptionKeyRequest getKmsEncryptionKeyRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetKmsEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetKmsEncryptionKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKmsEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKmsEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKMSEncryptionKey");

            return clientHandler.execute(new ClientExecutionParams<GetKmsEncryptionKeyRequest, GetKmsEncryptionKeyResponse>()
                    .withOperationName("GetKMSEncryptionKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getKmsEncryptionKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetKmsEncryptionKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getLabelsRequest
     * @return Result of the GetLabels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLabelsResponse getLabels(GetLabelsRequest getLabelsRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLabelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLabelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLabels");

            return clientHandler.execute(new ClientExecutionParams<GetLabelsRequest, GetLabelsResponse>()
                    .withOperationName("GetLabels").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getLabelsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLabelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all the elements in the specified list.
     * </p>
     *
     * @param getListElementsRequest
     * @return Result of the GetListElements operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetListElements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListElements" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetListElementsResponse getListElements(GetListElementsRequest getListElementsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetListElementsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetListElementsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getListElementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getListElementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetListElements");

            return clientHandler.execute(new ClientExecutionParams<GetListElementsRequest, GetListElementsResponse>()
                    .withOperationName("GetListElements").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getListElementsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetListElementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the metadata of either all the lists under the account or the specified list.
     * </p>
     *
     * @param getListsMetadataRequest
     * @return Result of the GetListsMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetListsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetListsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetListsMetadataResponse getListsMetadata(GetListsMetadataRequest getListsMetadataRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetListsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetListsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getListsMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getListsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetListsMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetListsMetadataRequest, GetListsMetadataResponse>()
                    .withOperationName("GetListsMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getListsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetListsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     *
     * @param getModelVersionRequest
     * @return Result of the GetModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetModelVersionResponse getModelVersion(GetModelVersionRequest getModelVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelVersion");

            return clientHandler.execute(new ClientExecutionParams<GetModelVersionRequest, GetModelVersionResponse>()
                    .withOperationName("GetModelVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getModelVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetModelVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getModelsRequest
     * @return Result of the GetModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");

            return clientHandler.execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>()
                    .withOperationName("GetModels").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getModelsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getOutcomesRequest
     * @return Result of the GetOutcomes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOutcomesResponse getOutcomes(GetOutcomesRequest getOutcomesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOutcomesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOutcomesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOutcomesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOutcomesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOutcomes");

            return clientHandler.execute(new ClientExecutionParams<GetOutcomesRequest, GetOutcomesResponse>()
                    .withOperationName("GetOutcomes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getOutcomesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOutcomesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getRulesRequest
     * @return Result of the GetRules operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRulesResponse getRules(GetRulesRequest getRulesRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRules");

            return clientHandler.execute(new ClientExecutionParams<GetRulesRequest, GetRulesResponse>()
                    .withOperationName("GetRules").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getRulesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getVariablesRequest
     * @return Result of the GetVariables operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetVariablesResponse getVariables(GetVariablesRequest getVariablesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVariablesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVariablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariablesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariables");

            return clientHandler.execute(new ClientExecutionParams<GetVariablesRequest, GetVariablesResponse>()
                    .withOperationName("GetVariables").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getVariablesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVariablesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     *
     * @param listEventPredictionsRequest
     * @return Result of the ListEventPredictions operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventPredictionsResponse listEventPredictions(ListEventPredictionsRequest listEventPredictionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventPredictionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventPredictionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventPredictionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventPredictionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventPredictions");

            return clientHandler.execute(new ClientExecutionParams<ListEventPredictionsRequest, ListEventPredictionsResponse>()
                    .withOperationName("ListEventPredictions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEventPredictionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEventPredictionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     *
     * @param putDetectorRequest
     * @return Result of the PutDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDetectorResponse putDetector(PutDetectorRequest putDetectorRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDetector");

            return clientHandler.execute(new ClientExecutionParams<PutDetectorRequest, PutDetectorResponse>()
                    .withOperationName("PutDetector").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putDetectorRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     *
     * @param putEntityTypeRequest
     * @return Result of the PutEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutEntityTypeResponse putEntityType(PutEntityTypeRequest putEntityTypeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEntityTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEntityTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEntityTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEntityTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEntityType");

            return clientHandler.execute(new ClientExecutionParams<PutEntityTypeRequest, PutEntityTypeResponse>()
                    .withOperationName("PutEntityType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putEntityTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutEntityTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     *
     * @param putEventTypeRequest
     * @return Result of the PutEventType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutEventTypeResponse putEventType(PutEventTypeRequest putEventTypeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEventTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEventTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventType");

            return clientHandler.execute(new ClientExecutionParams<PutEventTypeRequest, PutEventTypeResponse>()
                    .withOperationName("PutEventType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putEventTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutEventTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     *
     * @param putExternalModelRequest
     * @return Result of the PutExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutExternalModelResponse putExternalModel(PutExternalModelRequest putExternalModelRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutExternalModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutExternalModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putExternalModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putExternalModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutExternalModel");

            return clientHandler.execute(new ClientExecutionParams<PutExternalModelRequest, PutExternalModelResponse>()
                    .withOperationName("PutExternalModel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putExternalModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutExternalModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     * @return Result of the PutKMSEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutKmsEncryptionKeyResponse putKMSEncryptionKey(PutKmsEncryptionKeyRequest putKmsEncryptionKeyRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutKmsEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutKmsEncryptionKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putKmsEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putKmsEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutKMSEncryptionKey");

            return clientHandler.execute(new ClientExecutionParams<PutKmsEncryptionKeyRequest, PutKmsEncryptionKeyResponse>()
                    .withOperationName("PutKMSEncryptionKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putKmsEncryptionKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutKmsEncryptionKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     *
     * @param putLabelRequest
     * @return Result of the PutLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutLabelResponse putLabel(PutLabelRequest putLabelRequest) throws ValidationException, InternalServerException,
            ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLabelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutLabelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLabel");

            return clientHandler.execute(new ClientExecutionParams<PutLabelRequest, PutLabelResponse>()
                    .withOperationName("PutLabel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putLabelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutLabelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     *
     * @param putOutcomeRequest
     * @return Result of the PutOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutOutcomeResponse putOutcome(PutOutcomeRequest putOutcomeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutOutcomeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutOutcomeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putOutcomeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOutcomeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOutcome");

            return clientHandler.execute(new ClientExecutionParams<PutOutcomeRequest, PutOutcomeResponse>()
                    .withOperationName("PutOutcome").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putOutcomeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutOutcomeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you
     * can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.
     * </p>
     *
     * @param sendEventRequest
     * @return Result of the SendEvent operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.SendEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendEventResponse sendEvent(SendEventRequest sendEventRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendEventResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendEventResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendEventRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendEvent");

            return clientHandler.execute(new ClientExecutionParams<SendEventRequest, SendEventResponse>()
                    .withOperationName("SendEvent").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(sendEventRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendEventRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     *
     * @param updateDetectorVersionRequest
     * @return Result of the UpdateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDetectorVersionResponse updateDetectorVersion(UpdateDetectorVersionRequest updateDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDetectorVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDetectorVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDetectorVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersion");

            return clientHandler.execute(new ClientExecutionParams<UpdateDetectorVersionRequest, UpdateDetectorVersionResponse>()
                    .withOperationName("UpdateDetectorVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDetectorVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDetectorVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     * @return Result of the UpdateDetectorVersionMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDetectorVersionMetadataResponse updateDetectorVersionMetadata(
            UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDetectorVersionMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDetectorVersionMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDetectorVersionMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersionMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorVersionMetadataRequest, UpdateDetectorVersionMetadataResponse>()
                            .withOperationName("UpdateDetectorVersionMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDetectorVersionMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDetectorVersionMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     * @return Result of the UpdateDetectorVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDetectorVersionStatusResponse updateDetectorVersionStatus(
            UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDetectorVersionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDetectorVersionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDetectorVersionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDetectorVersionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDetectorVersionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDetectorVersionStatusRequest, UpdateDetectorVersionStatusResponse>()
                            .withOperationName("UpdateDetectorVersionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDetectorVersionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDetectorVersionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified event with a new label.
     * </p>
     *
     * @param updateEventLabelRequest
     * @return Result of the UpdateEventLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateEventLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventLabelResponse updateEventLabel(UpdateEventLabelRequest updateEventLabelRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventLabelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateEventLabelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventLabelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventLabelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventLabel");

            return clientHandler.execute(new ClientExecutionParams<UpdateEventLabelRequest, UpdateEventLabelResponse>()
                    .withOperationName("UpdateEventLabel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateEventLabelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEventLabelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a list.
     * </p>
     *
     * @param updateListRequest
     * @return Result of the UpdateList operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateListResponse updateList(UpdateListRequest updateListRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateList");

            return clientHandler.execute(new ClientExecutionParams<UpdateListRequest, UpdateListResponse>()
                    .withOperationName("UpdateList").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateListRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates model description.
     * </p>
     *
     * @param updateModelRequest
     * @return Result of the UpdateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");

            return clientHandler.execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                    .withOperationName("UpdateModel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateModelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateModelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     *
     * @param updateModelVersionRequest
     * @return Result of the UpdateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateModelVersionResponse updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateModelVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelVersion");

            return clientHandler.execute(new ClientExecutionParams<UpdateModelVersionRequest, UpdateModelVersionResponse>()
                    .withOperationName("UpdateModelVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateModelVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateModelVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_IN_PROGRESS</code> status to <code>TRAINING_CANCELLED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateModelVersionStatusRequest
     * @return Result of the UpdateModelVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateModelVersionStatusResponse updateModelVersionStatus(
            UpdateModelVersionStatusRequest updateModelVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelVersionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateModelVersionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelVersionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelVersionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModelVersionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateModelVersionStatusRequest, UpdateModelVersionStatusResponse>()
                            .withOperationName("UpdateModelVersionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateModelVersionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateModelVersionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     *
     * @param updateRuleMetadataRequest
     * @return Result of the UpdateRuleMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRuleMetadataResponse updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRuleMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRuleMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleMetadata");

            return clientHandler.execute(new ClientExecutionParams<UpdateRuleMetadataRequest, UpdateRuleMetadataResponse>()
                    .withOperationName("UpdateRuleMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRuleMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRuleMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     *
     * @param updateRuleVersionRequest
     * @return Result of the UpdateRuleVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRuleVersionResponse updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRuleVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRuleVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleVersion");

            return clientHandler.execute(new ClientExecutionParams<UpdateRuleVersionRequest, UpdateRuleVersionResponse>()
                    .withOperationName("UpdateRuleVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRuleVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRuleVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     *
     * @param updateVariableRequest
     * @return Result of the UpdateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateVariableResponse updateVariable(UpdateVariableRequest updateVariableRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, ConflictException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVariableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateVariableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVariableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVariableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "FraudDetector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVariable");

            return clientHandler.execute(new ClientExecutionParams<UpdateVariableRequest, UpdateVariableResponse>()
                    .withOperationName("UpdateVariable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateVariableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVariableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        FraudDetectorServiceClientConfigurationBuilder serviceConfigBuilder = new FraudDetectorServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(FraudDetectorException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build());
    }

    @Override
    public final FraudDetectorServiceClientConfiguration serviceClientConfiguration() {
        return new FraudDetectorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
