/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the Kinesis Data Firehose destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisFirehoseDestinationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisFirehoseDestinationDetails.Builder, KinesisFirehoseDestinationDetails> {
    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStream").getter(getter(KinesisFirehoseDestinationDetails::deliveryStream))
            .setter(setter(Builder::deliveryStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deliveryStream;

    private KinesisFirehoseDestinationDetails(BuilderImpl builder) {
        this.deliveryStream = builder.deliveryStream;
    }

    /**
     * <p>
     * The name of the Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @return The name of the Kinesis Data Firehose delivery stream.
     */
    public final String deliveryStream() {
        return deliveryStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestinationDetails)) {
            return false;
        }
        KinesisFirehoseDestinationDetails other = (KinesisFirehoseDestinationDetails) obj;
        return Objects.equals(deliveryStream(), other.deliveryStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisFirehoseDestinationDetails").add("DeliveryStream", deliveryStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStream":
            return Optional.ofNullable(clazz.cast(deliveryStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestinationDetails, T> g) {
        return obj -> g.apply((KinesisFirehoseDestinationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisFirehoseDestinationDetails> {
        /**
         * <p>
         * The name of the Kinesis Data Firehose delivery stream.
         * </p>
         * 
         * @param deliveryStream
         *        The name of the Kinesis Data Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStream(String deliveryStream);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStream;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestinationDetails model) {
            deliveryStream(model.deliveryStream);
        }

        public final String getDeliveryStream() {
            return deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        @Override
        public KinesisFirehoseDestinationDetails build() {
            return new KinesisFirehoseDestinationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
