/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncreaseReplicaCountRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<IncreaseReplicaCountRequest.Builder, IncreaseReplicaCountRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(IncreaseReplicaCountRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> NEW_REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NewReplicaCount").getter(getter(IncreaseReplicaCountRequest::newReplicaCount))
            .setter(setter(Builder::newReplicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewReplicaCount").build()).build();

    private static final SdkField<List<ConfigureShard>> REPLICA_CONFIGURATION_FIELD = SdkField
            .<List<ConfigureShard>> builder(MarshallingType.LIST)
            .memberName("ReplicaConfiguration")
            .getter(getter(IncreaseReplicaCountRequest::replicaConfiguration))
            .setter(setter(Builder::replicaConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ConfigureShard")
                            .memberFieldInfo(
                                    SdkField.<ConfigureShard> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigureShard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ConfigureShard").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(IncreaseReplicaCountRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            NEW_REPLICA_COUNT_FIELD, REPLICA_CONFIGURATION_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String replicationGroupId;

    private final Integer newReplicaCount;

    private final List<ConfigureShard> replicaConfiguration;

    private final Boolean applyImmediately;

    private IncreaseReplicaCountRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.newReplicaCount = builder.newReplicaCount;
        this.replicaConfiguration = builder.replicaConfiguration;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The id of the replication group to which you want to add replica nodes.
     * </p>
     * 
     * @return The id of the replication group to which you want to add replica nodes.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled)
     * replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode
     * enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.
     * </p>
     * 
     * @return The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
     *         disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
     *         (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication
     *         group's node groups.
     */
    public final Integer newReplicaCount() {
        return newReplicaCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicaConfiguration() {
        return replicaConfiguration != null && !(replicaConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode
     * enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>,
     * <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaConfiguration} method.
     * </p>
     * 
     * @return A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
     *         (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
     *         <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
     */
    public final List<ConfigureShard> replicaConfiguration() {
        return replicaConfiguration;
    }

    /**
     * <p>
     * If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code>
     * is not currently supported.
     * </p>
     * 
     * @return If <code>True</code>, the number of replica nodes is increased immediately.
     *         <code>ApplyImmediately=False</code> is not currently supported.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(newReplicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaConfiguration() ? replicaConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncreaseReplicaCountRequest)) {
            return false;
        }
        IncreaseReplicaCountRequest other = (IncreaseReplicaCountRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(newReplicaCount(), other.newReplicaCount())
                && hasReplicaConfiguration() == other.hasReplicaConfiguration()
                && Objects.equals(replicaConfiguration(), other.replicaConfiguration())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncreaseReplicaCountRequest").add("ReplicationGroupId", replicationGroupId())
                .add("NewReplicaCount", newReplicaCount())
                .add("ReplicaConfiguration", hasReplicaConfiguration() ? replicaConfiguration() : null)
                .add("ApplyImmediately", applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "NewReplicaCount":
            return Optional.ofNullable(clazz.cast(newReplicaCount()));
        case "ReplicaConfiguration":
            return Optional.ofNullable(clazz.cast(replicaConfiguration()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncreaseReplicaCountRequest, T> g) {
        return obj -> g.apply((IncreaseReplicaCountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, IncreaseReplicaCountRequest> {
        /**
         * <p>
         * The id of the replication group to which you want to add replica nodes.
         * </p>
         * 
         * @param replicationGroupId
         *        The id of the replication group to which you want to add replica nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
         * disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
         * (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication
         * group's node groups.
         * </p>
         * 
         * @param newReplicaCount
         *        The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode
         *        disabled) replication groups, this is the number of replica nodes in the replication group. For Redis
         *        (cluster mode enabled) replication groups, this is the number of replica nodes in each of the
         *        replication group's node groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newReplicaCount(Integer newReplicaCount);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * 
         * @param replicaConfiguration
         *        A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
         *        (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         *        <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaConfiguration(Collection<ConfigureShard> replicaConfiguration);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * 
         * @param replicaConfiguration
         *        A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis
         *        (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         *        <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaConfiguration(ConfigureShard... replicaConfiguration);

        /**
         * <p>
         * A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster
         * mode enabled) replication group. The <code>ConfigureShard</code> has three members:
         * <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.ConfigureShard.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elasticache.model.ConfigureShard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.ConfigureShard.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaConfiguration(List<ConfigureShard>)}.
         * 
         * @param replicaConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.ConfigureShard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaConfiguration(java.util.Collection<ConfigureShard>)
         */
        Builder replicaConfiguration(Consumer<ConfigureShard.Builder>... replicaConfiguration);

        /**
         * <p>
         * If <code>True</code>, the number of replica nodes is increased immediately.
         * <code>ApplyImmediately=False</code> is not currently supported.
         * </p>
         * 
         * @param applyImmediately
         *        If <code>True</code>, the number of replica nodes is increased immediately.
         *        <code>ApplyImmediately=False</code> is not currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private Integer newReplicaCount;

        private List<ConfigureShard> replicaConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(IncreaseReplicaCountRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            newReplicaCount(model.newReplicaCount);
            replicaConfiguration(model.replicaConfiguration);
            applyImmediately(model.applyImmediately);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final Integer getNewReplicaCount() {
            return newReplicaCount;
        }

        public final void setNewReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
        }

        @Override
        public final Builder newReplicaCount(Integer newReplicaCount) {
            this.newReplicaCount = newReplicaCount;
            return this;
        }

        public final List<ConfigureShard.Builder> getReplicaConfiguration() {
            List<ConfigureShard.Builder> result = ReplicaConfigurationListCopier.copyToBuilder(this.replicaConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaConfiguration(Collection<ConfigureShard.BuilderImpl> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copyFromBuilder(replicaConfiguration);
        }

        @Override
        public final Builder replicaConfiguration(Collection<ConfigureShard> replicaConfiguration) {
            this.replicaConfiguration = ReplicaConfigurationListCopier.copy(replicaConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(ConfigureShard... replicaConfiguration) {
            replicaConfiguration(Arrays.asList(replicaConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaConfiguration(Consumer<ConfigureShard.Builder>... replicaConfiguration) {
            replicaConfiguration(Stream.of(replicaConfiguration).map(c -> ConfigureShard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IncreaseReplicaCountRequest build() {
            return new IncreaseReplicaCountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
