/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServerlessCacheRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DeleteServerlessCacheRequest.Builder, DeleteServerlessCacheRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(DeleteServerlessCacheRequest::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<String> FINAL_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalSnapshotName").getter(getter(DeleteServerlessCacheRequest::finalSnapshotName))
            .setter(setter(Builder::finalSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalSnapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            FINAL_SNAPSHOT_NAME_FIELD));

    private final String serverlessCacheName;

    private final String finalSnapshotName;

    private DeleteServerlessCacheRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.finalSnapshotName = builder.finalSnapshotName;
    }

    /**
     * <p>
     * The identifier of the serverless cache to be deleted.
     * </p>
     * 
     * @return The identifier of the serverless cache to be deleted.
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * Name of the final snapshot to be taken before the serverless cache is deleted. Available for Redis only. Default:
     * NULL, i.e. a final snapshot is not taken.
     * </p>
     * 
     * @return Name of the final snapshot to be taken before the serverless cache is deleted. Available for Redis only.
     *         Default: NULL, i.e. a final snapshot is not taken.
     */
    public final String finalSnapshotName() {
        return finalSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(finalSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServerlessCacheRequest)) {
            return false;
        }
        DeleteServerlessCacheRequest other = (DeleteServerlessCacheRequest) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(finalSnapshotName(), other.finalSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteServerlessCacheRequest").add("ServerlessCacheName", serverlessCacheName())
                .add("FinalSnapshotName", finalSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "FinalSnapshotName":
            return Optional.ofNullable(clazz.cast(finalSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServerlessCacheRequest, T> g) {
        return obj -> g.apply((DeleteServerlessCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteServerlessCacheRequest> {
        /**
         * <p>
         * The identifier of the serverless cache to be deleted.
         * </p>
         * 
         * @param serverlessCacheName
         *        The identifier of the serverless cache to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * Name of the final snapshot to be taken before the serverless cache is deleted. Available for Redis only.
         * Default: NULL, i.e. a final snapshot is not taken.
         * </p>
         * 
         * @param finalSnapshotName
         *        Name of the final snapshot to be taken before the serverless cache is deleted. Available for Redis
         *        only. Default: NULL, i.e. a final snapshot is not taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalSnapshotName(String finalSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheName;

        private String finalSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServerlessCacheRequest model) {
            super(model);
            serverlessCacheName(model.serverlessCacheName);
            finalSnapshotName(model.finalSnapshotName);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getFinalSnapshotName() {
            return finalSnapshotName;
        }

        public final void setFinalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
        }

        @Override
        public final Builder finalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServerlessCacheRequest build() {
            return new DeleteServerlessCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
