/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttachmentLimitType;
import software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport;
import software.amazon.awssdk.services.ec2.model.EbsNvmeSupport;
import software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo;
import software.amazon.awssdk.services.ec2.model.EbsOptimizedSupport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsInfo> {
    private static final SdkField<String> EBS_OPTIMIZED_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EbsOptimizedSupport").getter(EbsInfo.getter(EbsInfo::ebsOptimizedSupportAsString)).setter(EbsInfo.setter(Builder::ebsOptimizedSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedSupport").unmarshallLocationName("ebsOptimizedSupport").build()}).build();
    private static final SdkField<String> ENCRYPTION_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionSupport").getter(EbsInfo.getter(EbsInfo::encryptionSupportAsString)).setter(EbsInfo.setter(Builder::encryptionSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSupport").unmarshallLocationName("encryptionSupport").build()}).build();
    private static final SdkField<EbsOptimizedInfo> EBS_OPTIMIZED_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsOptimizedInfo").getter(EbsInfo.getter(EbsInfo::ebsOptimizedInfo)).setter(EbsInfo.setter(Builder::ebsOptimizedInfo)).constructor(EbsOptimizedInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimizedInfo").unmarshallLocationName("ebsOptimizedInfo").build()}).build();
    private static final SdkField<String> NVME_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NvmeSupport").getter(EbsInfo.getter(EbsInfo::nvmeSupportAsString)).setter(EbsInfo.setter(Builder::nvmeSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NvmeSupport").unmarshallLocationName("nvmeSupport").build()}).build();
    private static final SdkField<Integer> MAXIMUM_EBS_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumEbsAttachments").getter(EbsInfo.getter(EbsInfo::maximumEbsAttachments)).setter(EbsInfo.setter(Builder::maximumEbsAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEbsAttachments").unmarshallLocationName("maximumEbsAttachments").build()}).build();
    private static final SdkField<String> ATTACHMENT_LIMIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentLimitType").getter(EbsInfo.getter(EbsInfo::attachmentLimitTypeAsString)).setter(EbsInfo.setter(Builder::attachmentLimitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentLimitType").unmarshallLocationName("attachmentLimitType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_OPTIMIZED_SUPPORT_FIELD, ENCRYPTION_SUPPORT_FIELD, EBS_OPTIMIZED_INFO_FIELD, NVME_SUPPORT_FIELD, MAXIMUM_EBS_ATTACHMENTS_FIELD, ATTACHMENT_LIMIT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EbsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ebsOptimizedSupport;
    private final String encryptionSupport;
    private final EbsOptimizedInfo ebsOptimizedInfo;
    private final String nvmeSupport;
    private final Integer maximumEbsAttachments;
    private final String attachmentLimitType;

    private EbsInfo(BuilderImpl builder) {
        this.ebsOptimizedSupport = builder.ebsOptimizedSupport;
        this.encryptionSupport = builder.encryptionSupport;
        this.ebsOptimizedInfo = builder.ebsOptimizedInfo;
        this.nvmeSupport = builder.nvmeSupport;
        this.maximumEbsAttachments = builder.maximumEbsAttachments;
        this.attachmentLimitType = builder.attachmentLimitType;
    }

    public final EbsOptimizedSupport ebsOptimizedSupport() {
        return EbsOptimizedSupport.fromValue(this.ebsOptimizedSupport);
    }

    public final String ebsOptimizedSupportAsString() {
        return this.ebsOptimizedSupport;
    }

    public final EbsEncryptionSupport encryptionSupport() {
        return EbsEncryptionSupport.fromValue(this.encryptionSupport);
    }

    public final String encryptionSupportAsString() {
        return this.encryptionSupport;
    }

    public final EbsOptimizedInfo ebsOptimizedInfo() {
        return this.ebsOptimizedInfo;
    }

    public final EbsNvmeSupport nvmeSupport() {
        return EbsNvmeSupport.fromValue(this.nvmeSupport);
    }

    public final String nvmeSupportAsString() {
        return this.nvmeSupport;
    }

    public final Integer maximumEbsAttachments() {
        return this.maximumEbsAttachments;
    }

    public final AttachmentLimitType attachmentLimitType() {
        return AttachmentLimitType.fromValue(this.attachmentLimitType);
    }

    public final String attachmentLimitTypeAsString() {
        return this.attachmentLimitType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimizedSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimizedInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.nvmeSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumEbsAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentLimitTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInfo)) {
            return false;
        }
        EbsInfo other = (EbsInfo)obj;
        return Objects.equals(this.ebsOptimizedSupportAsString(), other.ebsOptimizedSupportAsString()) && Objects.equals(this.encryptionSupportAsString(), other.encryptionSupportAsString()) && Objects.equals(this.ebsOptimizedInfo(), other.ebsOptimizedInfo()) && Objects.equals(this.nvmeSupportAsString(), other.nvmeSupportAsString()) && Objects.equals(this.maximumEbsAttachments(), other.maximumEbsAttachments()) && Objects.equals(this.attachmentLimitTypeAsString(), other.attachmentLimitTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EbsInfo").add("EbsOptimizedSupport", (Object)this.ebsOptimizedSupportAsString()).add("EncryptionSupport", (Object)this.encryptionSupportAsString()).add("EbsOptimizedInfo", (Object)this.ebsOptimizedInfo()).add("NvmeSupport", (Object)this.nvmeSupportAsString()).add("MaximumEbsAttachments", (Object)this.maximumEbsAttachments()).add("AttachmentLimitType", (Object)this.attachmentLimitTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EbsOptimizedSupport": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimizedSupportAsString()));
            }
            case "EncryptionSupport": {
                return Optional.ofNullable(clazz.cast(this.encryptionSupportAsString()));
            }
            case "EbsOptimizedInfo": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimizedInfo()));
            }
            case "NvmeSupport": {
                return Optional.ofNullable(clazz.cast(this.nvmeSupportAsString()));
            }
            case "MaximumEbsAttachments": {
                return Optional.ofNullable(clazz.cast(this.maximumEbsAttachments()));
            }
            case "AttachmentLimitType": {
                return Optional.ofNullable(clazz.cast(this.attachmentLimitTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EbsOptimizedSupport", EBS_OPTIMIZED_SUPPORT_FIELD);
        map.put("EncryptionSupport", ENCRYPTION_SUPPORT_FIELD);
        map.put("EbsOptimizedInfo", EBS_OPTIMIZED_INFO_FIELD);
        map.put("NvmeSupport", NVME_SUPPORT_FIELD);
        map.put("MaximumEbsAttachments", MAXIMUM_EBS_ATTACHMENTS_FIELD);
        map.put("AttachmentLimitType", ATTACHMENT_LIMIT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsInfo, T> g) {
        return obj -> g.apply((EbsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ebsOptimizedSupport;
        private String encryptionSupport;
        private EbsOptimizedInfo ebsOptimizedInfo;
        private String nvmeSupport;
        private Integer maximumEbsAttachments;
        private String attachmentLimitType;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInfo model) {
            this.ebsOptimizedSupport(model.ebsOptimizedSupport);
            this.encryptionSupport(model.encryptionSupport);
            this.ebsOptimizedInfo(model.ebsOptimizedInfo);
            this.nvmeSupport(model.nvmeSupport);
            this.maximumEbsAttachments(model.maximumEbsAttachments);
            this.attachmentLimitType(model.attachmentLimitType);
        }

        public final String getEbsOptimizedSupport() {
            return this.ebsOptimizedSupport;
        }

        public final void setEbsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
        }

        @Override
        public final Builder ebsOptimizedSupport(String ebsOptimizedSupport) {
            this.ebsOptimizedSupport = ebsOptimizedSupport;
            return this;
        }

        @Override
        public final Builder ebsOptimizedSupport(EbsOptimizedSupport ebsOptimizedSupport) {
            this.ebsOptimizedSupport(ebsOptimizedSupport == null ? null : ebsOptimizedSupport.toString());
            return this;
        }

        public final String getEncryptionSupport() {
            return this.encryptionSupport;
        }

        public final void setEncryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
        }

        @Override
        public final Builder encryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
            return this;
        }

        @Override
        public final Builder encryptionSupport(EbsEncryptionSupport encryptionSupport) {
            this.encryptionSupport(encryptionSupport == null ? null : encryptionSupport.toString());
            return this;
        }

        public final EbsOptimizedInfo.Builder getEbsOptimizedInfo() {
            return this.ebsOptimizedInfo != null ? this.ebsOptimizedInfo.toBuilder() : null;
        }

        public final void setEbsOptimizedInfo(EbsOptimizedInfo.BuilderImpl ebsOptimizedInfo) {
            this.ebsOptimizedInfo = ebsOptimizedInfo != null ? ebsOptimizedInfo.build() : null;
        }

        @Override
        public final Builder ebsOptimizedInfo(EbsOptimizedInfo ebsOptimizedInfo) {
            this.ebsOptimizedInfo = ebsOptimizedInfo;
            return this;
        }

        public final String getNvmeSupport() {
            return this.nvmeSupport;
        }

        public final void setNvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
        }

        @Override
        public final Builder nvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
            return this;
        }

        @Override
        public final Builder nvmeSupport(EbsNvmeSupport nvmeSupport) {
            this.nvmeSupport(nvmeSupport == null ? null : nvmeSupport.toString());
            return this;
        }

        public final Integer getMaximumEbsAttachments() {
            return this.maximumEbsAttachments;
        }

        public final void setMaximumEbsAttachments(Integer maximumEbsAttachments) {
            this.maximumEbsAttachments = maximumEbsAttachments;
        }

        @Override
        public final Builder maximumEbsAttachments(Integer maximumEbsAttachments) {
            this.maximumEbsAttachments = maximumEbsAttachments;
            return this;
        }

        public final String getAttachmentLimitType() {
            return this.attachmentLimitType;
        }

        public final void setAttachmentLimitType(String attachmentLimitType) {
            this.attachmentLimitType = attachmentLimitType;
        }

        @Override
        public final Builder attachmentLimitType(String attachmentLimitType) {
            this.attachmentLimitType = attachmentLimitType;
            return this;
        }

        @Override
        public final Builder attachmentLimitType(AttachmentLimitType attachmentLimitType) {
            this.attachmentLimitType(attachmentLimitType == null ? null : attachmentLimitType.toString());
            return this;
        }

        public EbsInfo build() {
            return new EbsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsInfo> {
        public Builder ebsOptimizedSupport(String var1);

        public Builder ebsOptimizedSupport(EbsOptimizedSupport var1);

        public Builder encryptionSupport(String var1);

        public Builder encryptionSupport(EbsEncryptionSupport var1);

        public Builder ebsOptimizedInfo(EbsOptimizedInfo var1);

        default public Builder ebsOptimizedInfo(Consumer<EbsOptimizedInfo.Builder> ebsOptimizedInfo) {
            return this.ebsOptimizedInfo((EbsOptimizedInfo)((EbsOptimizedInfo.Builder)EbsOptimizedInfo.builder().applyMutation(ebsOptimizedInfo)).build());
        }

        public Builder nvmeSupport(String var1);

        public Builder nvmeSupport(EbsNvmeSupport var1);

        public Builder maximumEbsAttachments(Integer var1);

        public Builder attachmentLimitType(String var1);

        public Builder attachmentLimitType(AttachmentLimitType var1);
    }
}

