/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 bucket that is being imported from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketSource implements SdkPojo, Serializable, ToCopyableBuilder<S3BucketSource.Builder, S3BucketSource> {
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketOwner").getter(getter(S3BucketSource::s3BucketOwner)).setter(setter(Builder::s3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(S3BucketSource::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix").getter(getter(S3BucketSource::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_OWNER_FIELD,
            S3_BUCKET_FIELD, S3_KEY_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketOwner;

    private final String s3Bucket;

    private final String s3KeyPrefix;

    private S3BucketSource(BuilderImpl builder) {
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    /**
     * <p>
     * The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this is
     * optional.
     * </p>
     * 
     * @return The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester
     *         this is optional.
     */
    public final String s3BucketOwner() {
        return s3BucketOwner;
    }

    /**
     * <p>
     * The S3 bucket that is being imported from.
     * </p>
     * 
     * @return The S3 bucket that is being imported from.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The key prefix shared by all S3 Objects that are being imported.
     * </p>
     * 
     * @return The key prefix shared by all S3 Objects that are being imported.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketSource)) {
            return false;
        }
        S3BucketSource other = (S3BucketSource) obj;
        return Objects.equals(s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketSource").add("S3BucketOwner", s3BucketOwner()).add("S3Bucket", s3Bucket())
                .add("S3KeyPrefix", s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketOwner":
            return Optional.ofNullable(clazz.cast(s3BucketOwner()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketSource, T> g) {
        return obj -> g.apply((S3BucketSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketSource> {
        /**
         * <p>
         * The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this
         * is optional.
         * </p>
         * 
         * @param s3BucketOwner
         *        The account number of the S3 bucket that is being imported from. If the bucket is owned by the
         *        requester this is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketOwner(String s3BucketOwner);

        /**
         * <p>
         * The S3 bucket that is being imported from.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket that is being imported from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The key prefix shared by all S3 Objects that are being imported.
         * </p>
         * 
         * @param s3KeyPrefix
         *        The key prefix shared by all S3 Objects that are being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketOwner;

        private String s3Bucket;

        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketSource model) {
            s3BucketOwner(model.s3BucketOwner);
            s3Bucket(model.s3Bucket);
            s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getS3BucketOwner() {
            return s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Override
        public S3BucketSource build() {
            return new S3BucketSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
