/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an attribute for describing the schema for the table and indexes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeDefinition.Builder, AttributeDefinition> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(AttributeDefinition::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeType").getter(getter(AttributeDefinition::attributeTypeAsString))
            .setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeType;

    private AttributeDefinition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    /**
     * <p>
     * A name for the attribute.
     * </p>
     * 
     * @return A name for the attribute.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The data type for the attribute, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S</code> - the attribute is of type String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>N</code> - the attribute is of type Number
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>B</code> - the attribute is of type Binary
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link ScalarAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type for the attribute, where:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S</code> - the attribute is of type String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>N</code> - the attribute is of type Number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>B</code> - the attribute is of type Binary
     *         </p>
     *         </li>
     * @see ScalarAttributeType
     */
    public final ScalarAttributeType attributeType() {
        return ScalarAttributeType.fromValue(attributeType);
    }

    /**
     * <p>
     * The data type for the attribute, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S</code> - the attribute is of type String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>N</code> - the attribute is of type Number
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>B</code> - the attribute is of type Binary
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link ScalarAttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type for the attribute, where:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S</code> - the attribute is of type String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>N</code> - the attribute is of type Number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>B</code> - the attribute is of type Binary
     *         </p>
     *         </li>
     * @see ScalarAttributeType
     */
    public final String attributeTypeAsString() {
        return attributeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeTypeAsString(), other.attributeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeDefinition").add("AttributeName", attributeName())
                .add("AttributeType", attributeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeDefinition, T> g) {
        return obj -> g.apply((AttributeDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeDefinition> {
        /**
         * <p>
         * A name for the attribute.
         * </p>
         * 
         * @param attributeName
         *        A name for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The data type for the attribute, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S</code> - the attribute is of type String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>N</code> - the attribute is of type Number
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>B</code> - the attribute is of type Binary
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeType
         *        The data type for the attribute, where:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S</code> - the attribute is of type String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>N</code> - the attribute is of type Number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>B</code> - the attribute is of type Binary
         *        </p>
         *        </li>
         * @see ScalarAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarAttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The data type for the attribute, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S</code> - the attribute is of type String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>N</code> - the attribute is of type Number
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>B</code> - the attribute is of type Binary
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeType
         *        The data type for the attribute, where:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S</code> - the attribute is of type String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>N</code> - the attribute is of type Number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>B</code> - the attribute is of type Binary
         *        </p>
         *        </li>
         * @see ScalarAttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarAttributeType
         */
        Builder attributeType(ScalarAttributeType attributeType);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDefinition model) {
            attributeName(model.attributeName);
            attributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(ScalarAttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        @Override
        public AttributeDefinition build() {
            return new AttributeDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
