/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUpdateDirectoryRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeUpdateDirectoryRequest.Builder, DescribeUpdateDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeUpdateDirectoryRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateType").getter(getter(DescribeUpdateDirectoryRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(DescribeUpdateDirectoryRequest::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeUpdateDirectoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            UPDATE_TYPE_FIELD, REGION_NAME_FIELD, NEXT_TOKEN_FIELD));

    private final String directoryId;

    private final String updateType;

    private final String regionName;

    private final String nextToken;

    private DescribeUpdateDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.updateType = builder.updateType;
        this.regionName = builder.regionName;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the directory.
     * </p>
     * 
     * @return The unique identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The type of updates you want to describe for the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of updates you want to describe for the directory.
     * @see UpdateType
     */
    public final UpdateType updateType() {
        return UpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of updates you want to describe for the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of updates you want to describe for the directory.
     * @see UpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    /**
     * <p>
     * The name of the Region.
     * </p>
     * 
     * @return The name of the Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The <code>DescribeUpdateDirectoryResult</code>. NextToken value from a previous call to
     * <a>DescribeUpdateDirectory</a>. Pass null if this is the first call.
     * </p>
     * 
     * @return The <code>DescribeUpdateDirectoryResult</code>. NextToken value from a previous call to
     *         <a>DescribeUpdateDirectory</a>. Pass null if this is the first call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateDirectoryRequest)) {
            return false;
        }
        DescribeUpdateDirectoryRequest other = (DescribeUpdateDirectoryRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString())
                && Objects.equals(regionName(), other.regionName()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUpdateDirectoryRequest").add("DirectoryId", directoryId())
                .add("UpdateType", updateTypeAsString()).add("RegionName", regionName()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UpdateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateDirectoryRequest, T> g) {
        return obj -> g.apply((DescribeUpdateDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUpdateDirectoryRequest> {
        /**
         * <p>
         * The unique identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The unique identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The type of updates you want to describe for the directory.
         * </p>
         * 
         * @param updateType
         *        The type of updates you want to describe for the directory.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of updates you want to describe for the directory.
         * </p>
         * 
         * @param updateType
         *        The type of updates you want to describe for the directory.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(UpdateType updateType);

        /**
         * <p>
         * The name of the Region.
         * </p>
         * 
         * @param regionName
         *        The name of the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The <code>DescribeUpdateDirectoryResult</code>. NextToken value from a previous call to
         * <a>DescribeUpdateDirectory</a>. Pass null if this is the first call.
         * </p>
         * 
         * @param nextToken
         *        The <code>DescribeUpdateDirectoryResult</code>. NextToken value from a previous call to
         *        <a>DescribeUpdateDirectory</a>. Pass null if this is the first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String updateType;

        private String regionName;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateDirectoryRequest model) {
            super(model);
            directoryId(model.directoryId);
            updateType(model.updateType);
            regionName(model.regionName);
            nextToken(model.nextToken);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUpdateDirectoryRequest build() {
            return new DescribeUpdateDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
