/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectConnectGatewayResponse extends DirectConnectResponse implements
        ToCopyableBuilder<UpdateDirectConnectGatewayResponse.Builder, UpdateDirectConnectGatewayResponse> {
    private static final SdkField<DirectConnectGateway> DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<DirectConnectGateway> builder(MarshallingType.SDK_POJO).memberName("directConnectGateway")
            .getter(getter(UpdateDirectConnectGatewayResponse::directConnectGateway))
            .setter(setter(Builder::directConnectGateway)).constructor(DirectConnectGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGateway").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_FIELD));

    private final DirectConnectGateway directConnectGateway;

    private UpdateDirectConnectGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGateway = builder.directConnectGateway;
    }

    /**
     * <p>
     * Informaiton about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual private
     * gateways or transit gateways.
     * </p>
     * 
     * @return Informaiton about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual
     *         private gateways or transit gateways.
     */
    public final DirectConnectGateway directConnectGateway() {
        return directConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayResponse)) {
            return false;
        }
        UpdateDirectConnectGatewayResponse other = (UpdateDirectConnectGatewayResponse) obj;
        return Objects.equals(directConnectGateway(), other.directConnectGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectConnectGatewayResponse").add("DirectConnectGateway", directConnectGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGateway":
            return Optional.ofNullable(clazz.cast(directConnectGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayResponse, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDirectConnectGatewayResponse> {
        /**
         * <p>
         * Informaiton about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual
         * private gateways or transit gateways.
         * </p>
         * 
         * @param directConnectGateway
         *        Informaiton about a Direct Connect gateway, which enables you to connect virtual interfaces and
         *        virtual private gateways or transit gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGateway(DirectConnectGateway directConnectGateway);

        /**
         * <p>
         * Informaiton about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual
         * private gateways or transit gateways.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectConnectGateway.Builder} avoiding
         * the need to create one manually via {@link DirectConnectGateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectConnectGateway.Builder#build()} is called immediately and
         * its result is passed to {@link #directConnectGateway(DirectConnectGateway)}.
         * 
         * @param directConnectGateway
         *        a consumer that will call methods on {@link DirectConnectGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGateway(DirectConnectGateway)
         */
        default Builder directConnectGateway(Consumer<DirectConnectGateway.Builder> directConnectGateway) {
            return directConnectGateway(DirectConnectGateway.builder().applyMutation(directConnectGateway).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private DirectConnectGateway directConnectGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayResponse model) {
            super(model);
            directConnectGateway(model.directConnectGateway);
        }

        public final DirectConnectGateway.Builder getDirectConnectGateway() {
            return directConnectGateway != null ? directConnectGateway.toBuilder() : null;
        }

        public final void setDirectConnectGateway(DirectConnectGateway.BuilderImpl directConnectGateway) {
            this.directConnectGateway = directConnectGateway != null ? directConnectGateway.build() : null;
        }

        @Override
        public final Builder directConnectGateway(DirectConnectGateway directConnectGateway) {
            this.directConnectGateway = directConnectGateway;
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayResponse build() {
            return new UpdateDirectConnectGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
