/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.CreateLagRequest;
import software.amazon.awssdk.services.directconnect.model.CreateLagResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteLagRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteLagResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse;
import software.amazon.awssdk.services.directconnect.model.DirectConnectClientException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectServerException;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.directconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateLagRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateLagResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse;

/**
 * Service client for accessing AWS Direct Connect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Direct Connect links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable.
 * One end of the cable is connected to your router, the other to an Direct Connect router. With this connection in
 * place, you can create virtual interfaces directly to the Amazon Web Services Cloud (for example, to Amazon EC2 and
 * Amazon S3) and to Amazon VPC, bypassing Internet service providers in your network path. A connection provides access
 * to all Amazon Web Services Regions except the China (Beijing) and (China) Ningxia Regions. Amazon Web Services
 * resources in the China Regions can only be accessed through locations associated with those Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DirectConnectClient extends AwsClient {
    String SERVICE_NAME = "directconnect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "directconnect";

    /**
     * <p>
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     * </p>
     *
     * @param acceptDirectConnectGatewayAssociationProposalRequest
     * @return Result of the AcceptDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AcceptDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptDirectConnectGatewayAssociationProposalResponse acceptDirectConnectGatewayAssociationProposal(
            AcceptDirectConnectGatewayAssociationProposalRequest acceptDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptDirectConnectGatewayAssociationProposalRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptDirectConnectGatewayAssociationProposalRequest#builder()}
     * </p>
     *
     * @param acceptDirectConnectGatewayAssociationProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AcceptDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptDirectConnectGatewayAssociationProposalResponse acceptDirectConnectGatewayAssociationProposal(
            Consumer<AcceptDirectConnectGatewayAssociationProposalRequest.Builder> acceptDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return acceptDirectConnectGatewayAssociationProposal(AcceptDirectConnectGatewayAssociationProposalRequest.builder()
                .applyMutation(acceptDirectConnectGatewayAssociationProposalRequest).build());
    }

    /**
     * <p>
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     * </p>
     * <p>
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the
     * specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the
     * specified capacity and the Direct Connect Partner must also police the hosted connection for the specified
     * capacity.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param allocateHostedConnectionRequest
     * @return Result of the AllocateHostedConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocateHostedConnectionResponse allocateHostedConnection(
            AllocateHostedConnectionRequest allocateHostedConnectionRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     * </p>
     * <p>
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the
     * specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the
     * specified capacity and the Direct Connect Partner must also police the hosted connection for the specified
     * capacity.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateHostedConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AllocateHostedConnectionRequest#builder()}
     * </p>
     *
     * @param allocateHostedConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest.Builder} to
     *        create a request.
     * @return Result of the AllocateHostedConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocateHostedConnectionResponse allocateHostedConnection(
            Consumer<AllocateHostedConnectionRequest.Builder> allocateHostedConnectionRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        return allocateHostedConnection(AllocateHostedConnectionRequest.builder().applyMutation(allocateHostedConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this action must be confirmed by the owner using
     * <a>ConfirmPrivateVirtualInterface</a>. Until then, the virtual interface is in the <code>Confirming</code> state
     * and is not available to handle traffic.
     * </p>
     *
     * @param allocatePrivateVirtualInterfaceRequest
     * @return Result of the AllocatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocatePrivateVirtualInterfaceResponse allocatePrivateVirtualInterface(
            AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this action must be confirmed by the owner using
     * <a>ConfirmPrivateVirtualInterface</a>. Until then, the virtual interface is in the <code>Confirming</code> state
     * and is not available to handle traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocatePrivateVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link AllocatePrivateVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param allocatePrivateVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the AllocatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocatePrivateVirtualInterfaceResponse allocatePrivateVirtualInterface(
            Consumer<AllocatePrivateVirtualInterfaceRequest.Builder> allocatePrivateVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest.builder()
                .applyMutation(allocatePrivateVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the
     * specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this function must be confirmed by the owner using
     * <a>ConfirmPublicVirtualInterface</a>. Until this step has been completed, the virtual interface is in the
     * <code>confirming</code> state and is not available to handle traffic.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are
     * automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     *
     * @param allocatePublicVirtualInterfaceRequest
     * @return Result of the AllocatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocatePublicVirtualInterfaceResponse allocatePublicVirtualInterface(
            AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the
     * specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this function must be confirmed by the owner using
     * <a>ConfirmPublicVirtualInterface</a>. Until this step has been completed, the virtual interface is in the
     * <code>confirming</code> state and is not available to handle traffic.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are
     * automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocatePublicVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link AllocatePublicVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param allocatePublicVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the AllocatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocatePublicVirtualInterfaceResponse allocatePublicVirtualInterface(
            Consumer<AllocatePublicVirtualInterfaceRequest.Builder> allocatePublicVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest.builder()
                .applyMutation(allocatePublicVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of
     * interface to connect a transit gateway to your Direct Connect gateway.
     * </p>
     * <p>
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create a transit virtual interface, it must be confirmed by the owner using
     * <a>ConfirmTransitVirtualInterface</a>. Until this step has been completed, the transit virtual interface is in
     * the <code>requested</code> state and is not available to handle traffic.
     * </p>
     *
     * @param allocateTransitVirtualInterfaceRequest
     * @return Result of the AllocateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocateTransitVirtualInterfaceResponse allocateTransitVirtualInterface(
            AllocateTransitVirtualInterfaceRequest allocateTransitVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of
     * interface to connect a transit gateway to your Direct Connect gateway.
     * </p>
     * <p>
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create a transit virtual interface, it must be confirmed by the owner using
     * <a>ConfirmTransitVirtualInterface</a>. Until this step has been completed, the transit virtual interface is in
     * the <code>requested</code> state and is not available to handle traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateTransitVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link AllocateTransitVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param allocateTransitVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the AllocateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AllocateTransitVirtualInterfaceResponse allocateTransitVirtualInterface(
            Consumer<AllocateTransitVirtualInterfaceRequest.Builder> allocateTransitVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return allocateTransitVirtualInterface(AllocateTransitVirtualInterfaceRequest.builder()
                .applyMutation(allocateTransitVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and
     * re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must
     * be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG.
     * You can re-associate a connection that's currently associated with a different LAG; however, if removing the
     * connection would cause the original LAG to fall below its setting for minimum number of operational connections,
     * the request fails.
     * </p>
     * <p>
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the
     * LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated
     * with the original LAG.
     * </p>
     * <p>
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was
     * originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     * </p>
     *
     * @param associateConnectionWithLagRequest
     * @return Result of the AssociateConnectionWithLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateConnectionWithLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectionWithLagResponse associateConnectionWithLag(
            AssociateConnectionWithLagRequest associateConnectionWithLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and
     * re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must
     * be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG.
     * You can re-associate a connection that's currently associated with a different LAG; however, if removing the
     * connection would cause the original LAG to fall below its setting for minimum number of operational connections,
     * the request fails.
     * </p>
     * <p>
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the
     * LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated
     * with the original LAG.
     * </p>
     * <p>
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was
     * originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateConnectionWithLagRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateConnectionWithLagRequest#builder()}
     * </p>
     *
     * @param associateConnectionWithLagRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateConnectionWithLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateConnectionWithLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateConnectionWithLagResponse associateConnectionWithLag(
            Consumer<AssociateConnectionWithLagRequest.Builder> associateConnectionWithLagRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return associateConnectionWithLag(AssociateConnectionWithLagRequest.builder()
                .applyMutation(associateConnectionWithLagRequest).build());
    }

    /**
     * <p>
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If
     * the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address,
     * the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web
     * Services as it is being migrated.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param associateHostedConnectionRequest
     * @return Result of the AssociateHostedConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateHostedConnectionResponse associateHostedConnection(
            AssociateHostedConnectionRequest associateHostedConnectionRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If
     * the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address,
     * the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web
     * Services as it is being migrated.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHostedConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateHostedConnectionRequest#builder()}
     * </p>
     *
     * @param associateHostedConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateHostedConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateHostedConnectionResponse associateHostedConnection(
            Consumer<AssociateHostedConnectionRequest.Builder> associateHostedConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return associateHostedConnection(AssociateHostedConnectionRequest.builder()
                .applyMutation(associateHostedConnectionRequest).build());
    }

    /**
     * <p>
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an
     * Direct Connect dedicated connection.
     * </p>
     * <p>
     * You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in
     * the request.
     * </p>
     * <p>
     * For information about MAC Security (MACsec) key considerations, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration"
     * >MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param associateMacSecKeyRequest
     * @return Result of the AssociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMacSecKeyResponse associateMacSecKey(AssociateMacSecKeyRequest associateMacSecKeyRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an
     * Direct Connect dedicated connection.
     * </p>
     * <p>
     * You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in
     * the request.
     * </p>
     * <p>
     * For information about MAC Security (MACsec) key considerations, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration"
     * >MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMacSecKeyRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMacSecKeyRequest#builder()}
     * </p>
     *
     * @param associateMacSecKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMacSecKeyResponse associateMacSecKey(Consumer<AssociateMacSecKeyRequest.Builder> associateMacSecKeyRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return associateMacSecKey(AssociateMacSecKeyRequest.builder().applyMutation(associateMacSecKeyRequest).build());
    }

    /**
     * <p>
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to
     * Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target
     * connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address,
     * the operation fails.
     * </p>
     * <p>
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must
     * be migrated along with their virtual interfaces using <a>AssociateHostedConnection</a>.
     * </p>
     * <p>
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual
     * interface itself or the connection to which the virtual interface is currently associated. Additionally, the
     * requester must own the connection or LAG for the association.
     * </p>
     *
     * @param associateVirtualInterfaceRequest
     * @return Result of the AssociateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVirtualInterfaceResponse associateVirtualInterface(
            AssociateVirtualInterfaceRequest associateVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to
     * Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target
     * connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address,
     * the operation fails.
     * </p>
     * <p>
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must
     * be migrated along with their virtual interfaces using <a>AssociateHostedConnection</a>.
     * </p>
     * <p>
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual
     * interface itself or the connection to which the virtual interface is currently associated. Additionally, the
     * requester must own the connection or LAG for the association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVirtualInterfaceRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param associateVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVirtualInterfaceResponse associateVirtualInterface(
            Consumer<AssociateVirtualInterfaceRequest.Builder> associateVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return associateVirtualInterface(AssociateVirtualInterfaceRequest.builder()
                .applyMutation(associateVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Confirms the creation of the specified hosted connection on an interconnect.
     * </p>
     * <p>
     * Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and remains in this state
     * until the owner confirms creation of the hosted connection.
     * </p>
     *
     * @param confirmConnectionRequest
     * @return Result of the ConfirmConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmConnectionResponse confirmConnection(ConfirmConnectionRequest confirmConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms the creation of the specified hosted connection on an interconnect.
     * </p>
     * <p>
     * Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and remains in this state
     * until the owner confirms creation of the hosted connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link ConfirmConnectionRequest#builder()}
     * </p>
     *
     * @param confirmConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the ConfirmConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmConnectionResponse confirmConnection(Consumer<ConfirmConnectionRequest.Builder> confirmConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return confirmConnection(ConfirmConnectionRequest.builder().applyMutation(confirmConnectionRequest).build());
    }

    /**
     * <p>
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     * </p>
     *
     * @param confirmCustomerAgreementRequest
     * @return Result of the ConfirmCustomerAgreement operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmCustomerAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmCustomerAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmCustomerAgreementResponse confirmCustomerAgreement(
            ConfirmCustomerAgreementRequest confirmCustomerAgreementRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmCustomerAgreementRequest.Builder} avoiding
     * the need to create one manually via {@link ConfirmCustomerAgreementRequest#builder()}
     * </p>
     *
     * @param confirmCustomerAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest.Builder} to
     *        create a request.
     * @return Result of the ConfirmCustomerAgreement operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmCustomerAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmCustomerAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmCustomerAgreementResponse confirmCustomerAgreement(
            Consumer<ConfirmCustomerAgreementRequest.Builder> confirmCustomerAgreementRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return confirmCustomerAgreement(ConfirmCustomerAgreementRequest.builder().applyMutation(confirmCustomerAgreementRequest)
                .build());
    }

    /**
     * <p>
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified
     * virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     * </p>
     *
     * @param confirmPrivateVirtualInterfaceRequest
     * @return Result of the ConfirmPrivateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmPrivateVirtualInterfaceResponse confirmPrivateVirtualInterface(
            ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified
     * virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmPrivateVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link ConfirmPrivateVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param confirmPrivateVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the ConfirmPrivateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmPrivateVirtualInterfaceResponse confirmPrivateVirtualInterface(
            Consumer<ConfirmPrivateVirtualInterfaceRequest.Builder> confirmPrivateVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest.builder()
                .applyMutation(confirmPrivateVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available
     * to handle traffic.
     * </p>
     *
     * @param confirmPublicVirtualInterfaceRequest
     * @return Result of the ConfirmPublicVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmPublicVirtualInterfaceResponse confirmPublicVirtualInterface(
            ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available
     * to handle traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmPublicVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link ConfirmPublicVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param confirmPublicVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the ConfirmPublicVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmPublicVirtualInterfaceResponse confirmPublicVirtualInterface(
            Consumer<ConfirmPublicVirtualInterfaceRequest.Builder> confirmPublicVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest.builder()
                .applyMutation(confirmPublicVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the owner of the transit virtual interface makes this call, the specified transit virtual interface is
     * created and made available to handle traffic.
     * </p>
     *
     * @param confirmTransitVirtualInterfaceRequest
     * @return Result of the ConfirmTransitVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmTransitVirtualInterfaceResponse confirmTransitVirtualInterface(
            ConfirmTransitVirtualInterfaceRequest confirmTransitVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the owner of the transit virtual interface makes this call, the specified transit virtual interface is
     * created and made available to handle traffic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmTransitVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link ConfirmTransitVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param confirmTransitVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the ConfirmTransitVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default ConfirmTransitVirtualInterfaceResponse confirmTransitVirtualInterface(
            Consumer<ConfirmTransitVirtualInterfaceRequest.Builder> confirmTransitVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return confirmTransitVirtualInterface(ConfirmTransitVirtualInterfaceRequest.builder()
                .applyMutation(confirmTransitVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Creates a BGP peer on the specified virtual interface.
     * </p>
     * <p>
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web
     * Services resources that also use that address family.
     * </p>
     * <p>
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the
     * same address family as an existing BGP peer on the virtual interface.
     * </p>
     * <p>
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically
     * assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     * <important>
     * <p>
     * If you let Amazon Web Services auto-assign IPv4 addresses, a /30 CIDR will be allocated from 169.254.0.0/16.
     * Amazon Web Services does not recommend this option if you intend to use the customer router peer IP address as
     * the source and destination for traffic. Instead you should use RFC 1918 or other addressing, and specify the
     * address yourself. For more information about RFC 1918 see <a
     * href="https://datatracker.ietf.org/doc/html/rfc1918"> Address Allocation for Private Internets</a>.
     * </p>
     * </important>
     * <p>
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list
     * for the virtual interface.
     * </p>
     *
     * @param createBgpPeerRequest
     * @return Result of the CreateBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBgpPeerResponse createBGPPeer(CreateBgpPeerRequest createBgpPeerRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a BGP peer on the specified virtual interface.
     * </p>
     * <p>
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web
     * Services resources that also use that address family.
     * </p>
     * <p>
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the
     * same address family as an existing BGP peer on the virtual interface.
     * </p>
     * <p>
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically
     * assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     * <important>
     * <p>
     * If you let Amazon Web Services auto-assign IPv4 addresses, a /30 CIDR will be allocated from 169.254.0.0/16.
     * Amazon Web Services does not recommend this option if you intend to use the customer router peer IP address as
     * the source and destination for traffic. Instead you should use RFC 1918 or other addressing, and specify the
     * address yourself. For more information about RFC 1918 see <a
     * href="https://datatracker.ietf.org/doc/html/rfc1918"> Address Allocation for Private Internets</a>.
     * </p>
     * </important>
     * <p>
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list
     * for the virtual interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBgpPeerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBgpPeerRequest#builder()}
     * </p>
     *
     * @param createBgpPeerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBgpPeerResponse createBGPPeer(Consumer<CreateBgpPeerRequest.Builder> createBgpPeerRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return createBGPPeer(CreateBgpPeerRequest.builder().applyMutation(createBgpPeerRequest).build());
    }

    /**
     * <p>
     * Creates a connection between a customer network and a specific Direct Connect location.
     * </p>
     * <p>
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic
     * cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     * </p>
     * <p>
     * To find the locations for your Region, use <a>DescribeLocations</a>.
     * </p>
     * <p>
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection between a customer network and a specific Direct Connect location.
     * </p>
     * <p>
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic
     * cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     * </p>
     * <p>
     * To find the locations for your Region, use <a>DescribeLocations</a>.
     * </p>
     * <p>
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectionResponse createConnection(Consumer<CreateConnectionRequest.Builder> createConnectionRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual
     * interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web
     * Services Region after it is created. The virtual interfaces and virtual private gateways that are connected
     * through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to
     * a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic
     * between them.
     * </p>
     *
     * @param createDirectConnectGatewayRequest
     * @return Result of the CreateDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayResponse createDirectConnectGateway(
            CreateDirectConnectGatewayRequest createDirectConnectGatewayRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual
     * interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web
     * Services Region after it is created. The virtual interfaces and virtual private gateways that are connected
     * through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to
     * a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic
     * between them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectConnectGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDirectConnectGatewayRequest#builder()}
     * </p>
     *
     * @param createDirectConnectGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayResponse createDirectConnectGateway(
            Consumer<CreateDirectConnectGatewayRequest.Builder> createDirectConnectGatewayRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return createDirectConnectGateway(CreateDirectConnectGatewayRequest.builder()
                .applyMutation(createDirectConnectGatewayRequest).build());
    }

    /**
     * <p>
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private
     * gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationRequest
     * @return Result of the CreateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayAssociationResponse createDirectConnectGatewayAssociation(
            CreateDirectConnectGatewayAssociationRequest createDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private
     * gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateDirectConnectGatewayAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateDirectConnectGatewayAssociationRequest#builder()}
     * </p>
     *
     * @param createDirectConnectGatewayAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayAssociationResponse createDirectConnectGatewayAssociation(
            Consumer<CreateDirectConnectGatewayAssociationRequest.Builder> createDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return createDirectConnectGatewayAssociation(CreateDirectConnectGatewayAssociationRequest.builder()
                .applyMutation(createDirectConnectGatewayAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified
     * Direct Connect gateway.
     * </p>
     * <p>
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any
     * Amazon Web Services account.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationProposalRequest
     * @return Result of the CreateDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayAssociationProposalResponse createDirectConnectGatewayAssociationProposal(
            CreateDirectConnectGatewayAssociationProposalRequest createDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified
     * Direct Connect gateway.
     * </p>
     * <p>
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any
     * Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateDirectConnectGatewayAssociationProposalRequest.Builder} avoiding the need to create one manually via
     * {@link CreateDirectConnectGatewayAssociationProposalRequest#builder()}
     * </p>
     *
     * @param createDirectConnectGatewayAssociationProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest.Builder}
     *        to create a request.
     * @return Result of the CreateDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectConnectGatewayAssociationProposalResponse createDirectConnectGatewayAssociationProposal(
            Consumer<CreateDirectConnectGatewayAssociationProposalRequest.Builder> createDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return createDirectConnectGatewayAssociationProposal(CreateDirectConnectGatewayAssociationProposalRequest.builder()
                .applyMutation(createDirectConnectGatewayAssociationProposalRequest).build());
    }

    /**
     * <p>
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     * </p>
     * <p>
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use
     * an interconnect to provide Direct Connect hosted connections to customers through their own network services.
     * Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a
     * standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect
     * router.
     * </p>
     * <p>
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     * </p>
     * <p>
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling
     * <a>AllocateHostedConnection</a>. The end customer can then connect to Amazon Web Services resources by creating a
     * virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param createInterconnectRequest
     * @return Result of the CreateInterconnect operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInterconnectResponse createInterconnect(CreateInterconnectRequest createInterconnectRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     * </p>
     * <p>
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use
     * an interconnect to provide Direct Connect hosted connections to customers through their own network services.
     * Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a
     * standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect
     * router.
     * </p>
     * <p>
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     * </p>
     * <p>
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling
     * <a>AllocateHostedConnection</a>. The end customer can then connect to Amazon Web Services resources by creating a
     * virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInterconnectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInterconnectRequest#builder()}
     * </p>
     *
     * @param createInterconnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInterconnect operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInterconnectResponse createInterconnect(Consumer<CreateInterconnectRequest.Builder> createInterconnectRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return createInterconnect(CreateInterconnectRequest.builder().applyMutation(createInterconnectRequest).build());
    }

    /**
     * <p>
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections
     * between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the
     * Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single
     * interface.
     * </p>
     * <p>
     * All connections in a LAG must use the same bandwidth (either 1Gbps, 10Gbps, 100Gbps, or 400Gbps) and must
     * terminate at the same Direct Connect endpoint.
     * </p>
     * <p>
     * You can have up to 10 dedicated connections per location. Regardless of this limit, if you request more
     * connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created..
     * </p>
     * <p>
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts
     * towards the total number of connections). Doing so interrupts the current physical dedicated connection, and
     * re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which
     * the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are
     * automatically disassociated and re-associated with the LAG. The connection ID does not change.
     * </p>
     * <p>
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is
     * automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces
     * cannot be directly configured.
     * </p>
     *
     * @param createLagRequest
     * @return Result of the CreateLag operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLagResponse createLag(CreateLagRequest createLagRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections
     * between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the
     * Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single
     * interface.
     * </p>
     * <p>
     * All connections in a LAG must use the same bandwidth (either 1Gbps, 10Gbps, 100Gbps, or 400Gbps) and must
     * terminate at the same Direct Connect endpoint.
     * </p>
     * <p>
     * You can have up to 10 dedicated connections per location. Regardless of this limit, if you request more
     * connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created..
     * </p>
     * <p>
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts
     * towards the total number of connections). Doing so interrupts the current physical dedicated connection, and
     * re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which
     * the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are
     * automatically disassociated and re-associated with the LAG. The connection ID does not change.
     * </p>
     * <p>
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is
     * automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces
     * cannot be directly configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLagRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLagRequest#builder()}
     * </p>
     *
     * @param createLagRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateLagRequest.Builder} to create a request.
     * @return Result of the CreateLag operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLagResponse createLag(Consumer<CreateLagRequest.Builder> createLagRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        return createLag(CreateLagRequest.builder().applyMutation(createLagRequest).build());
    }

    /**
     * <p>
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW).
     * Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to
     * multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface
     * to a VGW only provides access to a single VPC within the same Region.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createPrivateVirtualInterfaceRequest
     * @return Result of the CreatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateVirtualInterfaceResponse createPrivateVirtualInterface(
            CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW).
     * Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to
     * multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface
     * to a VGW only provides access to a single VPC within the same Region.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePrivateVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePrivateVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param createPrivateVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the CreatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateVirtualInterfaceResponse createPrivateVirtualInterface(
            Consumer<CreatePrivateVirtualInterfaceRequest.Builder> createPrivateVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest.builder()
                .applyMutation(createPrivateVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the
     * <code>customer</code> and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6
     * addresses are not supported.
     * </p>
     *
     * @param createPublicVirtualInterfaceRequest
     * @return Result of the CreatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublicVirtualInterfaceResponse createPublicVirtualInterface(
            CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the
     * <code>customer</code> and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6
     * addresses are not supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePublicVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param createPublicVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the CreatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublicVirtualInterfaceResponse createPublicVirtualInterface(
            Consumer<CreatePublicVirtualInterfaceRequest.Builder> createPublicVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest.builder()
                .applyMutation(createPublicVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit
     * gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple
     * VPCs attached to a transit gateway to a Direct Connect gateway.
     * </p>
     * <important>
     * <p>
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number
     * (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the
     * default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     * </p>
     * </important>
     * <p>
     * A jumbo MTU value must be either 1500 or 8500. No other values will be accepted. Setting the MTU of a virtual
     * interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated
     * to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces
     * associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call
     * <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo frames, call
     * <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createTransitVirtualInterfaceRequest
     * @return Result of the CreateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitVirtualInterfaceResponse createTransitVirtualInterface(
            CreateTransitVirtualInterfaceRequest createTransitVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit
     * gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple
     * VPCs attached to a transit gateway to a Direct Connect gateway.
     * </p>
     * <important>
     * <p>
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number
     * (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the
     * default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     * </p>
     * </important>
     * <p>
     * A jumbo MTU value must be either 1500 or 8500. No other values will be accepted. Setting the MTU of a virtual
     * interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated
     * to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces
     * associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call
     * <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo frames, call
     * <a>DescribeVirtualInterfaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitVirtualInterfaceRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param createTransitVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitVirtualInterfaceResponse createTransitVirtualInterface(
            Consumer<CreateTransitVirtualInterfaceRequest.Builder> createTransitVirtualInterfaceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return createTransitVirtualInterface(CreateTransitVirtualInterfaceRequest.builder()
                .applyMutation(createTransitVirtualInterfaceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     * </p>
     * <p>
     * You cannot delete the last BGP peer from a virtual interface.
     * </p>
     *
     * @param deleteBgpPeerRequest
     * @return Result of the DeleteBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBgpPeerResponse deleteBGPPeer(DeleteBgpPeerRequest deleteBgpPeerRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     * </p>
     * <p>
     * You cannot delete the last BGP peer from a virtual interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBgpPeerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBgpPeerRequest#builder()}
     * </p>
     *
     * @param deleteBgpPeerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBgpPeerResponse deleteBGPPeer(Consumer<DeleteBgpPeerRequest.Builder> deleteBgpPeerRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteBGPPeer(DeleteBgpPeerRequest.builder().applyMutation(deleteBgpPeerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified connection.
     * </p>
     * <p>
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering
     * with any third parties to connect with the Direct Connect location, you must cancel your service with them
     * separately.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified connection.
     * </p>
     * <p>
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering
     * with any third parties to connect with the Direct Connect location, you must cancel your service with them
     * separately.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to
     * the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect
     * gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayRequest
     * @return Result of the DeleteDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayResponse deleteDirectConnectGateway(
            DeleteDirectConnectGatewayRequest deleteDirectConnectGatewayRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to
     * the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect
     * gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectConnectGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDirectConnectGatewayRequest#builder()}
     * </p>
     *
     * @param deleteDirectConnectGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayResponse deleteDirectConnectGateway(
            Consumer<DeleteDirectConnectGatewayRequest.Builder> deleteDirectConnectGatewayRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteDirectConnectGateway(DeleteDirectConnectGatewayRequest.builder()
                .applyMutation(deleteDirectConnectGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     * </p>
     * <p>
     * We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own
     * virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and
     * <code>directConnectGatewayId</code> to delete an association.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationRequest
     * @return Result of the DeleteDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayAssociationResponse deleteDirectConnectGatewayAssociation(
            DeleteDirectConnectGatewayAssociationRequest deleteDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     * </p>
     * <p>
     * We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own
     * virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and
     * <code>directConnectGatewayId</code> to delete an association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteDirectConnectGatewayAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteDirectConnectGatewayAssociationRequest#builder()}
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayAssociationResponse deleteDirectConnectGatewayAssociation(
            Consumer<DeleteDirectConnectGatewayAssociationRequest.Builder> deleteDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteDirectConnectGatewayAssociation(DeleteDirectConnectGatewayAssociationRequest.builder()
                .applyMutation(deleteDirectConnectGatewayAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway
     * or transit gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationProposalRequest
     * @return Result of the DeleteDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayAssociationProposalResponse deleteDirectConnectGatewayAssociationProposal(
            DeleteDirectConnectGatewayAssociationProposalRequest deleteDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway
     * or transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteDirectConnectGatewayAssociationProposalRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteDirectConnectGatewayAssociationProposalRequest#builder()}
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationProposalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectConnectGatewayAssociationProposalResponse deleteDirectConnectGatewayAssociationProposal(
            Consumer<DeleteDirectConnectGatewayAssociationProposalRequest.Builder> deleteDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteDirectConnectGatewayAssociationProposal(DeleteDirectConnectGatewayAssociationProposalRequest.builder()
                .applyMutation(deleteDirectConnectGatewayAssociationProposalRequest).build());
    }

    /**
     * <p>
     * Deletes the specified interconnect.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param deleteInterconnectRequest
     * @return Result of the DeleteInterconnect operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInterconnectResponse deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified interconnect.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInterconnectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInterconnectRequest#builder()}
     * </p>
     *
     * @param deleteInterconnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInterconnect operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInterconnectResponse deleteInterconnect(Consumer<DeleteInterconnectRequest.Builder> deleteInterconnectRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return deleteInterconnect(DeleteInterconnectRequest.builder().applyMutation(deleteInterconnectRequest).build());
    }

    /**
     * <p>
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces
     * or hosted connections.
     * </p>
     *
     * @param deleteLagRequest
     * @return Result of the DeleteLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLagResponse deleteLag(DeleteLagRequest deleteLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces
     * or hosted connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLagRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLagRequest#builder()}
     * </p>
     *
     * @param deleteLagRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteLagRequest.Builder} to create a request.
     * @return Result of the DeleteLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLagResponse deleteLag(Consumer<DeleteLagRequest.Builder> deleteLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return deleteLag(DeleteLagRequest.builder().applyMutation(deleteLagRequest).build());
    }

    /**
     * <p>
     * Deletes a virtual interface.
     * </p>
     *
     * @param deleteVirtualInterfaceRequest
     * @return Result of the DeleteVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVirtualInterfaceResponse deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a virtual interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVirtualInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVirtualInterfaceRequest#builder()}
     * </p>
     *
     * @param deleteVirtualInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVirtualInterfaceResponse deleteVirtualInterface(
            Consumer<DeleteVirtualInterfaceRequest.Builder> deleteVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return deleteVirtualInterface(DeleteVirtualInterfaceRequest.builder().applyMutation(deleteVirtualInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Displays the specified connection or all connections in this Region.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the specified connection or all connections in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeConnections(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest).build());
    }

    /**
     * <p>
     * Displays the specified connection or all connections in this Region.
     * </p>
     *
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeConnections
     * @see #describeConnections(DescribeConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections() throws DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return describeConnections(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an
     * NNIPartner, NNIPartnerV2, or a nonPartner.
     * </p>
     *
     * @param describeCustomerMetadataRequest
     * @return Result of the DescribeCustomerMetadata operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeCustomerMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeCustomerMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomerMetadataResponse describeCustomerMetadata(
            DescribeCustomerMetadataRequest describeCustomerMetadataRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an
     * NNIPartner, NNIPartnerV2, or a nonPartner.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomerMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeCustomerMetadataRequest#builder()}
     * </p>
     *
     * @param describeCustomerMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCustomerMetadata operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeCustomerMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeCustomerMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomerMetadataResponse describeCustomerMetadata(
            Consumer<DescribeCustomerMetadataRequest.Builder> describeCustomerMetadataRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeCustomerMetadata(DescribeCustomerMetadataRequest.builder().applyMutation(describeCustomerMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway
     * and a Direct Connect gateway.
     * </p>
     *
     * @param describeDirectConnectGatewayAssociationProposalsRequest
     * @return Result of the DescribeDirectConnectGatewayAssociationProposals operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociationProposals
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAssociationProposalsResponse describeDirectConnectGatewayAssociationProposals(
            DescribeDirectConnectGatewayAssociationProposalsRequest describeDirectConnectGatewayAssociationProposalsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway
     * and a Direct Connect gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDirectConnectGatewayAssociationProposalsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeDirectConnectGatewayAssociationProposalsRequest#builder()}
     * </p>
     *
     * @param describeDirectConnectGatewayAssociationProposalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDirectConnectGatewayAssociationProposals operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociationProposals
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAssociationProposalsResponse describeDirectConnectGatewayAssociationProposals(
            Consumer<DescribeDirectConnectGatewayAssociationProposalsRequest.Builder> describeDirectConnectGatewayAssociationProposalsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeDirectConnectGatewayAssociationProposals(DescribeDirectConnectGatewayAssociationProposalsRequest.builder()
                .applyMutation(describeDirectConnectGatewayAssociationProposalsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways.
     * You must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Direct Connect gateway
     * </p>
     * <p>
     * The response contains all virtual private gateways and transit gateways associated with the Direct Connect
     * gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A virtual private gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A transit gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a virtual private gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a transit gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and transit gateway.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDirectConnectGatewayAssociationsRequest
     * @return Result of the DescribeDirectConnectGatewayAssociations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAssociationsResponse describeDirectConnectGatewayAssociations(
            DescribeDirectConnectGatewayAssociationsRequest describeDirectConnectGatewayAssociationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways.
     * You must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Direct Connect gateway
     * </p>
     * <p>
     * The response contains all virtual private gateways and transit gateways associated with the Direct Connect
     * gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A virtual private gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A transit gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a virtual private gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a transit gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and transit gateway.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDirectConnectGatewayAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDirectConnectGatewayAssociationsRequest#builder()}
     * </p>
     *
     * @param describeDirectConnectGatewayAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDirectConnectGatewayAssociations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAssociationsResponse describeDirectConnectGatewayAssociations(
            Consumer<DescribeDirectConnectGatewayAssociationsRequest.Builder> describeDirectConnectGatewayAssociationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeDirectConnectGatewayAssociations(DescribeDirectConnectGatewayAssociationsRequest.builder()
                .applyMutation(describeDirectConnectGatewayAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct
     * Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all
     * virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response
     * contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response
     * contains the attachment between the Direct Connect gateway and the virtual interface.
     * </p>
     *
     * @param describeDirectConnectGatewayAttachmentsRequest
     * @return Result of the DescribeDirectConnectGatewayAttachments operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAttachmentsResponse describeDirectConnectGatewayAttachments(
            DescribeDirectConnectGatewayAttachmentsRequest describeDirectConnectGatewayAttachmentsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct
     * Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all
     * virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response
     * contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response
     * contains the attachment between the Direct Connect gateway and the virtual interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeDirectConnectGatewayAttachmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeDirectConnectGatewayAttachmentsRequest#builder()}
     * </p>
     *
     * @param describeDirectConnectGatewayAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDirectConnectGatewayAttachments operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewayAttachmentsResponse describeDirectConnectGatewayAttachments(
            Consumer<DescribeDirectConnectGatewayAttachmentsRequest.Builder> describeDirectConnectGatewayAttachmentsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeDirectConnectGatewayAttachments(DescribeDirectConnectGatewayAttachmentsRequest.builder()
                .applyMutation(describeDirectConnectGatewayAttachmentsRequest).build());
    }

    /**
     * <p>
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect
     * gateways are not returned.
     * </p>
     *
     * @param describeDirectConnectGatewaysRequest
     * @return Result of the DescribeDirectConnectGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewaysResponse describeDirectConnectGateways(
            DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect
     * gateways are not returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectConnectGatewaysRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDirectConnectGatewaysRequest#builder()}
     * </p>
     *
     * @param describeDirectConnectGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDirectConnectGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewaysResponse describeDirectConnectGateways(
            Consumer<DescribeDirectConnectGatewaysRequest.Builder> describeDirectConnectGatewaysRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest.builder()
                .applyMutation(describeDirectConnectGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect
     * gateways are not returned.
     * </p>
     *
     * @return Result of the DescribeDirectConnectGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGateways
     * @see #describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectConnectGatewaysResponse describeDirectConnectGateways() throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest.builder().build());
    }

    /**
     * <p>
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group
     * (LAG).
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param describeHostedConnectionsRequest
     * @return Result of the DescribeHostedConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeHostedConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHostedConnectionsResponse describeHostedConnections(
            DescribeHostedConnectionsRequest describeHostedConnectionsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group
     * (LAG).
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHostedConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHostedConnectionsRequest#builder()}
     * </p>
     *
     * @param describeHostedConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeHostedConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeHostedConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHostedConnectionsResponse describeHostedConnections(
            Consumer<DescribeHostedConnectionsRequest.Builder> describeHostedConnectionsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeHostedConnections(DescribeHostedConnectionsRequest.builder()
                .applyMutation(describeHostedConnectionsRequest).build());
    }

    /**
     * <p>
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     * </p>
     *
     * @param describeInterconnectsRequest
     * @return Result of the DescribeInterconnects operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeInterconnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInterconnectsResponse describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInterconnectsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeInterconnectsRequest#builder()}
     * </p>
     *
     * @param describeInterconnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeInterconnects operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeInterconnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInterconnectsResponse describeInterconnects(
            Consumer<DescribeInterconnectsRequest.Builder> describeInterconnectsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeInterconnects(DescribeInterconnectsRequest.builder().applyMutation(describeInterconnectsRequest).build());
    }

    /**
     * <p>
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     * </p>
     *
     * @return Result of the DescribeInterconnects operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeInterconnects
     * @see #describeInterconnects(DescribeInterconnectsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInterconnectsResponse describeInterconnects() throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeInterconnects(DescribeInterconnectsRequest.builder().build());
    }

    /**
     * <p>
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     * </p>
     *
     * @param describeLagsRequest
     * @return Result of the DescribeLags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLagsResponse describeLags(DescribeLagsRequest describeLagsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLagsRequest#builder()}
     * </p>
     *
     * @param describeLagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLagsResponse describeLags(Consumer<DescribeLagsRequest.Builder> describeLagsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeLags(DescribeLagsRequest.builder().applyMutation(describeLagsRequest).build());
    }

    /**
     * <p>
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     * </p>
     *
     * @return Result of the DescribeLags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLags
     * @see #describeLags(DescribeLagsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLagsResponse describeLags() throws DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return describeLags(DescribeLagsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     * </p>
     * <p>
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when
     * establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a
     * href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at
     * Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param describeLoaRequest
     * @return Result of the DescribeLoa operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLoa
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLoaResponse describeLoa(DescribeLoaRequest describeLoaRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     * </p>
     * <p>
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when
     * establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a
     * href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at
     * Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoaRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLoaRequest#builder()}
     * </p>
     *
     * @param describeLoaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLoa operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLoa
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLoaResponse describeLoa(Consumer<DescribeLoaRequest.Builder> describeLoaRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeLoa(DescribeLoaRequest.builder().applyMutation(describeLoaRequest).build());
    }

    /**
     * <p>
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be
     * selected when calling <a>CreateConnection</a> or <a>CreateInterconnect</a>.
     * </p>
     *
     * @param describeLocationsRequest
     * @return Result of the DescribeLocations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationsResponse describeLocations(DescribeLocationsRequest describeLocationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be
     * selected when calling <a>CreateConnection</a> or <a>CreateInterconnect</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLocationsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeLocationsRequest#builder()}
     * </p>
     *
     * @param describeLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLocations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationsResponse describeLocations(Consumer<DescribeLocationsRequest.Builder> describeLocationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeLocations(DescribeLocationsRequest.builder().applyMutation(describeLocationsRequest).build());
    }

    /**
     * <p>
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be
     * selected when calling <a>CreateConnection</a> or <a>CreateInterconnect</a>.
     * </p>
     *
     * @return Result of the DescribeLocations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLocations
     * @see #describeLocations(DescribeLocationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLocationsResponse describeLocations() throws DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return describeLocations(DescribeLocationsRequest.builder().build());
    }

    /**
     * <p>
     * Details about the router.
     * </p>
     *
     * @param describeRouterConfigurationRequest
     *        Provides the details about a virtual interface's router.
     * @return Result of the DescribeRouterConfiguration operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeRouterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeRouterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRouterConfigurationResponse describeRouterConfiguration(
            DescribeRouterConfigurationRequest describeRouterConfigurationRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Details about the router.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRouterConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRouterConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRouterConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest.Builder} to
     *        create a request. Provides the details about a virtual interface's router.
     * @return Result of the DescribeRouterConfiguration operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeRouterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeRouterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRouterConfigurationResponse describeRouterConfiguration(
            Consumer<DescribeRouterConfigurationRequest.Builder> describeRouterConfigurationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeRouterConfiguration(DescribeRouterConfigurationRequest.builder()
                .applyMutation(describeRouterConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the tags associated with the specified Direct Connect resources.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the tags associated with the specified Direct Connect resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <note>
     * <p>
     * Deprecated. Use <code>DescribeVpnGateways</code> instead. See <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html"
     * >DescribeVPNGateways</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     * </p>
     * <p>
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     * </p>
     *
     * @param describeVirtualGatewaysRequest
     * @return Result of the DescribeVirtualGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualGatewaysResponse describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Deprecated. Use <code>DescribeVpnGateways</code> instead. See <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html"
     * >DescribeVPNGateways</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     * </p>
     * <p>
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualGatewaysRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeVirtualGatewaysRequest#builder()}
     * </p>
     *
     * @param describeVirtualGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeVirtualGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualGatewaysResponse describeVirtualGateways(
            Consumer<DescribeVirtualGatewaysRequest.Builder> describeVirtualGatewaysRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeVirtualGateways(DescribeVirtualGatewaysRequest.builder().applyMutation(describeVirtualGatewaysRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * Deprecated. Use <code>DescribeVpnGateways</code> instead. See <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html"
     * >DescribeVPNGateways</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     * </p>
     * <p>
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     * </p>
     *
     * @return Result of the DescribeVirtualGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualGateways
     * @see #describeVirtualGateways(DescribeVirtualGatewaysRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualGatewaysResponse describeVirtualGateways() throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeVirtualGateways(DescribeVirtualGatewaysRequest.builder().build());
    }

    /**
     * <p>
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15
     * minutes before you make the request are also returned. If you specify a connection ID, only the virtual
     * interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single
     * virtual interface is returned.
     * </p>
     * <p>
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     * </p>
     *
     * @param describeVirtualInterfacesRequest
     * @return Result of the DescribeVirtualInterfaces operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualInterfacesResponse describeVirtualInterfaces(
            DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15
     * minutes before you make the request are also returned. If you specify a connection ID, only the virtual
     * interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single
     * virtual interface is returned.
     * </p>
     * <p>
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVirtualInterfacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeVirtualInterfacesRequest#builder()}
     * </p>
     *
     * @param describeVirtualInterfacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeVirtualInterfaces operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualInterfacesResponse describeVirtualInterfaces(
            Consumer<DescribeVirtualInterfacesRequest.Builder> describeVirtualInterfacesRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return describeVirtualInterfaces(DescribeVirtualInterfacesRequest.builder()
                .applyMutation(describeVirtualInterfacesRequest).build());
    }

    /**
     * <p>
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15
     * minutes before you make the request are also returned. If you specify a connection ID, only the virtual
     * interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single
     * virtual interface is returned.
     * </p>
     * <p>
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     * </p>
     *
     * @return Result of the DescribeVirtualInterfaces operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualInterfaces
     * @see #describeVirtualInterfaces(DescribeVirtualInterfacesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeVirtualInterfacesResponse describeVirtualInterfaces() throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return describeVirtualInterfaces(DescribeVirtualInterfacesRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established
     * as a standalone connection (the connection is not deleted; to delete the connection, use the
     * <a>DeleteConnection</a> request). If the LAG has associated virtual interfaces or hosted connections, they remain
     * associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted
     * to an interconnect.
     * </p>
     * <p>
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational
     * connections, the request fails, except when it's the last member of the LAG. If all connections are
     * disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     * </p>
     *
     * @param disassociateConnectionFromLagRequest
     * @return Result of the DisassociateConnectionFromLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateConnectionFromLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectionFromLagResponse disassociateConnectionFromLag(
            DisassociateConnectionFromLagRequest disassociateConnectionFromLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established
     * as a standalone connection (the connection is not deleted; to delete the connection, use the
     * <a>DeleteConnection</a> request). If the LAG has associated virtual interfaces or hosted connections, they remain
     * associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted
     * to an interconnect.
     * </p>
     * <p>
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational
     * connections, the request fails, except when it's the last member of the LAG. If all connections are
     * disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectionFromLagRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateConnectionFromLagRequest#builder()}
     * </p>
     *
     * @param disassociateConnectionFromLagRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateConnectionFromLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateConnectionFromLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateConnectionFromLagResponse disassociateConnectionFromLag(
            Consumer<DisassociateConnectionFromLagRequest.Builder> disassociateConnectionFromLagRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return disassociateConnectionFromLag(DisassociateConnectionFromLagRequest.builder()
                .applyMutation(disassociateConnectionFromLagRequest).build());
    }

    /**
     * <p>
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     * </p>
     *
     * @param disassociateMacSecKeyRequest
     * @return Result of the DisassociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMacSecKeyResponse disassociateMacSecKey(DisassociateMacSecKeyRequest disassociateMacSecKeyRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMacSecKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMacSecKeyRequest#builder()}
     * </p>
     *
     * @param disassociateMacSecKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMacSecKeyResponse disassociateMacSecKey(
            Consumer<DisassociateMacSecKeyRequest.Builder> disassociateMacSecKeyRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return disassociateMacSecKey(DisassociateMacSecKeyRequest.builder().applyMutation(disassociateMacSecKeyRequest).build());
    }

    /**
     * <p>
     * Lists the virtual interface failover test history.
     * </p>
     *
     * @param listVirtualInterfaceTestHistoryRequest
     * @return Result of the ListVirtualInterfaceTestHistory operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ListVirtualInterfaceTestHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ListVirtualInterfaceTestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualInterfaceTestHistoryResponse listVirtualInterfaceTestHistory(
            ListVirtualInterfaceTestHistoryRequest listVirtualInterfaceTestHistoryRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the virtual interface failover test history.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualInterfaceTestHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListVirtualInterfaceTestHistoryRequest#builder()}
     * </p>
     *
     * @param listVirtualInterfaceTestHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest.Builder}
     *        to create a request.
     * @return Result of the ListVirtualInterfaceTestHistory operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ListVirtualInterfaceTestHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ListVirtualInterfaceTestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualInterfaceTestHistoryResponse listVirtualInterfaceTestHistory(
            Consumer<ListVirtualInterfaceTestHistoryRequest.Builder> listVirtualInterfaceTestHistoryRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return listVirtualInterfaceTestHistory(ListVirtualInterfaceTestHistoryRequest.builder()
                .applyMutation(listVirtualInterfaceTestHistoryRequest).build());
    }

    /**
     * <p>
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by
     * placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     * </p>
     * <p>
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     * </p>
     * <p>
     * You can use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html"
     * >ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.
     * </p>
     * <p>
     * If you need to stop the test before the test interval completes, use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html"
     * >StopBgpFailoverTest</a>.
     * </p>
     *
     * @param startBgpFailoverTestRequest
     * @return Result of the StartBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StartBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StartBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBgpFailoverTestResponse startBgpFailoverTest(StartBgpFailoverTestRequest startBgpFailoverTestRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by
     * placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     * </p>
     * <p>
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     * </p>
     * <p>
     * You can use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html"
     * >ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.
     * </p>
     * <p>
     * If you need to stop the test before the test interval completes, use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html"
     * >StopBgpFailoverTest</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBgpFailoverTestRequest.Builder} avoiding the
     * need to create one manually via {@link StartBgpFailoverTestRequest#builder()}
     * </p>
     *
     * @param startBgpFailoverTestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest.Builder} to create
     *        a request.
     * @return Result of the StartBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StartBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StartBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StartBgpFailoverTestResponse startBgpFailoverTest(
            Consumer<StartBgpFailoverTestRequest.Builder> startBgpFailoverTestRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return startBgpFailoverTest(StartBgpFailoverTestRequest.builder().applyMutation(startBgpFailoverTestRequest).build());
    }

    /**
     * <p>
     * Stops the virtual interface failover test.
     * </p>
     *
     * @param stopBgpFailoverTestRequest
     * @return Result of the StopBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StopBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StopBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBgpFailoverTestResponse stopBgpFailoverTest(StopBgpFailoverTestRequest stopBgpFailoverTestRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the virtual interface failover test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBgpFailoverTestRequest.Builder} avoiding the
     * need to create one manually via {@link StopBgpFailoverTestRequest#builder()}
     * </p>
     *
     * @param stopBgpFailoverTestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest.Builder} to create a
     *        request.
     * @return Result of the StopBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StopBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StopBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    default StopBgpFailoverTestResponse stopBgpFailoverTest(
            Consumer<StopBgpFailoverTestRequest.Builder> stopBgpFailoverTestRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return stopBgpFailoverTest(StopBgpFailoverTestRequest.builder().applyMutation(stopBgpFailoverTestRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Direct Connect resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Direct Connect resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the Direct Connect dedicated connection configuration.
     * </p>
     * <p>
     * You can update the following parameters for a connection:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The connection name
     * </p>
     * </li>
     * <li>
     * <p>
     * The connection's MAC Security (MACsec) encryption mode.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConnectionRequest
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Direct Connect dedicated connection configuration.
     * </p>
     * <p>
     * You can update the following parameters for a connection:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The connection name
     * </p>
     * </li>
     * <li>
     * <p>
     * The connection's MAC Security (MACsec) encryption mode.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectionRequest#builder()}
     * </p>
     *
     * @param updateConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(Consumer<UpdateConnectionRequest.Builder> updateConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return updateConnection(UpdateConnectionRequest.builder().applyMutation(updateConnectionRequest).build());
    }

    /**
     * <p>
     * Updates the name of a current Direct Connect gateway.
     * </p>
     *
     * @param updateDirectConnectGatewayRequest
     * @return Result of the UpdateDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectConnectGatewayResponse updateDirectConnectGateway(
            UpdateDirectConnectGatewayRequest updateDirectConnectGatewayRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of a current Direct Connect gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDirectConnectGatewayRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDirectConnectGatewayRequest#builder()}
     * </p>
     *
     * @param updateDirectConnectGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectConnectGatewayResponse updateDirectConnectGateway(
            Consumer<UpdateDirectConnectGatewayRequest.Builder> updateDirectConnectGatewayRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return updateDirectConnectGateway(UpdateDirectConnectGatewayRequest.builder()
                .applyMutation(updateDirectConnectGatewayRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the Direct Connect gateway association.
     * </p>
     * <p>
     * Add or remove prefixes from the association.
     * </p>
     *
     * @param updateDirectConnectGatewayAssociationRequest
     * @return Result of the UpdateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectConnectGatewayAssociationResponse updateDirectConnectGatewayAssociation(
            UpdateDirectConnectGatewayAssociationRequest updateDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the Direct Connect gateway association.
     * </p>
     * <p>
     * Add or remove prefixes from the association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateDirectConnectGatewayAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateDirectConnectGatewayAssociationRequest#builder()}
     * </p>
     *
     * @param updateDirectConnectGatewayAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectConnectGatewayAssociationResponse updateDirectConnectGatewayAssociation(
            Consumer<UpdateDirectConnectGatewayAssociationRequest.Builder> updateDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return updateDirectConnectGatewayAssociation(UpdateDirectConnectGatewayAssociationRequest.builder()
                .applyMutation(updateDirectConnectGatewayAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of the specified link aggregation group (LAG).
     * </p>
     * <p>
     * You can update the following LAG attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * </p>
     * </li>
     * <li>
     * <p>
     * The LAG's MACsec encryption mode.
     * </p>
     * <p>
     * Amazon Web Services assigns this value to each connection which is part of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The tags
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value
     * does not cause the LAG to fall below the threshold and become non-operational.
     * </p>
     * </note>
     *
     * @param updateLagRequest
     * @return Result of the UpdateLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLagResponse updateLag(UpdateLagRequest updateLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of the specified link aggregation group (LAG).
     * </p>
     * <p>
     * You can update the following LAG attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * </p>
     * </li>
     * <li>
     * <p>
     * The LAG's MACsec encryption mode.
     * </p>
     * <p>
     * Amazon Web Services assigns this value to each connection which is part of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The tags
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value
     * does not cause the LAG to fall below the threshold and become non-operational.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLagRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLagRequest#builder()}
     * </p>
     *
     * @param updateLagRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UpdateLagRequest.Builder} to create a request.
     * @return Result of the UpdateLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLagResponse updateLag(Consumer<UpdateLagRequest.Builder> updateLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        return updateLag(UpdateLagRequest.builder().applyMutation(updateLagRequest).build());
    }

    /**
     * <p>
     * Updates the specified attributes of the specified virtual private interface.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param updateVirtualInterfaceAttributesRequest
     * @return Result of the UpdateVirtualInterfaceAttributes operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateVirtualInterfaceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVirtualInterfaceAttributesResponse updateVirtualInterfaceAttributes(
            UpdateVirtualInterfaceAttributesRequest updateVirtualInterfaceAttributesRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified attributes of the specified virtual private interface.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVirtualInterfaceAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateVirtualInterfaceAttributesRequest#builder()}
     * </p>
     *
     * @param updateVirtualInterfaceAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateVirtualInterfaceAttributes operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateVirtualInterfaceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVirtualInterfaceAttributesResponse updateVirtualInterfaceAttributes(
            Consumer<UpdateVirtualInterfaceAttributesRequest.Builder> updateVirtualInterfaceAttributesRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        return updateVirtualInterfaceAttributes(UpdateVirtualInterfaceAttributesRequest.builder()
                .applyMutation(updateVirtualInterfaceAttributesRequest).build());
    }

    /**
     * Create a {@link DirectConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DirectConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DirectConnectClient}.
     */
    static DirectConnectClientBuilder builder() {
        return new DefaultDirectConnectClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DirectConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
