/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the S3 bucket where you're hosting the manifest that you want DataSync to use. For more information and
 * configuration examples, see <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync
 * transfers by using a manifest</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ManifestConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ManifestConfig.Builder, S3ManifestConfig> {
    private static final SdkField<String> MANIFEST_OBJECT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestObjectPath").getter(getter(S3ManifestConfig::manifestObjectPath))
            .setter(setter(Builder::manifestObjectPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestObjectPath").build())
            .build();

    private static final SdkField<String> BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketAccessRoleArn").getter(getter(S3ManifestConfig::bucketAccessRoleArn))
            .setter(setter(Builder::bucketAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccessRoleArn").build())
            .build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketArn").getter(getter(S3ManifestConfig::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()).build();

    private static final SdkField<String> MANIFEST_OBJECT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestObjectVersionId").getter(getter(S3ManifestConfig::manifestObjectVersionId))
            .setter(setter(Builder::manifestObjectVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestObjectVersionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_OBJECT_PATH_FIELD,
            BUCKET_ACCESS_ROLE_ARN_FIELD, S3_BUCKET_ARN_FIELD, MANIFEST_OBJECT_VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String manifestObjectPath;

    private final String bucketAccessRoleArn;

    private final String s3BucketArn;

    private final String manifestObjectVersionId;

    private S3ManifestConfig(BuilderImpl builder) {
        this.manifestObjectPath = builder.manifestObjectPath;
        this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.manifestObjectVersionId = builder.manifestObjectVersionId;
    }

    /**
     * <p>
     * Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example,
     * <code>prefix/my-manifest.csv</code>).
     * </p>
     * 
     * @return Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example,
     *         <code>prefix/my-manifest.csv</code>).
     */
    public final String manifestObjectPath() {
        return manifestObjectPath;
    }

    /**
     * <p>
     * Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
     * >Providing DataSync access to your manifest</a>.
     * </p>
     * 
     * @return Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
     *         >Providing DataSync access to your manifest</a>.
     */
    public final String bucketAccessRoleArn() {
        return bucketAccessRoleArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this, DataSync
     * uses the latest version of the object.
     * </p>
     * 
     * @return Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this,
     *         DataSync uses the latest version of the object.
     */
    public final String manifestObjectVersionId() {
        return manifestObjectVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestObjectPath());
        hashCode = 31 * hashCode + Objects.hashCode(bucketAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(manifestObjectVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ManifestConfig)) {
            return false;
        }
        S3ManifestConfig other = (S3ManifestConfig) obj;
        return Objects.equals(manifestObjectPath(), other.manifestObjectPath())
                && Objects.equals(bucketAccessRoleArn(), other.bucketAccessRoleArn())
                && Objects.equals(s3BucketArn(), other.s3BucketArn())
                && Objects.equals(manifestObjectVersionId(), other.manifestObjectVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ManifestConfig").add("ManifestObjectPath", manifestObjectPath())
                .add("BucketAccessRoleArn", bucketAccessRoleArn()).add("S3BucketArn", s3BucketArn())
                .add("ManifestObjectVersionId", manifestObjectVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestObjectPath":
            return Optional.ofNullable(clazz.cast(manifestObjectPath()));
        case "BucketAccessRoleArn":
            return Optional.ofNullable(clazz.cast(bucketAccessRoleArn()));
        case "S3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "ManifestObjectVersionId":
            return Optional.ofNullable(clazz.cast(manifestObjectVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ManifestConfig, T> g) {
        return obj -> g.apply((S3ManifestConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ManifestConfig> {
        /**
         * <p>
         * Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example,
         * <code>prefix/my-manifest.csv</code>).
         * </p>
         * 
         * @param manifestObjectPath
         *        Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example,
         *        <code>prefix/my-manifest.csv</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestObjectPath(String manifestObjectPath);

        /**
         * <p>
         * Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
         * >Providing DataSync access to your manifest</a>.
         * </p>
         * 
         * @param bucketAccessRoleArn
         *        Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access"
         *        >Providing DataSync access to your manifest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketAccessRoleArn(String bucketAccessRoleArn);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
         * </p>
         * 
         * @param s3BucketArn
         *        Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this,
         * DataSync uses the latest version of the object.
         * </p>
         * 
         * @param manifestObjectVersionId
         *        Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this,
         *        DataSync uses the latest version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestObjectVersionId(String manifestObjectVersionId);
    }

    static final class BuilderImpl implements Builder {
        private String manifestObjectPath;

        private String bucketAccessRoleArn;

        private String s3BucketArn;

        private String manifestObjectVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ManifestConfig model) {
            manifestObjectPath(model.manifestObjectPath);
            bucketAccessRoleArn(model.bucketAccessRoleArn);
            s3BucketArn(model.s3BucketArn);
            manifestObjectVersionId(model.manifestObjectVersionId);
        }

        public final String getManifestObjectPath() {
            return manifestObjectPath;
        }

        public final void setManifestObjectPath(String manifestObjectPath) {
            this.manifestObjectPath = manifestObjectPath;
        }

        @Override
        public final Builder manifestObjectPath(String manifestObjectPath) {
            this.manifestObjectPath = manifestObjectPath;
            return this;
        }

        public final String getBucketAccessRoleArn() {
            return bucketAccessRoleArn;
        }

        public final void setBucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
        }

        @Override
        public final Builder bucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getManifestObjectVersionId() {
            return manifestObjectVersionId;
        }

        public final void setManifestObjectVersionId(String manifestObjectVersionId) {
            this.manifestObjectVersionId = manifestObjectVersionId;
        }

        @Override
        public final Builder manifestObjectVersionId(String manifestObjectVersionId) {
            this.manifestObjectVersionId = manifestObjectVersionId;
            return this;
        }

        @Override
        public S3ManifestConfig build() {
            return new S3ManifestConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
