/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactAttributesRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactAttributesRequest.Builder, UpdateContactAttributesRequest> {
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(UpdateContactAttributesRequest::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateContactAttributesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(UpdateContactAttributesRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CONTACT_ID_FIELD,
            INSTANCE_ID_FIELD, ATTRIBUTES_FIELD));

    private final String initialContactId;

    private final String instanceId;

    private final Map<String, String> attributes;

    private UpdateContactAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.initialContactId = builder.initialContactId;
        this.instanceId = builder.instanceId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The identifier of the contact. This is the identifier of the contact associated with the first interaction with
     * the contact center.
     * </p>
     * 
     * @return The identifier of the contact. This is the identifier of the contact associated with the first
     *         interaction with the contact center.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon Connect attributes. These attributes can be accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * When the attributes for a contact exceed 32 KB, the contact is routed down the Error branch of the flow. As a
     * mitigation, consider the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Remove unnecessary attributes by setting their values to empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the attributes are only used in one flow and don't need to be referred to outside of that flow (for example,
     * by a Lambda or another flow), then use flow attributes. This way you aren't needlessly persisting the 32 KB of
     * information from one flow to another. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-contact-attributes.html">Flow block: Set contact
     * attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The Amazon Connect attributes. These attributes can be accessed in flows just like any other contact
     *         attributes.</p>
     *         <p>
     *         You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     *         </p>
     *         <p>
     *         When the attributes for a contact exceed 32 KB, the contact is routed down the Error branch of the flow.
     *         As a mitigation, consider the following options:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Remove unnecessary attributes by setting their values to empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the attributes are only used in one flow and don't need to be referred to outside of that flow (for
     *         example, by a Lambda or another flow), then use flow attributes. This way you aren't needlessly
     *         persisting the 32 KB of information from one flow to another. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/set-contact-attributes.html">Flow block: Set
     *         contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
     *         </p>
     *         </li>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactAttributesRequest)) {
            return false;
        }
        UpdateContactAttributesRequest other = (UpdateContactAttributesRequest) obj;
        return Objects.equals(initialContactId(), other.initialContactId()) && Objects.equals(instanceId(), other.instanceId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactAttributesRequest").add("InitialContactId", initialContactId())
                .add("InstanceId", instanceId()).add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactAttributesRequest, T> g) {
        return obj -> g.apply((UpdateContactAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactAttributesRequest> {
        /**
         * <p>
         * The identifier of the contact. This is the identifier of the contact associated with the first interaction
         * with the contact center.
         * </p>
         * 
         * @param initialContactId
         *        The identifier of the contact. This is the identifier of the contact associated with the first
         *        interaction with the contact center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Amazon Connect attributes. These attributes can be accessed in flows just like any other contact
         * attributes.
         * </p>
         * <p>
         * You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * <p>
         * When the attributes for a contact exceed 32 KB, the contact is routed down the Error branch of the flow. As a
         * mitigation, consider the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Remove unnecessary attributes by setting their values to empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the attributes are only used in one flow and don't need to be referred to outside of that flow (for
         * example, by a Lambda or another flow), then use flow attributes. This way you aren't needlessly persisting
         * the 32 KB of information from one flow to another. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-contact-attributes.html">Flow block: Set
         * contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        The Amazon Connect attributes. These attributes can be accessed in flows just like any other contact
         *        attributes.</p>
         *        <p>
         *        You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include
         *        only alphanumeric, dash, and underscore characters.
         *        </p>
         *        <p>
         *        When the attributes for a contact exceed 32 KB, the contact is routed down the Error branch of the
         *        flow. As a mitigation, consider the following options:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Remove unnecessary attributes by setting their values to empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the attributes are only used in one flow and don't need to be referred to outside of that flow (for
         *        example, by a Lambda or another flow), then use flow attributes. This way you aren't needlessly
         *        persisting the 32 KB of information from one flow to another. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/set-contact-attributes.html">Flow block:
         *        Set contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String initialContactId;

        private String instanceId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactAttributesRequest model) {
            super(model);
            initialContactId(model.initialContactId);
            instanceId(model.instanceId);
            attributes(model.attributes);
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactAttributesRequest build() {
            return new UpdateContactAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
