/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object describing redaction applied to the segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisTranscriptItemRedaction implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisTranscriptItemRedaction.Builder, RealTimeContactAnalysisTranscriptItemRedaction> {
    private static final SdkField<List<RealTimeContactAnalysisCharacterInterval>> CHARACTER_OFFSETS_FIELD = SdkField
            .<List<RealTimeContactAnalysisCharacterInterval>> builder(MarshallingType.LIST)
            .memberName("CharacterOffsets")
            .getter(getter(RealTimeContactAnalysisTranscriptItemRedaction::characterOffsets))
            .setter(setter(Builder::characterOffsets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterOffsets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeContactAnalysisCharacterInterval> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeContactAnalysisCharacterInterval::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARACTER_OFFSETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RealTimeContactAnalysisCharacterInterval> characterOffsets;

    private RealTimeContactAnalysisTranscriptItemRedaction(BuilderImpl builder) {
        this.characterOffsets = builder.characterOffsets;
    }

    /**
     * For responses, this returns true if the service returned a value for the CharacterOffsets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCharacterOffsets() {
        return characterOffsets != null && !(characterOffsets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of character intervals each describing a part of the text that was redacted. For <code>OutputType.Raw</code>
     * , part of the original text that contains data that can be redacted. For <code> OutputType.Redacted</code>, part
     * of the string with redaction tag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCharacterOffsets} method.
     * </p>
     * 
     * @return List of character intervals each describing a part of the text that was redacted. For
     *         <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
     *         <code> OutputType.Redacted</code>, part of the string with redaction tag.
     */
    public final List<RealTimeContactAnalysisCharacterInterval> characterOffsets() {
        return characterOffsets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCharacterOffsets() ? characterOffsets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisTranscriptItemRedaction)) {
            return false;
        }
        RealTimeContactAnalysisTranscriptItemRedaction other = (RealTimeContactAnalysisTranscriptItemRedaction) obj;
        return hasCharacterOffsets() == other.hasCharacterOffsets()
                && Objects.equals(characterOffsets(), other.characterOffsets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisTranscriptItemRedaction")
                .add("CharacterOffsets", hasCharacterOffsets() ? characterOffsets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CharacterOffsets":
            return Optional.ofNullable(clazz.cast(characterOffsets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisTranscriptItemRedaction, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisTranscriptItemRedaction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisTranscriptItemRedaction> {
        /**
         * <p>
         * List of character intervals each describing a part of the text that was redacted. For
         * <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
         * <code> OutputType.Redacted</code>, part of the string with redaction tag.
         * </p>
         * 
         * @param characterOffsets
         *        List of character intervals each describing a part of the text that was redacted. For
         *        <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
         *        <code> OutputType.Redacted</code>, part of the string with redaction tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterOffsets(Collection<RealTimeContactAnalysisCharacterInterval> characterOffsets);

        /**
         * <p>
         * List of character intervals each describing a part of the text that was redacted. For
         * <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
         * <code> OutputType.Redacted</code>, part of the string with redaction tag.
         * </p>
         * 
         * @param characterOffsets
         *        List of character intervals each describing a part of the text that was redacted. For
         *        <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
         *        <code> OutputType.Redacted</code>, part of the string with redaction tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterOffsets(RealTimeContactAnalysisCharacterInterval... characterOffsets);

        /**
         * <p>
         * List of character intervals each describing a part of the text that was redacted. For
         * <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For
         * <code> OutputType.Redacted</code>, part of the string with redaction tag.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisCharacterInterval.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisCharacterInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisCharacterInterval.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #characterOffsets(List<RealTimeContactAnalysisCharacterInterval>)}.
         * 
         * @param characterOffsets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisCharacterInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #characterOffsets(java.util.Collection<RealTimeContactAnalysisCharacterInterval>)
         */
        Builder characterOffsets(Consumer<RealTimeContactAnalysisCharacterInterval.Builder>... characterOffsets);
    }

    static final class BuilderImpl implements Builder {
        private List<RealTimeContactAnalysisCharacterInterval> characterOffsets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisTranscriptItemRedaction model) {
            characterOffsets(model.characterOffsets);
        }

        public final List<RealTimeContactAnalysisCharacterInterval.Builder> getCharacterOffsets() {
            List<RealTimeContactAnalysisCharacterInterval.Builder> result = RealTimeContactAnalysisCharacterIntervalsCopier
                    .copyToBuilder(this.characterOffsets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCharacterOffsets(Collection<RealTimeContactAnalysisCharacterInterval.BuilderImpl> characterOffsets) {
            this.characterOffsets = RealTimeContactAnalysisCharacterIntervalsCopier.copyFromBuilder(characterOffsets);
        }

        @Override
        public final Builder characterOffsets(Collection<RealTimeContactAnalysisCharacterInterval> characterOffsets) {
            this.characterOffsets = RealTimeContactAnalysisCharacterIntervalsCopier.copy(characterOffsets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder characterOffsets(RealTimeContactAnalysisCharacterInterval... characterOffsets) {
            characterOffsets(Arrays.asList(characterOffsets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder characterOffsets(Consumer<RealTimeContactAnalysisCharacterInterval.Builder>... characterOffsets) {
            characterOffsets(Stream.of(characterOffsets)
                    .map(c -> RealTimeContactAnalysisCharacterInterval.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RealTimeContactAnalysisTranscriptItemRedaction build() {
            return new RealTimeContactAnalysisTranscriptItemRedaction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
