/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Potential issues that are detected based on an artificial intelligence analysis of each turn in the conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisIssueDetected implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisIssueDetected.Builder, RealTimeContactAnalysisIssueDetected> {
    private static final SdkField<List<RealTimeContactAnalysisTranscriptItemWithContent>> TRANSCRIPT_ITEMS_FIELD = SdkField
            .<List<RealTimeContactAnalysisTranscriptItemWithContent>> builder(MarshallingType.LIST)
            .memberName("TranscriptItems")
            .getter(getter(RealTimeContactAnalysisIssueDetected::transcriptItems))
            .setter(setter(Builder::transcriptItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeContactAnalysisTranscriptItemWithContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeContactAnalysisTranscriptItemWithContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems;

    private RealTimeContactAnalysisIssueDetected(BuilderImpl builder) {
        this.transcriptItems = builder.transcriptItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the TranscriptItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTranscriptItems() {
        return transcriptItems != null && !(transcriptItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the transcript items (segments) that are associated with a given issue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTranscriptItems} method.
     * </p>
     * 
     * @return List of the transcript items (segments) that are associated with a given issue.
     */
    public final List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems() {
        return transcriptItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTranscriptItems() ? transcriptItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisIssueDetected)) {
            return false;
        }
        RealTimeContactAnalysisIssueDetected other = (RealTimeContactAnalysisIssueDetected) obj;
        return hasTranscriptItems() == other.hasTranscriptItems() && Objects.equals(transcriptItems(), other.transcriptItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisIssueDetected")
                .add("TranscriptItems", hasTranscriptItems() ? transcriptItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptItems":
            return Optional.ofNullable(clazz.cast(transcriptItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisIssueDetected, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisIssueDetected) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisIssueDetected> {
        /**
         * <p>
         * List of the transcript items (segments) that are associated with a given issue.
         * </p>
         * 
         * @param transcriptItems
         *        List of the transcript items (segments) that are associated with a given issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptItems(Collection<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems);

        /**
         * <p>
         * List of the transcript items (segments) that are associated with a given issue.
         * </p>
         * 
         * @param transcriptItems
         *        List of the transcript items (segments) that are associated with a given issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptItems(RealTimeContactAnalysisTranscriptItemWithContent... transcriptItems);

        /**
         * <p>
         * List of the transcript items (segments) that are associated with a given issue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemWithContent.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemWithContent#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemWithContent.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #transcriptItems(List<RealTimeContactAnalysisTranscriptItemWithContent>)}.
         * 
         * @param transcriptItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemWithContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptItems(java.util.Collection<RealTimeContactAnalysisTranscriptItemWithContent>)
         */
        Builder transcriptItems(Consumer<RealTimeContactAnalysisTranscriptItemWithContent.Builder>... transcriptItems);
    }

    static final class BuilderImpl implements Builder {
        private List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisIssueDetected model) {
            transcriptItems(model.transcriptItems);
        }

        public final List<RealTimeContactAnalysisTranscriptItemWithContent.Builder> getTranscriptItems() {
            List<RealTimeContactAnalysisTranscriptItemWithContent.Builder> result = RealTimeContactAnalysisTranscriptItemsWithContentCopier
                    .copyToBuilder(this.transcriptItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTranscriptItems(
                Collection<RealTimeContactAnalysisTranscriptItemWithContent.BuilderImpl> transcriptItems) {
            this.transcriptItems = RealTimeContactAnalysisTranscriptItemsWithContentCopier.copyFromBuilder(transcriptItems);
        }

        @Override
        public final Builder transcriptItems(Collection<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems) {
            this.transcriptItems = RealTimeContactAnalysisTranscriptItemsWithContentCopier.copy(transcriptItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptItems(RealTimeContactAnalysisTranscriptItemWithContent... transcriptItems) {
            transcriptItems(Arrays.asList(transcriptItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptItems(
                Consumer<RealTimeContactAnalysisTranscriptItemWithContent.Builder>... transcriptItems) {
            transcriptItems(Stream.of(transcriptItems)
                    .map(c -> RealTimeContactAnalysisTranscriptItemWithContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RealTimeContactAnalysisIssueDetected build() {
            return new RealTimeContactAnalysisIssueDetected(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
