/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that describes attached file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisAttachment.Builder, RealTimeContactAnalysisAttachment> {
    private static final SdkField<String> ATTACHMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentName").getter(getter(RealTimeContactAnalysisAttachment::attachmentName))
            .setter(setter(Builder::attachmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentName").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(RealTimeContactAnalysisAttachment::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(RealTimeContactAnalysisAttachment::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RealTimeContactAnalysisAttachment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_NAME_FIELD,
            CONTENT_TYPE_FIELD, ATTACHMENT_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachmentName;

    private final String contentType;

    private final String attachmentId;

    private final String status;

    private RealTimeContactAnalysisAttachment(BuilderImpl builder) {
        this.attachmentName = builder.attachmentName;
        this.contentType = builder.contentType;
        this.attachmentId = builder.attachmentId;
        this.status = builder.status;
    }

    /**
     * <p>
     * A case-sensitive name of the attachment being uploaded. Can be redacted.
     * </p>
     * 
     * @return A case-sensitive name of the attachment being uploaded. Can be redacted.
     */
    public final String attachmentName() {
        return attachmentName;
    }

    /**
     * <p>
     * Describes the MIME file type of the attachment. For a list of supported file types, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html">Feature specifications</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return Describes the MIME file type of the attachment. For a list of supported file types, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html">Feature
     *         specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A unique identifier for the attachment.
     * </p>
     * 
     * @return A unique identifier for the attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * Status of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ArtifactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the attachment.
     * @see ArtifactStatus
     */
    public final ArtifactStatus status() {
        return ArtifactStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ArtifactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the attachment.
     * @see ArtifactStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisAttachment)) {
            return false;
        }
        RealTimeContactAnalysisAttachment other = (RealTimeContactAnalysisAttachment) obj;
        return Objects.equals(attachmentName(), other.attachmentName()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisAttachment").add("AttachmentName", attachmentName())
                .add("ContentType", contentType()).add("AttachmentId", attachmentId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentName":
            return Optional.ofNullable(clazz.cast(attachmentName()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisAttachment, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisAttachment> {
        /**
         * <p>
         * A case-sensitive name of the attachment being uploaded. Can be redacted.
         * </p>
         * 
         * @param attachmentName
         *        A case-sensitive name of the attachment being uploaded. Can be redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentName(String attachmentName);

        /**
         * <p>
         * Describes the MIME file type of the attachment. For a list of supported file types, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html">Feature specifications</a>
         * in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param contentType
         *        Describes the MIME file type of the attachment. For a list of supported file types, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html">Feature
         *        specifications</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A unique identifier for the attachment.
         * </p>
         * 
         * @param attachmentId
         *        A unique identifier for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Status of the attachment.
         * </p>
         * 
         * @param status
         *        Status of the attachment.
         * @see ArtifactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the attachment.
         * </p>
         * 
         * @param status
         *        Status of the attachment.
         * @see ArtifactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatus
         */
        Builder status(ArtifactStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentName;

        private String contentType;

        private String attachmentId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisAttachment model) {
            attachmentName(model.attachmentName);
            contentType(model.contentType);
            attachmentId(model.attachmentId);
            status(model.status);
        }

        public final String getAttachmentName() {
            return attachmentName;
        }

        public final void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        @Override
        public final Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ArtifactStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RealTimeContactAnalysisAttachment build() {
            return new RealTimeContactAnalysisAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
