/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRealtimeContactAnalysisSegmentsV2Response extends ConnectResponse implements
        ToCopyableBuilder<ListRealtimeContactAnalysisSegmentsV2Response.Builder, ListRealtimeContactAnalysisSegmentsV2Response> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(ListRealtimeContactAnalysisSegmentsV2Response::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListRealtimeContactAnalysisSegmentsV2Response::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<RealtimeContactAnalysisSegment>> SEGMENTS_FIELD = SdkField
            .<List<RealtimeContactAnalysisSegment>> builder(MarshallingType.LIST)
            .memberName("Segments")
            .getter(getter(ListRealtimeContactAnalysisSegmentsV2Response::segments))
            .setter(setter(Builder::segments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealtimeContactAnalysisSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealtimeContactAnalysisSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRealtimeContactAnalysisSegmentsV2Response::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, STATUS_FIELD,
            SEGMENTS_FIELD, NEXT_TOKEN_FIELD));

    private final String channel;

    private final String status;

    private final List<RealtimeContactAnalysisSegment> segments;

    private final String nextToken;

    private ListRealtimeContactAnalysisSegmentsV2Response(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.status = builder.status;
        this.segments = builder.segments;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The channel of the contact. <code>Voice</code> will not be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link RealTimeContactAnalysisSupportedChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #channelAsString}.
     * </p>
     * 
     * @return The channel of the contact. <code>Voice</code> will not be returned.
     * @see RealTimeContactAnalysisSupportedChannel
     */
    public final RealTimeContactAnalysisSupportedChannel channel() {
        return RealTimeContactAnalysisSupportedChannel.fromValue(channel);
    }

    /**
     * <p>
     * The channel of the contact. <code>Voice</code> will not be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link RealTimeContactAnalysisSupportedChannel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #channelAsString}.
     * </p>
     * 
     * @return The channel of the contact. <code>Voice</code> will not be returned.
     * @see RealTimeContactAnalysisSupportedChannel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * Status of real-time contact analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RealTimeContactAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of real-time contact analysis.
     * @see RealTimeContactAnalysisStatus
     */
    public final RealTimeContactAnalysisStatus status() {
        return RealTimeContactAnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of real-time contact analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RealTimeContactAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of real-time contact analysis.
     * @see RealTimeContactAnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Segments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSegments() {
        return segments != null && !(segments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An analyzed transcript or category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegments} method.
     * </p>
     * 
     * @return An analyzed transcript or category.
     */
    public final List<RealtimeContactAnalysisSegment> segments() {
        return segments;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegments() ? segments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRealtimeContactAnalysisSegmentsV2Response)) {
            return false;
        }
        ListRealtimeContactAnalysisSegmentsV2Response other = (ListRealtimeContactAnalysisSegmentsV2Response) obj;
        return Objects.equals(channelAsString(), other.channelAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasSegments() == other.hasSegments()
                && Objects.equals(segments(), other.segments()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRealtimeContactAnalysisSegmentsV2Response").add("Channel", channelAsString())
                .add("Status", statusAsString()).add("Segments", hasSegments() ? segments() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Segments":
            return Optional.ofNullable(clazz.cast(segments()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRealtimeContactAnalysisSegmentsV2Response, T> g) {
        return obj -> g.apply((ListRealtimeContactAnalysisSegmentsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRealtimeContactAnalysisSegmentsV2Response> {
        /**
         * <p>
         * The channel of the contact. <code>Voice</code> will not be returned.
         * </p>
         * 
         * @param channel
         *        The channel of the contact. <code>Voice</code> will not be returned.
         * @see RealTimeContactAnalysisSupportedChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisSupportedChannel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel of the contact. <code>Voice</code> will not be returned.
         * </p>
         * 
         * @param channel
         *        The channel of the contact. <code>Voice</code> will not be returned.
         * @see RealTimeContactAnalysisSupportedChannel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisSupportedChannel
         */
        Builder channel(RealTimeContactAnalysisSupportedChannel channel);

        /**
         * <p>
         * Status of real-time contact analysis.
         * </p>
         * 
         * @param status
         *        Status of real-time contact analysis.
         * @see RealTimeContactAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of real-time contact analysis.
         * </p>
         * 
         * @param status
         *        Status of real-time contact analysis.
         * @see RealTimeContactAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisStatus
         */
        Builder status(RealTimeContactAnalysisStatus status);

        /**
         * <p>
         * An analyzed transcript or category.
         * </p>
         * 
         * @param segments
         *        An analyzed transcript or category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(Collection<RealtimeContactAnalysisSegment> segments);

        /**
         * <p>
         * An analyzed transcript or category.
         * </p>
         * 
         * @param segments
         *        An analyzed transcript or category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segments(RealtimeContactAnalysisSegment... segments);

        /**
         * <p>
         * An analyzed transcript or category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegment.Builder#build()} is
         * called immediately and its result is passed to {@link #segments(List<RealtimeContactAnalysisSegment>)}.
         * 
         * @param segments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RealtimeContactAnalysisSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segments(java.util.Collection<RealtimeContactAnalysisSegment>)
         */
        Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder>... segments);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String channel;

        private String status;

        private List<RealtimeContactAnalysisSegment> segments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRealtimeContactAnalysisSegmentsV2Response model) {
            super(model);
            channel(model.channel);
            status(model.status);
            segments(model.segments);
            nextToken(model.nextToken);
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(RealTimeContactAnalysisSupportedChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RealTimeContactAnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<RealtimeContactAnalysisSegment.Builder> getSegments() {
            List<RealtimeContactAnalysisSegment.Builder> result = RealtimeContactAnalysisSegmentsCopier
                    .copyToBuilder(this.segments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegments(Collection<RealtimeContactAnalysisSegment.BuilderImpl> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copyFromBuilder(segments);
        }

        @Override
        public final Builder segments(Collection<RealtimeContactAnalysisSegment> segments) {
            this.segments = RealtimeContactAnalysisSegmentsCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(RealtimeContactAnalysisSegment... segments) {
            segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Consumer<RealtimeContactAnalysisSegment.Builder>... segments) {
            segments(Stream.of(segments).map(c -> RealtimeContactAnalysisSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRealtimeContactAnalysisSegmentsV2Response build() {
            return new ListRealtimeContactAnalysisSegmentsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
