/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersV2Response extends ConnectResponse implements
        ToCopyableBuilder<ListPhoneNumbersV2Response.Builder, ListPhoneNumbersV2Response> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPhoneNumbersV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListPhoneNumbersSummary>> LIST_PHONE_NUMBERS_SUMMARY_LIST_FIELD = SdkField
            .<List<ListPhoneNumbersSummary>> builder(MarshallingType.LIST)
            .memberName("ListPhoneNumbersSummaryList")
            .getter(getter(ListPhoneNumbersV2Response::listPhoneNumbersSummaryList))
            .setter(setter(Builder::listPhoneNumbersSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListPhoneNumbersSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListPhoneNumbersSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListPhoneNumbersSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            LIST_PHONE_NUMBERS_SUMMARY_LIST_FIELD));

    private final String nextToken;

    private final List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList;

    private ListPhoneNumbersV2Response(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.listPhoneNumbersSummaryList = builder.listPhoneNumbersSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListPhoneNumbersSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasListPhoneNumbersSummaryList() {
        return listPhoneNumbersSummaryList != null && !(listPhoneNumbersSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about phone numbers that have been claimed to your Amazon Connect instances or traffic distribution
     * groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListPhoneNumbersSummaryList} method.
     * </p>
     * 
     * @return Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
     *         distribution groups.
     */
    public final List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList() {
        return listPhoneNumbersSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasListPhoneNumbersSummaryList() ? listPhoneNumbersSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersV2Response)) {
            return false;
        }
        ListPhoneNumbersV2Response other = (ListPhoneNumbersV2Response) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasListPhoneNumbersSummaryList() == other.hasListPhoneNumbersSummaryList()
                && Objects.equals(listPhoneNumbersSummaryList(), other.listPhoneNumbersSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPhoneNumbersV2Response").add("NextToken", nextToken())
                .add("ListPhoneNumbersSummaryList", hasListPhoneNumbersSummaryList() ? listPhoneNumbersSummaryList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ListPhoneNumbersSummaryList":
            return Optional.ofNullable(clazz.cast(listPhoneNumbersSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersV2Response, T> g) {
        return obj -> g.apply((ListPhoneNumbersV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersV2Response> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
         * distribution groups.
         * </p>
         * 
         * @param listPhoneNumbersSummaryList
         *        Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
         *        distribution groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listPhoneNumbersSummaryList(Collection<ListPhoneNumbersSummary> listPhoneNumbersSummaryList);

        /**
         * <p>
         * Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
         * distribution groups.
         * </p>
         * 
         * @param listPhoneNumbersSummaryList
         *        Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
         *        distribution groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listPhoneNumbersSummaryList(ListPhoneNumbersSummary... listPhoneNumbersSummaryList);

        /**
         * <p>
         * Information about phone numbers that have been claimed to your Amazon Connect instances or traffic
         * distribution groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #listPhoneNumbersSummaryList(List<ListPhoneNumbersSummary>)}.
         * 
         * @param listPhoneNumbersSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listPhoneNumbersSummaryList(java.util.Collection<ListPhoneNumbersSummary>)
         */
        Builder listPhoneNumbersSummaryList(Consumer<ListPhoneNumbersSummary.Builder>... listPhoneNumbersSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersV2Response model) {
            super(model);
            nextToken(model.nextToken);
            listPhoneNumbersSummaryList(model.listPhoneNumbersSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListPhoneNumbersSummary.Builder> getListPhoneNumbersSummaryList() {
            List<ListPhoneNumbersSummary.Builder> result = ListPhoneNumbersSummaryListCopier
                    .copyToBuilder(this.listPhoneNumbersSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListPhoneNumbersSummaryList(
                Collection<ListPhoneNumbersSummary.BuilderImpl> listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList = ListPhoneNumbersSummaryListCopier.copyFromBuilder(listPhoneNumbersSummaryList);
        }

        @Override
        public final Builder listPhoneNumbersSummaryList(Collection<ListPhoneNumbersSummary> listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList = ListPhoneNumbersSummaryListCopier.copy(listPhoneNumbersSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listPhoneNumbersSummaryList(ListPhoneNumbersSummary... listPhoneNumbersSummaryList) {
            listPhoneNumbersSummaryList(Arrays.asList(listPhoneNumbersSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listPhoneNumbersSummaryList(Consumer<ListPhoneNumbersSummary.Builder>... listPhoneNumbersSummaryList) {
            listPhoneNumbersSummaryList(Stream.of(listPhoneNumbersSummaryList)
                    .map(c -> ListPhoneNumbersSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPhoneNumbersV2Response build() {
            return new ListPhoneNumbersV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
