/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the interval period to use for returning results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntervalDetails implements SdkPojo, Serializable, ToCopyableBuilder<IntervalDetails.Builder, IntervalDetails> {
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(IntervalDetails::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<String> INTERVAL_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntervalPeriod").getter(getter(IntervalDetails::intervalPeriodAsString))
            .setter(setter(Builder::intervalPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_ZONE_FIELD,
            INTERVAL_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeZone;

    private final String intervalPeriod;

    private IntervalDetails(BuilderImpl builder) {
        this.timeZone = builder.timeZone;
        this.intervalPeriod = builder.intervalPeriod;
    }

    /**
     * <p>
     * The timezone applied to requested metrics.
     * </p>
     * 
     * @return The timezone applied to requested metrics.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid <code>IntervalPeriod</code>
     * values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> | <code>HOUR</code> | <code>DAY</code> |
     * <code>WEEK</code> | <code>TOTAL</code>.
     * </p>
     * <p>
     * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
     * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
     * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the <code>TOTAL</code>
     * interval period.
     * </p>
     * <p>
     * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on what
     * <code>IntervalPeriod</code> is requested.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     * than 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
     * 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalPeriod}
     * will return {@link IntervalPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intervalPeriodAsString}.
     * </p>
     * 
     * @return <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
     *         <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
     *         <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p>
     *         <p>
     *         For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code>
     *         and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each
     *         result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
     *         <code>TOTAL</code> interval period.
     *         </p>
     *         <p>
     *         The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
     *         what <code>IntervalPeriod</code> is requested.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     * @see IntervalPeriod
     */
    public final IntervalPeriod intervalPeriod() {
        return IntervalPeriod.fromValue(intervalPeriod);
    }

    /**
     * <p>
     * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid <code>IntervalPeriod</code>
     * values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> | <code>HOUR</code> | <code>DAY</code> |
     * <code>WEEK</code> | <code>TOTAL</code>.
     * </p>
     * <p>
     * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
     * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
     * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the <code>TOTAL</code>
     * interval period.
     * </p>
     * <p>
     * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on what
     * <code>IntervalPeriod</code> is requested.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     * than 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
     * 3 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
     * days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #intervalPeriod}
     * will return {@link IntervalPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intervalPeriodAsString}.
     * </p>
     * 
     * @return <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
     *         <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
     *         <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p>
     *         <p>
     *         For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code>
     *         and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each
     *         result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
     *         <code>TOTAL</code> interval period.
     *         </p>
     *         <p>
     *         The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
     *         what <code>IntervalPeriod</code> is requested.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
     *         less than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 3 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
     *         than 35 days.
     *         </p>
     *         </li>
     * @see IntervalPeriod
     */
    public final String intervalPeriodAsString() {
        return intervalPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(intervalPeriodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntervalDetails)) {
            return false;
        }
        IntervalDetails other = (IntervalDetails) obj;
        return Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(intervalPeriodAsString(), other.intervalPeriodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntervalDetails").add("TimeZone", timeZone()).add("IntervalPeriod", intervalPeriodAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "IntervalPeriod":
            return Optional.ofNullable(clazz.cast(intervalPeriodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntervalDetails, T> g) {
        return obj -> g.apply((IntervalDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntervalDetails> {
        /**
         * <p>
         * The timezone applied to requested metrics.
         * </p>
         * 
         * @param timeZone
         *        The timezone applied to requested metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         * <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         * <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
         * </p>
         * <p>
         * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
         * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
         * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
         * <code>TOTAL</code> interval period.
         * </p>
         * <p>
         * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on what
         * <code>IntervalPeriod</code> is requested.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param intervalPeriod
         *        <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         *        <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         *        <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p>
         *        <p>
         *        For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>,
         *        <code>StartTime</code> and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48
         *        results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect
         *        aggregates results based on the <code>TOTAL</code> interval period.
         *        </p>
         *        <p>
         *        The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
         *        what <code>IntervalPeriod</code> is requested.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
         *        less than 35 days.
         *        </p>
         *        </li>
         * @see IntervalPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalPeriod
         */
        Builder intervalPeriod(String intervalPeriod);

        /**
         * <p>
         * <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         * <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         * <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>.
         * </p>
         * <p>
         * For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and
         * <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is
         * aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the
         * <code>TOTAL</code> interval period.
         * </p>
         * <p>
         * The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on what
         * <code>IntervalPeriod</code> is requested.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         * than 3 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35
         * days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than
         * 35 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param intervalPeriod
         *        <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid
         *        <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> |
         *        <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p>
         *        <p>
         *        For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>,
         *        <code>StartTime</code> and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48
         *        results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect
         *        aggregates results based on the <code>TOTAL</code> interval period.
         *        </p>
         *        <p>
         *        The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on
         *        what <code>IntervalPeriod</code> is requested.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must
         *        be less than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 3 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less
         *        than 35 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be
         *        less than 35 days.
         *        </p>
         *        </li>
         * @see IntervalPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IntervalPeriod
         */
        Builder intervalPeriod(IntervalPeriod intervalPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String timeZone;

        private String intervalPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(IntervalDetails model) {
            timeZone(model.timeZone);
            intervalPeriod(model.intervalPeriod);
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getIntervalPeriod() {
            return intervalPeriod;
        }

        public final void setIntervalPeriod(String intervalPeriod) {
            this.intervalPeriod = intervalPeriod;
        }

        @Override
        public final Builder intervalPeriod(String intervalPeriod) {
            this.intervalPeriod = intervalPeriod;
            return this;
        }

        @Override
        public final Builder intervalPeriod(IntervalPeriod intervalPeriod) {
            this.intervalPeriod(intervalPeriod == null ? null : intervalPeriod.toString());
            return this;
        }

        @Override
        public IntervalDetails build() {
            return new IntervalDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
