/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePersistentContactAssociationResponse extends ConnectResponse implements
        ToCopyableBuilder<CreatePersistentContactAssociationResponse.Builder, CreatePersistentContactAssociationResponse> {
    private static final SdkField<String> CONTINUED_FROM_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContinuedFromContactId")
            .getter(getter(CreatePersistentContactAssociationResponse::continuedFromContactId))
            .setter(setter(Builder::continuedFromContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuedFromContactId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTINUED_FROM_CONTACT_ID_FIELD));

    private final String continuedFromContactId;

    private CreatePersistentContactAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.continuedFromContactId = builder.continuedFromContactId;
    }

    /**
     * <p>
     * The contactId from which a persistent chat session is started. This field is populated only for persistent chat.
     * </p>
     * 
     * @return The contactId from which a persistent chat session is started. This field is populated only for
     *         persistent chat.
     */
    public final String continuedFromContactId() {
        return continuedFromContactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(continuedFromContactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentContactAssociationResponse)) {
            return false;
        }
        CreatePersistentContactAssociationResponse other = (CreatePersistentContactAssociationResponse) obj;
        return Objects.equals(continuedFromContactId(), other.continuedFromContactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePersistentContactAssociationResponse")
                .add("ContinuedFromContactId", continuedFromContactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuedFromContactId":
            return Optional.ofNullable(clazz.cast(continuedFromContactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentContactAssociationResponse, T> g) {
        return obj -> g.apply((CreatePersistentContactAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePersistentContactAssociationResponse> {
        /**
         * <p>
         * The contactId from which a persistent chat session is started. This field is populated only for persistent
         * chat.
         * </p>
         * 
         * @param continuedFromContactId
         *        The contactId from which a persistent chat session is started. This field is populated only for
         *        persistent chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuedFromContactId(String continuedFromContactId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String continuedFromContactId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentContactAssociationResponse model) {
            super(model);
            continuedFromContactId(model.continuedFromContactId);
        }

        public final String getContinuedFromContactId() {
            return continuedFromContactId;
        }

        public final void setContinuedFromContactId(String continuedFromContactId) {
            this.continuedFromContactId = continuedFromContactId;
        }

        @Override
        public final Builder continuedFromContactId(String continuedFromContactId) {
            this.continuedFromContactId = continuedFromContactId;
            return this;
        }

        @Override
        public CreatePersistentContactAssociationResponse build() {
            return new CreatePersistentContactAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
