/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Contact.html">contact</a>
 * associated to the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentContactReference implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentContactReference.Builder, AgentContactReference> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(AgentContactReference::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(AgentContactReference::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiationMethod").getter(getter(AgentContactReference::initiationMethodAsString))
            .setter(setter(Builder::initiationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()).build();

    private static final SdkField<String> AGENT_CONTACT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentContactState").getter(getter(AgentContactReference::agentContactStateAsString))
            .setter(setter(Builder::agentContactState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentContactState").build()).build();

    private static final SdkField<Instant> STATE_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateStartTimestamp").getter(getter(AgentContactReference::stateStartTimestamp))
            .setter(setter(Builder::stateStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateStartTimestamp").build())
            .build();

    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp")
            .getter(getter(AgentContactReference::connectedToAgentTimestamp)).setter(setter(Builder::connectedToAgentTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build())
            .build();

    private static final SdkField<QueueReference> QUEUE_FIELD = SdkField.<QueueReference> builder(MarshallingType.SDK_POJO)
            .memberName("Queue").getter(getter(AgentContactReference::queue)).setter(setter(Builder::queue))
            .constructor(QueueReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            CHANNEL_FIELD, INITIATION_METHOD_FIELD, AGENT_CONTACT_STATE_FIELD, STATE_START_TIMESTAMP_FIELD,
            CONNECTED_TO_AGENT_TIMESTAMP_FIELD, QUEUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final String channel;

    private final String initiationMethod;

    private final String agentContactState;

    private final Instant stateStartTimestamp;

    private final Instant connectedToAgentTimestamp;

    private final QueueReference queue;

    private AgentContactReference(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.channel = builder.channel;
        this.initiationMethod = builder.initiationMethod;
        this.agentContactState = builder.agentContactState;
        this.stateStartTimestamp = builder.stateStartTimestamp;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
        this.queue = builder.queue;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The channel of the contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel of the contact.
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channel of the contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel of the contact.
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * How the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return How the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(initiationMethod);
    }

    /**
     * <p>
     * How the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return How the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final String initiationMethodAsString() {
        return initiationMethod;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of the
     * contact</a>.
     * </p>
     * <note>
     * <p>
     * When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>, <code>StateStartTimestamp</code> is
     * not changed. Instead, <code>StateStartTimestamp</code> reflects the time the contact was <code>CONNECTED</code>
     * to the agent.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentContactState}
     * will return {@link ContactState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentContactStateAsString}.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of
     *         the contact</a>.</p> <note>
     *         <p>
     *         When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>,
     *         <code>StateStartTimestamp</code> is not changed. Instead, <code>StateStartTimestamp</code> reflects the
     *         time the contact was <code>CONNECTED</code> to the agent.
     *         </p>
     * @see ContactState
     */
    public final ContactState agentContactState() {
        return ContactState.fromValue(agentContactState);
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of the
     * contact</a>.
     * </p>
     * <note>
     * <p>
     * When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>, <code>StateStartTimestamp</code> is
     * not changed. Instead, <code>StateStartTimestamp</code> reflects the time the contact was <code>CONNECTED</code>
     * to the agent.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentContactState}
     * will return {@link ContactState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentContactStateAsString}.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of
     *         the contact</a>.</p> <note>
     *         <p>
     *         When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>,
     *         <code>StateStartTimestamp</code> is not changed. Instead, <code>StateStartTimestamp</code> reflects the
     *         time the contact was <code>CONNECTED</code> to the agent.
     *         </p>
     * @see ContactState
     */
    public final String agentContactStateAsString() {
        return agentContactState;
    }

    /**
     * <p>
     * The epoch timestamp when the contact state started.
     * </p>
     * 
     * @return The epoch timestamp when the contact state started.
     */
    public final Instant stateStartTimestamp() {
        return stateStartTimestamp;
    }

    /**
     * <p>
     * The time at which the contact was connected to an agent.
     * </p>
     * 
     * @return The time at which the contact was connected to an agent.
     */
    public final Instant connectedToAgentTimestamp() {
        return connectedToAgentTimestamp;
    }

    /**
     * Returns the value of the Queue property for this object.
     * 
     * @return The value of the Queue property for this object.
     */
    public final QueueReference queue() {
        return queue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentContactStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(connectedToAgentTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentContactReference)) {
            return false;
        }
        AgentContactReference other = (AgentContactReference) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(channelAsString(), other.channelAsString())
                && Objects.equals(initiationMethodAsString(), other.initiationMethodAsString())
                && Objects.equals(agentContactStateAsString(), other.agentContactStateAsString())
                && Objects.equals(stateStartTimestamp(), other.stateStartTimestamp())
                && Objects.equals(connectedToAgentTimestamp(), other.connectedToAgentTimestamp())
                && Objects.equals(queue(), other.queue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentContactReference").add("ContactId", contactId()).add("Channel", channelAsString())
                .add("InitiationMethod", initiationMethodAsString()).add("AgentContactState", agentContactStateAsString())
                .add("StateStartTimestamp", stateStartTimestamp()).add("ConnectedToAgentTimestamp", connectedToAgentTimestamp())
                .add("Queue", queue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "InitiationMethod":
            return Optional.ofNullable(clazz.cast(initiationMethodAsString()));
        case "AgentContactState":
            return Optional.ofNullable(clazz.cast(agentContactStateAsString()));
        case "StateStartTimestamp":
            return Optional.ofNullable(clazz.cast(stateStartTimestamp()));
        case "ConnectedToAgentTimestamp":
            return Optional.ofNullable(clazz.cast(connectedToAgentTimestamp()));
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentContactReference, T> g) {
        return obj -> g.apply((AgentContactReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentContactReference> {
        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The channel of the contact.
         * </p>
         * 
         * @param channel
         *        The channel of the contact.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel of the contact.
         * </p>
         * 
         * @param channel
         *        The channel of the contact.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * How the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        How the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(String initiationMethod);

        /**
         * <p>
         * How the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        How the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(ContactInitiationMethod initiationMethod);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of the
         * contact</a>.
         * </p>
         * <note>
         * <p>
         * When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>, <code>StateStartTimestamp</code>
         * is not changed. Instead, <code>StateStartTimestamp</code> reflects the time the contact was
         * <code>CONNECTED</code> to the agent.
         * </p>
         * </note>
         * 
         * @param agentContactState
         *        The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of
         *        the contact</a>.</p> <note>
         *        <p>
         *        When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>,
         *        <code>StateStartTimestamp</code> is not changed. Instead, <code>StateStartTimestamp</code> reflects
         *        the time the contact was <code>CONNECTED</code> to the agent.
         *        </p>
         * @see ContactState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactState
         */
        Builder agentContactState(String agentContactState);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of the
         * contact</a>.
         * </p>
         * <note>
         * <p>
         * When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>, <code>StateStartTimestamp</code>
         * is not changed. Instead, <code>StateStartTimestamp</code> reflects the time the contact was
         * <code>CONNECTED</code> to the agent.
         * </p>
         * </note>
         * 
         * @param agentContactState
         *        The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of
         *        the contact</a>.</p> <note>
         *        <p>
         *        When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>,
         *        <code>StateStartTimestamp</code> is not changed. Instead, <code>StateStartTimestamp</code> reflects
         *        the time the contact was <code>CONNECTED</code> to the agent.
         *        </p>
         * @see ContactState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactState
         */
        Builder agentContactState(ContactState agentContactState);

        /**
         * <p>
         * The epoch timestamp when the contact state started.
         * </p>
         * 
         * @param stateStartTimestamp
         *        The epoch timestamp when the contact state started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateStartTimestamp(Instant stateStartTimestamp);

        /**
         * <p>
         * The time at which the contact was connected to an agent.
         * </p>
         * 
         * @param connectedToAgentTimestamp
         *        The time at which the contact was connected to an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp);

        /**
         * Sets the value of the Queue property for this object.
         *
         * @param queue
         *        The new value for the Queue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(QueueReference queue);

        /**
         * Sets the value of the Queue property for this object.
         *
         * This is a convenience method that creates an instance of the {@link QueueReference.Builder} avoiding the need
         * to create one manually via {@link QueueReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueReference.Builder#build()} is called immediately and its
         * result is passed to {@link #queue(QueueReference)}.
         * 
         * @param queue
         *        a consumer that will call methods on {@link QueueReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queue(QueueReference)
         */
        default Builder queue(Consumer<QueueReference.Builder> queue) {
            return queue(QueueReference.builder().applyMutation(queue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private String channel;

        private String initiationMethod;

        private String agentContactState;

        private Instant stateStartTimestamp;

        private Instant connectedToAgentTimestamp;

        private QueueReference queue;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentContactReference model) {
            contactId(model.contactId);
            channel(model.channel);
            initiationMethod(model.initiationMethod);
            agentContactState(model.agentContactState);
            stateStartTimestamp(model.stateStartTimestamp);
            connectedToAgentTimestamp(model.connectedToAgentTimestamp);
            queue(model.queue);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getInitiationMethod() {
            return initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getAgentContactState() {
            return agentContactState;
        }

        public final void setAgentContactState(String agentContactState) {
            this.agentContactState = agentContactState;
        }

        @Override
        public final Builder agentContactState(String agentContactState) {
            this.agentContactState = agentContactState;
            return this;
        }

        @Override
        public final Builder agentContactState(ContactState agentContactState) {
            this.agentContactState(agentContactState == null ? null : agentContactState.toString());
            return this;
        }

        public final Instant getStateStartTimestamp() {
            return stateStartTimestamp;
        }

        public final void setStateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
        }

        @Override
        public final Builder stateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        public final QueueReference.Builder getQueue() {
            return queue != null ? queue.toBuilder() : null;
        }

        public final void setQueue(QueueReference.BuilderImpl queue) {
            this.queue = queue != null ? queue.build() : null;
        }

        @Override
        public final Builder queue(QueueReference queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public AgentContactReference build() {
            return new AgentContactReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
