/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAggregateResourceConfigResponse extends ConfigResponse implements
        ToCopyableBuilder<GetAggregateResourceConfigResponse.Builder, GetAggregateResourceConfigResponse> {
    private static final SdkField<ConfigurationItem> CONFIGURATION_ITEM_FIELD = SdkField
            .<ConfigurationItem> builder(MarshallingType.SDK_POJO).memberName("ConfigurationItem")
            .getter(getter(GetAggregateResourceConfigResponse::configurationItem)).setter(setter(Builder::configurationItem))
            .constructor(ConfigurationItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ITEM_FIELD));

    private final ConfigurationItem configurationItem;

    private GetAggregateResourceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configurationItem = builder.configurationItem;
    }

    /**
     * <p>
     * Returns a <code>ConfigurationItem</code> object.
     * </p>
     * 
     * @return Returns a <code>ConfigurationItem</code> object.
     */
    public final ConfigurationItem configurationItem() {
        return configurationItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregateResourceConfigResponse)) {
            return false;
        }
        GetAggregateResourceConfigResponse other = (GetAggregateResourceConfigResponse) obj;
        return Objects.equals(configurationItem(), other.configurationItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAggregateResourceConfigResponse").add("ConfigurationItem", configurationItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationItem":
            return Optional.ofNullable(clazz.cast(configurationItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAggregateResourceConfigResponse, T> g) {
        return obj -> g.apply((GetAggregateResourceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAggregateResourceConfigResponse> {
        /**
         * <p>
         * Returns a <code>ConfigurationItem</code> object.
         * </p>
         * 
         * @param configurationItem
         *        Returns a <code>ConfigurationItem</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationItem(ConfigurationItem configurationItem);

        /**
         * <p>
         * Returns a <code>ConfigurationItem</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationItem.Builder} avoiding the
         * need to create one manually via {@link ConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationItem.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationItem(ConfigurationItem)}.
         * 
         * @param configurationItem
         *        a consumer that will call methods on {@link ConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationItem(ConfigurationItem)
         */
        default Builder configurationItem(Consumer<ConfigurationItem.Builder> configurationItem) {
            return configurationItem(ConfigurationItem.builder().applyMutation(configurationItem).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private ConfigurationItem configurationItem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregateResourceConfigResponse model) {
            super(model);
            configurationItem(model.configurationItem);
        }

        public final ConfigurationItem.Builder getConfigurationItem() {
            return configurationItem != null ? configurationItem.toBuilder() : null;
        }

        public final void setConfigurationItem(ConfigurationItem.BuilderImpl configurationItem) {
            this.configurationItem = configurationItem != null ? configurationItem.build() : null;
        }

        @Override
        public final Builder configurationItem(ConfigurationItem configurationItem) {
            this.configurationItem = configurationItem;
            return this;
        }

        @Override
        public GetAggregateResourceConfigResponse build() {
            return new GetAggregateResourceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
