/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the recommendation options for Amazon RDS storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDSDBStorageRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<RDSDBStorageRecommendationOption.Builder, RDSDBStorageRecommendationOption> {
    private static final SdkField<DBStorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<DBStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(RDSDBStorageRecommendationOption::storageConfiguration)).setter(setter(Builder::storageConfiguration))
            .constructor(DBStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(RDSDBStorageRecommendationOption::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(RDSDBStorageRecommendationOption::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<RDSStorageSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField
            .<RDSStorageSavingsOpportunityAfterDiscounts> builder(MarshallingType.SDK_POJO)
            .memberName("savingsOpportunityAfterDiscounts")
            .getter(getter(RDSDBStorageRecommendationOption::savingsOpportunityAfterDiscounts))
            .setter(setter(Builder::savingsOpportunityAfterDiscounts))
            .constructor(RDSStorageSavingsOpportunityAfterDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_FIELD,
            RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DBStorageConfiguration storageConfiguration;

    private final Integer rank;

    private final SavingsOpportunity savingsOpportunity;

    private final RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private RDSDBStorageRecommendationOption(BuilderImpl builder) {
        this.storageConfiguration = builder.storageConfiguration;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    /**
     * <p>
     * The recommended storage configuration.
     * </p>
     * 
     * @return The recommended storage configuration.
     */
    public final DBStorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    /**
     * <p>
     * The rank identifier of the RDS storage recommendation option.
     * </p>
     * 
     * @return The rank identifier of the RDS storage recommendation option.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * Returns the value of the SavingsOpportunity property for this object.
     * 
     * @return The value of the SavingsOpportunity property for this object.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option.
     * </p>
     * <p>
     * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
     * achieve this by implementing a given Compute Optimizer recommendation.
     * </p>
     * 
     * @return Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation
     *         option. </p>
     *         <p>
     *         Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You
     *         can achieve this by implementing a given Compute Optimizer recommendation.
     */
    public final RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return savingsOpportunityAfterDiscounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBStorageRecommendationOption)) {
            return false;
        }
        RDSDBStorageRecommendationOption other = (RDSDBStorageRecommendationOption) obj;
        return Objects.equals(storageConfiguration(), other.storageConfiguration()) && Objects.equals(rank(), other.rank())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDSDBStorageRecommendationOption").add("StorageConfiguration", storageConfiguration())
                .add("Rank", rank()).add("SavingsOpportunity", savingsOpportunity())
                .add("SavingsOpportunityAfterDiscounts", savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "savingsOpportunityAfterDiscounts":
            return Optional.ofNullable(clazz.cast(savingsOpportunityAfterDiscounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSDBStorageRecommendationOption, T> g) {
        return obj -> g.apply((RDSDBStorageRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDSDBStorageRecommendationOption> {
        /**
         * <p>
         * The recommended storage configuration.
         * </p>
         * 
         * @param storageConfiguration
         *        The recommended storage configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(DBStorageConfiguration storageConfiguration);

        /**
         * <p>
         * The recommended storage configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DBStorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link DBStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBStorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfiguration(DBStorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link DBStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(DBStorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<DBStorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(DBStorageConfiguration.builder().applyMutation(storageConfiguration).build());
        }

        /**
         * <p>
         * The rank identifier of the RDS storage recommendation option.
         * </p>
         * 
         * @param rank
         *        The rank identifier of the RDS storage recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * @param savingsOpportunity
         *        The new value for the SavingsOpportunity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * Sets the value of the SavingsOpportunity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * 
         * @param savingsOpportunityAfterDiscounts
         *        Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation
         *        option. </p>
         *        <p>
         *        Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts.
         *        You can achieve this by implementing a given Compute Optimizer recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts);

        /**
         * <p>
         * Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option.
         * </p>
         * <p>
         * Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can
         * achieve this by implementing a given Compute Optimizer recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RDSStorageSavingsOpportunityAfterDiscounts.Builder} avoiding the need to create one manually via
         * {@link RDSStorageSavingsOpportunityAfterDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSStorageSavingsOpportunityAfterDiscounts.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts)}.
         * 
         * @param savingsOpportunityAfterDiscounts
         *        a consumer that will call methods on {@link RDSStorageSavingsOpportunityAfterDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts)
         */
        default Builder savingsOpportunityAfterDiscounts(
                Consumer<RDSStorageSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return savingsOpportunityAfterDiscounts(RDSStorageSavingsOpportunityAfterDiscounts.builder()
                    .applyMutation(savingsOpportunityAfterDiscounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DBStorageConfiguration storageConfiguration;

        private Integer rank;

        private SavingsOpportunity savingsOpportunity;

        private RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDBStorageRecommendationOption model) {
            storageConfiguration(model.storageConfiguration);
            rank(model.rank);
            savingsOpportunity(model.savingsOpportunity);
            savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final DBStorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(DBStorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(DBStorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final RDSStorageSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(
                RDSStorageSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts
                    .build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(
                RDSStorageSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        @Override
        public RDSDBStorageRecommendationOption build() {
            return new RDSDBStorageRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
