/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecommendationPreferencesRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<PutRecommendationPreferencesRequest.Builder, PutRecommendationPreferencesRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(PutRecommendationPreferencesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Scope> SCOPE_FIELD = SdkField.<Scope> builder(MarshallingType.SDK_POJO).memberName("scope")
            .getter(getter(PutRecommendationPreferencesRequest::scope)).setter(setter(Builder::scope))
            .constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enhancedInfrastructureMetrics")
            .getter(getter(PutRecommendationPreferencesRequest::enhancedInfrastructureMetricsAsString))
            .setter(setter(Builder::enhancedInfrastructureMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics")
                    .build()).build();

    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferredWorkloadTypes")
            .getter(getter(PutRecommendationPreferencesRequest::inferredWorkloadTypesAsString))
            .setter(setter(Builder::inferredWorkloadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build())
            .build();

    private static final SdkField<ExternalMetricsPreference> EXTERNAL_METRICS_PREFERENCE_FIELD = SdkField
            .<ExternalMetricsPreference> builder(MarshallingType.SDK_POJO).memberName("externalMetricsPreference")
            .getter(getter(PutRecommendationPreferencesRequest::externalMetricsPreference))
            .setter(setter(Builder::externalMetricsPreference)).constructor(ExternalMetricsPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricsPreference").build())
            .build();

    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lookBackPeriod").getter(getter(PutRecommendationPreferencesRequest::lookBackPeriodAsString))
            .setter(setter(Builder::lookBackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()).build();

    private static final SdkField<List<UtilizationPreference>> UTILIZATION_PREFERENCES_FIELD = SdkField
            .<List<UtilizationPreference>> builder(MarshallingType.LIST)
            .memberName("utilizationPreferences")
            .getter(getter(PutRecommendationPreferencesRequest::utilizationPreferences))
            .setter(setter(Builder::utilizationPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationPreferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UtilizationPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(UtilizationPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PreferredResource>> PREFERRED_RESOURCES_FIELD = SdkField
            .<List<PreferredResource>> builder(MarshallingType.LIST)
            .memberName("preferredResources")
            .getter(getter(PutRecommendationPreferencesRequest::preferredResources))
            .setter(setter(Builder::preferredResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PreferredResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PreferredResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsEstimationMode")
            .getter(getter(PutRecommendationPreferencesRequest::savingsEstimationModeAsString))
            .setter(setter(Builder::savingsEstimationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SCOPE_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD, EXTERNAL_METRICS_PREFERENCE_FIELD,
            LOOK_BACK_PERIOD_FIELD, UTILIZATION_PREFERENCES_FIELD, PREFERRED_RESOURCES_FIELD, SAVINGS_ESTIMATION_MODE_FIELD));

    private final String resourceType;

    private final Scope scope;

    private final String enhancedInfrastructureMetrics;

    private final String inferredWorkloadTypes;

    private final ExternalMetricsPreference externalMetricsPreference;

    private final String lookBackPeriod;

    private final List<UtilizationPreference> utilizationPreferences;

    private final List<PreferredResource> preferredResources;

    private final String savingsEstimationMode;

    private PutRecommendationPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.scope = builder.scope;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
        this.externalMetricsPreference = builder.externalMetricsPreference;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.utilizationPreferences = builder.utilizationPreferences;
        this.preferredResources = builder.preferredResources;
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to create.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to create.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to create.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to create.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * An object that describes the scope of the recommendation preference to create.
     * </p>
     * <p>
     * You can create recommendation preferences at the organization level (for management accounts of an organization
     * only), account level, and resource level. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You
     * can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope
     * name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This
     * will configure the preference for all instances that are part of the specified Auto Scaling group. You also
     * cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling
     * group. You can create recommendation preferences at the resource level only for standalone instances.
     * </p>
     * </note>
     * 
     * @return An object that describes the scope of the recommendation preference to create.</p>
     *         <p>
     *         You can create recommendation preferences at the organization level (for management accounts of an
     *         organization only), account level, and resource level. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot create recommendation preferences for Auto Scaling groups at the organization and account
     *         levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by
     *         specifying a scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon
     *         Resource Name (ARN). This will configure the preference for all instances that are part of the specified
     *         Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances
     *         that are part of an Auto Scaling group. You can create recommendation preferences at the resource level
     *         only for standalone instances.
     *         </p>
     */
    public final Scope scope() {
        return scope;
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference to create or update.
     * </p>
     * <p>
     * Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to deactivate
     * the preference.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference to create or update.</p>
     *         <p>
     *         Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
     *         deactivate the preference.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(enhancedInfrastructureMetrics);
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference to create or update.
     * </p>
     * <p>
     * Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to deactivate
     * the preference.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference to create or update.</p>
     *         <p>
     *         Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
     *         deactivate the preference.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final String enhancedInfrastructureMetricsAsString() {
        return enhancedInfrastructureMetrics;
    }

    /**
     * <p>
     * The status of the inferred workload types recommendation preference to create or update.
     * </p>
     * <note>
     * <p>
     * The inferred workload type feature is active by default. To deactivate it, create a recommendation preference.
     * </p>
     * </note>
     * <p>
     * Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to activate
     * it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred workload
     * types</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return The status of the inferred workload types recommendation preference to create or update.</p> <note>
     *         <p>
     *         The inferred workload type feature is active by default. To deactivate it, create a recommendation
     *         preference.
     *         </p>
     *         </note>
     *         <p>
     *         Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
     *         activate it.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred
     *         workload types</a> in the <i>Compute Optimizer User Guide</i>.
     * @see InferredWorkloadTypesPreference
     */
    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(inferredWorkloadTypes);
    }

    /**
     * <p>
     * The status of the inferred workload types recommendation preference to create or update.
     * </p>
     * <note>
     * <p>
     * The inferred workload type feature is active by default. To deactivate it, create a recommendation preference.
     * </p>
     * </note>
     * <p>
     * Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to activate
     * it.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred workload
     * types</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return The status of the inferred workload types recommendation preference to create or update.</p> <note>
     *         <p>
     *         The inferred workload type feature is active by default. To deactivate it, create a recommendation
     *         preference.
     *         </p>
     *         </note>
     *         <p>
     *         Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
     *         activate it.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred
     *         workload types</a> in the <i>Compute Optimizer User Guide</i>.
     * @see InferredWorkloadTypesPreference
     */
    public final String inferredWorkloadTypesAsString() {
        return inferredWorkloadTypes;
    }

    /**
     * <p>
     * The provider of the external metrics recommendation preference to create or update.
     * </p>
     * <p>
     * Specify a valid provider in the <code>source</code> field to activate the preference. To delete this preference,
     * see the <a>DeleteRecommendationPreferences</a> action.
     * </p>
     * <p>
     * This preference can only be set for the <code>Ec2Instance</code> resource type.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">External metrics
     * ingestion</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * 
     * @return The provider of the external metrics recommendation preference to create or update.</p>
     *         <p>
     *         Specify a valid provider in the <code>source</code> field to activate the preference. To delete this
     *         preference, see the <a>DeleteRecommendationPreferences</a> action.
     *         </p>
     *         <p>
     *         This preference can only be set for the <code>Ec2Instance</code> resource type.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">External
     *         metrics ingestion</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final ExternalMetricsPreference externalMetricsPreference() {
        return externalMetricsPreference;
    }

    /**
     * <p>
     * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are
     * analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>.
     * </p>
     * <note>
     * <p>
     * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The preference to control the number of days the utilization metrics of the Amazon Web Services resource
     *         are analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>. </p>
     *         <note>
     *         <p>
     *         You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     *         </p>
     * @see LookBackPeriodPreference
     */
    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(lookBackPeriod);
    }

    /**
     * <p>
     * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are
     * analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>.
     * </p>
     * <note>
     * <p>
     * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lookBackPeriod}
     * will return {@link LookBackPeriodPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lookBackPeriodAsString}.
     * </p>
     * 
     * @return The preference to control the number of days the utilization metrics of the Amazon Web Services resource
     *         are analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>. </p>
     *         <note>
     *         <p>
     *         You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     *         </p>
     * @see LookBackPeriodPreference
     */
    public final String lookBackPeriodAsString() {
        return lookBackPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the UtilizationPreferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUtilizationPreferences() {
        return utilizationPreferences != null && !(utilizationPreferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory
     * utilization headroom. When this preference isn't specified, we use the following default values.
     * </p>
     * <p>
     * CPU utilization:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>P99_5</code> for threshold
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERCENT_20</code> for headroom
     * </p>
     * </li>
     * </ul>
     * <p>
     * Memory utilization:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PERCENT_20</code> for headroom
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
     * </p>
     * </li>
     * <li>
     * <p>
     * The threshold setting isn’t available for memory utilization.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUtilizationPreferences} method.
     * </p>
     * 
     * @return The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory
     *         utilization headroom. When this preference isn't specified, we use the following default values. </p>
     *         <p>
     *         CPU utilization:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>P99_5</code> for threshold
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERCENT_20</code> for headroom
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Memory utilization:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PERCENT_20</code> for headroom
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <ul>
     *         <li>
     *         <p>
     *         You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The threshold setting isn’t available for memory utilization.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final List<UtilizationPreference> utilizationPreferences() {
        return utilizationPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreferredResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPreferredResources() {
        return preferredResources != null && !(preferredResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The preference to control which resource type values are considered when generating rightsizing recommendations.
     * You can specify this preference as a combination of include and exclude lists. You must specify either an
     * <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of resource type values,
     * an error occurs.
     * </p>
     * <note>
     * <p>
     * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreferredResources} method.
     * </p>
     * 
     * @return The preference to control which resource type values are considered when generating rightsizing
     *         recommendations. You can specify this preference as a combination of include and exclude lists. You must
     *         specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set
     *         of resource type values, an error occurs. </p> <note>
     *         <p>
     *         You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
     *         </p>
     */
    public final List<PreferredResource> preferredResources() {
        return preferredResources;
    }

    /**
     * <p>
     * The status of the savings estimation mode preference to create or update.
     * </p>
     * <p>
     * Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
     * <code>BeforeDiscounts</code> to deactivate the preference.
     * </p>
     * <p>
     * Only the account manager or delegated administrator of your organization can activate this preference.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings estimation
     * mode</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #savingsEstimationMode} will return {@link SavingsEstimationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #savingsEstimationModeAsString}.
     * </p>
     * 
     * @return The status of the savings estimation mode preference to create or update. </p>
     *         <p>
     *         Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
     *         <code>BeforeDiscounts</code> to deactivate the preference.
     *         </p>
     *         <p>
     *         Only the account manager or delegated administrator of your organization can activate this preference.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
     *         estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
     * @see SavingsEstimationMode
     */
    public final SavingsEstimationMode savingsEstimationMode() {
        return SavingsEstimationMode.fromValue(savingsEstimationMode);
    }

    /**
     * <p>
     * The status of the savings estimation mode preference to create or update.
     * </p>
     * <p>
     * Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
     * <code>BeforeDiscounts</code> to deactivate the preference.
     * </p>
     * <p>
     * Only the account manager or delegated administrator of your organization can activate this preference.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings estimation
     * mode</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #savingsEstimationMode} will return {@link SavingsEstimationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #savingsEstimationModeAsString}.
     * </p>
     * 
     * @return The status of the savings estimation mode preference to create or update. </p>
     *         <p>
     *         Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
     *         <code>BeforeDiscounts</code> to deactivate the preference.
     *         </p>
     *         <p>
     *         Only the account manager or delegated administrator of your organization can activate this preference.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
     *         estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
     * @see SavingsEstimationMode
     */
    public final String savingsEstimationModeAsString() {
        return savingsEstimationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferredWorkloadTypesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalMetricsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUtilizationPreferences() ? utilizationPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPreferredResources() ? preferredResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(savingsEstimationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecommendationPreferencesRequest)) {
            return false;
        }
        PutRecommendationPreferencesRequest other = (PutRecommendationPreferencesRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(scope(), other.scope())
                && Objects.equals(enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString())
                && Objects.equals(inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString())
                && Objects.equals(externalMetricsPreference(), other.externalMetricsPreference())
                && Objects.equals(lookBackPeriodAsString(), other.lookBackPeriodAsString())
                && hasUtilizationPreferences() == other.hasUtilizationPreferences()
                && Objects.equals(utilizationPreferences(), other.utilizationPreferences())
                && hasPreferredResources() == other.hasPreferredResources()
                && Objects.equals(preferredResources(), other.preferredResources())
                && Objects.equals(savingsEstimationModeAsString(), other.savingsEstimationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecommendationPreferencesRequest").add("ResourceType", resourceTypeAsString())
                .add("Scope", scope()).add("EnhancedInfrastructureMetrics", enhancedInfrastructureMetricsAsString())
                .add("InferredWorkloadTypes", inferredWorkloadTypesAsString())
                .add("ExternalMetricsPreference", externalMetricsPreference()).add("LookBackPeriod", lookBackPeriodAsString())
                .add("UtilizationPreferences", hasUtilizationPreferences() ? utilizationPreferences() : null)
                .add("PreferredResources", hasPreferredResources() ? preferredResources() : null)
                .add("SavingsEstimationMode", savingsEstimationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "enhancedInfrastructureMetrics":
            return Optional.ofNullable(clazz.cast(enhancedInfrastructureMetricsAsString()));
        case "inferredWorkloadTypes":
            return Optional.ofNullable(clazz.cast(inferredWorkloadTypesAsString()));
        case "externalMetricsPreference":
            return Optional.ofNullable(clazz.cast(externalMetricsPreference()));
        case "lookBackPeriod":
            return Optional.ofNullable(clazz.cast(lookBackPeriodAsString()));
        case "utilizationPreferences":
            return Optional.ofNullable(clazz.cast(utilizationPreferences()));
        case "preferredResources":
            return Optional.ofNullable(clazz.cast(preferredResources()));
        case "savingsEstimationMode":
            return Optional.ofNullable(clazz.cast(savingsEstimationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecommendationPreferencesRequest, T> g) {
        return obj -> g.apply((PutRecommendationPreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRecommendationPreferencesRequest> {
        /**
         * <p>
         * The target resource type of the recommendation preference to create.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to create.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The target resource type of the recommendation preference to create.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to create.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * An object that describes the scope of the recommendation preference to create.
         * </p>
         * <p>
         * You can create recommendation preferences at the organization level (for management accounts of an
         * organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * <note>
         * <p>
         * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels.
         * You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a
         * scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon Resource Name
         * (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling
         * group. You also cannot create recommendation preferences at the resource level for instances that are part of
         * an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone
         * instances.
         * </p>
         * </note>
         * 
         * @param scope
         *        An object that describes the scope of the recommendation preference to create.</p>
         *        <p>
         *        You can create recommendation preferences at the organization level (for management accounts of an
         *        organization only), account level, and resource level. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot create recommendation preferences for Auto Scaling groups at the organization and account
         *        levels. You can create recommendation preferences for Auto Scaling groups only at the resource level
         *        by specifying a scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group
         *        Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the
         *        specified Auto Scaling group. You also cannot create recommendation preferences at the resource level
         *        for instances that are part of an Auto Scaling group. You can create recommendation preferences at the
         *        resource level only for standalone instances.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * An object that describes the scope of the recommendation preference to create.
         * </p>
         * <p>
         * You can create recommendation preferences at the organization level (for management accounts of an
         * organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * <note>
         * <p>
         * You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels.
         * You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a
         * scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon Resource Name
         * (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling
         * group. You also cannot create recommendation preferences at the resource level for instances that are part of
         * an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone
         * instances.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Scope.Builder} avoiding the need
         * to create one manually via {@link Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference to create or update.
         * </p>
         * <p>
         * Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
         * deactivate the preference.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference to create or update.</p>
         *        <p>
         *        Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
         *        deactivate the preference.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics);

        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference to create or update.
         * </p>
         * <p>
         * Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
         * deactivate the preference.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference to create or update.</p>
         *        <p>
         *        Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to
         *        deactivate the preference.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics);

        /**
         * <p>
         * The status of the inferred workload types recommendation preference to create or update.
         * </p>
         * <note>
         * <p>
         * The inferred workload type feature is active by default. To deactivate it, create a recommendation
         * preference.
         * </p>
         * </note>
         * <p>
         * Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
         * activate it.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred workload
         * types</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        The status of the inferred workload types recommendation preference to create or update.</p> <note>
         *        <p>
         *        The inferred workload type feature is active by default. To deactivate it, create a recommendation
         *        preference.
         *        </p>
         *        </note>
         *        <p>
         *        Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
         *        activate it.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred
         *        workload types</a> in the <i>Compute Optimizer User Guide</i>.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(String inferredWorkloadTypes);

        /**
         * <p>
         * The status of the inferred workload types recommendation preference to create or update.
         * </p>
         * <note>
         * <p>
         * The inferred workload type feature is active by default. To deactivate it, create a recommendation
         * preference.
         * </p>
         * </note>
         * <p>
         * Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
         * activate it.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred workload
         * types</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        The status of the inferred workload types recommendation preference to create or update.</p> <note>
         *        <p>
         *        The inferred workload type feature is active by default. To deactivate it, create a recommendation
         *        preference.
         *        </p>
         *        </note>
         *        <p>
         *        Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to
         *        activate it.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred
         *        workload types</a> in the <i>Compute Optimizer User Guide</i>.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes);

        /**
         * <p>
         * The provider of the external metrics recommendation preference to create or update.
         * </p>
         * <p>
         * Specify a valid provider in the <code>source</code> field to activate the preference. To delete this
         * preference, see the <a>DeleteRecommendationPreferences</a> action.
         * </p>
         * <p>
         * This preference can only be set for the <code>Ec2Instance</code> resource type.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">External
         * metrics ingestion</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param externalMetricsPreference
         *        The provider of the external metrics recommendation preference to create or update.</p>
         *        <p>
         *        Specify a valid provider in the <code>source</code> field to activate the preference. To delete this
         *        preference, see the <a>DeleteRecommendationPreferences</a> action.
         *        </p>
         *        <p>
         *        This preference can only be set for the <code>Ec2Instance</code> resource type.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html"
         *        >External metrics ingestion</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference);

        /**
         * <p>
         * The provider of the external metrics recommendation preference to create or update.
         * </p>
         * <p>
         * Specify a valid provider in the <code>source</code> field to activate the preference. To delete this
         * preference, see the <a>DeleteRecommendationPreferences</a> action.
         * </p>
         * <p>
         * This preference can only be set for the <code>Ec2Instance</code> resource type.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">External
         * metrics ingestion</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalMetricsPreference.Builder}
         * avoiding the need to create one manually via {@link ExternalMetricsPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalMetricsPreference.Builder#build()} is called immediately
         * and its result is passed to {@link #externalMetricsPreference(ExternalMetricsPreference)}.
         * 
         * @param externalMetricsPreference
         *        a consumer that will call methods on {@link ExternalMetricsPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalMetricsPreference(ExternalMetricsPreference)
         */
        default Builder externalMetricsPreference(Consumer<ExternalMetricsPreference.Builder> externalMetricsPreference) {
            return externalMetricsPreference(ExternalMetricsPreference.builder().applyMutation(externalMetricsPreference).build());
        }

        /**
         * <p>
         * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are
         * analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>.
         * </p>
         * <note>
         * <p>
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         * </p>
         * </note>
         * 
         * @param lookBackPeriod
         *        The preference to control the number of days the utilization metrics of the Amazon Web Services
         *        resource are analyzed. When this preference isn't specified, we use the default value
         *        <code>DAYS_14</code>. </p> <note>
         *        <p>
         *        You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         *        </p>
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(String lookBackPeriod);

        /**
         * <p>
         * The preference to control the number of days the utilization metrics of the Amazon Web Services resource are
         * analyzed. When this preference isn't specified, we use the default value <code>DAYS_14</code>.
         * </p>
         * <note>
         * <p>
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         * </p>
         * </note>
         * 
         * @param lookBackPeriod
         *        The preference to control the number of days the utilization metrics of the Amazon Web Services
         *        resource are analyzed. When this preference isn't specified, we use the default value
         *        <code>DAYS_14</code>. </p> <note>
         *        <p>
         *        You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         *        </p>
         * @see LookBackPeriodPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookBackPeriodPreference
         */
        Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod);

        /**
         * <p>
         * The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory
         * utilization headroom. When this preference isn't specified, we use the following default values.
         * </p>
         * <p>
         * CPU utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P99_5</code> for threshold
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <p>
         * Memory utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <note>
         * <ul>
         * <li>
         * <p>
         * You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
         * </p>
         * </li>
         * <li>
         * <p>
         * The threshold setting isn’t available for memory utilization.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param utilizationPreferences
         *        The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and
         *        memory utilization headroom. When this preference isn't specified, we use the following default
         *        values. </p>
         *        <p>
         *        CPU utilization:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P99_5</code> for threshold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT_20</code> for headroom
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Memory utilization:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PERCENT_20</code> for headroom
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <ul>
         *        <li>
         *        <p>
         *        You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The threshold setting isn’t available for memory utilization.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences);

        /**
         * <p>
         * The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory
         * utilization headroom. When this preference isn't specified, we use the following default values.
         * </p>
         * <p>
         * CPU utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P99_5</code> for threshold
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <p>
         * Memory utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <note>
         * <ul>
         * <li>
         * <p>
         * You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
         * </p>
         * </li>
         * <li>
         * <p>
         * The threshold setting isn’t available for memory utilization.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param utilizationPreferences
         *        The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and
         *        memory utilization headroom. When this preference isn't specified, we use the following default
         *        values. </p>
         *        <p>
         *        CPU utilization:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>P99_5</code> for threshold
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERCENT_20</code> for headroom
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Memory utilization:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PERCENT_20</code> for headroom
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <ul>
         *        <li>
         *        <p>
         *        You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The threshold setting isn’t available for memory utilization.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationPreferences(UtilizationPreference... utilizationPreferences);

        /**
         * <p>
         * The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory
         * utilization headroom. When this preference isn't specified, we use the following default values.
         * </p>
         * <p>
         * CPU utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>P99_5</code> for threshold
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <p>
         * Memory utilization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PERCENT_20</code> for headroom
         * </p>
         * </li>
         * </ul>
         * <note>
         * <ul>
         * <li>
         * <p>
         * You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.
         * </p>
         * </li>
         * <li>
         * <p>
         * The threshold setting isn’t available for memory utilization.
         * </p>
         * </li>
         * </ul>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder#build()} is
         * called immediately and its result is passed to {@link #utilizationPreferences(List<UtilizationPreference>)}.
         * 
         * @param utilizationPreferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilizationPreferences(java.util.Collection<UtilizationPreference>)
         */
        Builder utilizationPreferences(Consumer<UtilizationPreference.Builder>... utilizationPreferences);

        /**
         * <p>
         * The preference to control which resource type values are considered when generating rightsizing
         * recommendations. You can specify this preference as a combination of include and exclude lists. You must
         * specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of
         * resource type values, an error occurs.
         * </p>
         * <note>
         * <p>
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         * </p>
         * </note>
         * 
         * @param preferredResources
         *        The preference to control which resource type values are considered when generating rightsizing
         *        recommendations. You can specify this preference as a combination of include and exclude lists. You
         *        must specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an
         *        empty set of resource type values, an error occurs. </p> <note>
         *        <p>
         *        You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredResources(Collection<PreferredResource> preferredResources);

        /**
         * <p>
         * The preference to control which resource type values are considered when generating rightsizing
         * recommendations. You can specify this preference as a combination of include and exclude lists. You must
         * specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of
         * resource type values, an error occurs.
         * </p>
         * <note>
         * <p>
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         * </p>
         * </note>
         * 
         * @param preferredResources
         *        The preference to control which resource type values are considered when generating rightsizing
         *        recommendations. You can specify this preference as a combination of include and exclude lists. You
         *        must specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an
         *        empty set of resource type values, an error occurs. </p> <note>
         *        <p>
         *        You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredResources(PreferredResource... preferredResources);

        /**
         * <p>
         * The preference to control which resource type values are considered when generating rightsizing
         * recommendations. You can specify this preference as a combination of include and exclude lists. You must
         * specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of
         * resource type values, an error occurs.
         * </p>
         * <note>
         * <p>
         * You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.PreferredResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.PreferredResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.PreferredResource.Builder#build()} is called
         * immediately and its result is passed to {@link #preferredResources(List<PreferredResource>)}.
         * 
         * @param preferredResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.PreferredResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferredResources(java.util.Collection<PreferredResource>)
         */
        Builder preferredResources(Consumer<PreferredResource.Builder>... preferredResources);

        /**
         * <p>
         * The status of the savings estimation mode preference to create or update.
         * </p>
         * <p>
         * Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
         * <code>BeforeDiscounts</code> to deactivate the preference.
         * </p>
         * <p>
         * Only the account manager or delegated administrator of your organization can activate this preference.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
         * estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param savingsEstimationMode
         *        The status of the savings estimation mode preference to create or update. </p>
         *        <p>
         *        Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
         *        <code>BeforeDiscounts</code> to deactivate the preference.
         *        </p>
         *        <p>
         *        Only the account manager or delegated administrator of your organization can activate this preference.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
         *        estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
         * @see SavingsEstimationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsEstimationMode
         */
        Builder savingsEstimationMode(String savingsEstimationMode);

        /**
         * <p>
         * The status of the savings estimation mode preference to create or update.
         * </p>
         * <p>
         * Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
         * <code>BeforeDiscounts</code> to deactivate the preference.
         * </p>
         * <p>
         * Only the account manager or delegated administrator of your organization can activate this preference.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
         * estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param savingsEstimationMode
         *        The status of the savings estimation mode preference to create or update. </p>
         *        <p>
         *        Specify the <code>AfterDiscounts</code> status to activate the preference, or specify
         *        <code>BeforeDiscounts</code> to deactivate the preference.
         *        </p>
         *        <p>
         *        Only the account manager or delegated administrator of your organization can activate this preference.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings
         *        estimation mode</a> in the <i>Compute Optimizer User Guide</i>.
         * @see SavingsEstimationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsEstimationMode
         */
        Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private String resourceType;

        private Scope scope;

        private String enhancedInfrastructureMetrics;

        private String inferredWorkloadTypes;

        private ExternalMetricsPreference externalMetricsPreference;

        private String lookBackPeriod;

        private List<UtilizationPreference> utilizationPreferences = DefaultSdkAutoConstructList.getInstance();

        private List<PreferredResource> preferredResources = DefaultSdkAutoConstructList.getInstance();

        private String savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecommendationPreferencesRequest model) {
            super(model);
            resourceType(model.resourceType);
            scope(model.scope);
            enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            inferredWorkloadTypes(model.inferredWorkloadTypes);
            externalMetricsPreference(model.externalMetricsPreference);
            lookBackPeriod(model.lookBackPeriod);
            utilizationPreferences(model.utilizationPreferences);
            preferredResources(model.preferredResources);
            savingsEstimationMode(model.savingsEstimationMode);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics
                    .toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        public final ExternalMetricsPreference.Builder getExternalMetricsPreference() {
            return externalMetricsPreference != null ? externalMetricsPreference.toBuilder() : null;
        }

        public final void setExternalMetricsPreference(ExternalMetricsPreference.BuilderImpl externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference != null ? externalMetricsPreference.build() : null;
        }

        @Override
        public final Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference;
            return this;
        }

        public final String getLookBackPeriod() {
            return lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final List<UtilizationPreference.Builder> getUtilizationPreferences() {
            List<UtilizationPreference.Builder> result = UtilizationPreferencesCopier.copyToBuilder(this.utilizationPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationPreferences(Collection<UtilizationPreference.BuilderImpl> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copyFromBuilder(utilizationPreferences);
        }

        @Override
        public final Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copy(utilizationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(UtilizationPreference... utilizationPreferences) {
            utilizationPreferences(Arrays.asList(utilizationPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(Consumer<UtilizationPreference.Builder>... utilizationPreferences) {
            utilizationPreferences(Stream.of(utilizationPreferences)
                    .map(c -> UtilizationPreference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PreferredResource.Builder> getPreferredResources() {
            List<PreferredResource.Builder> result = PreferredResourcesCopier.copyToBuilder(this.preferredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreferredResources(Collection<PreferredResource.BuilderImpl> preferredResources) {
            this.preferredResources = PreferredResourcesCopier.copyFromBuilder(preferredResources);
        }

        @Override
        public final Builder preferredResources(Collection<PreferredResource> preferredResources) {
            this.preferredResources = PreferredResourcesCopier.copy(preferredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(PreferredResource... preferredResources) {
            preferredResources(Arrays.asList(preferredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(Consumer<PreferredResource.Builder>... preferredResources) {
            preferredResources(Stream.of(preferredResources).map(c -> PreferredResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSavingsEstimationMode() {
            return savingsEstimationMode;
        }

        public final void setSavingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
        }

        @Override
        public final Builder savingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public final Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode(savingsEstimationMode == null ? null : savingsEstimationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecommendationPreferencesRequest build() {
            return new PutRecommendationPreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
