/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableRDSDBField {
    RESOURCE_ARN("ResourceArn"),

    ACCOUNT_ID("AccountId"),

    ENGINE("Engine"),

    ENGINE_VERSION("EngineVersion"),

    IDLE("Idle"),

    MULTI_AZDB_INSTANCE("MultiAZDBInstance"),

    CURRENT_DB_INSTANCE_CLASS("CurrentDBInstanceClass"),

    CURRENT_STORAGE_CONFIGURATION_STORAGE_TYPE("CurrentStorageConfigurationStorageType"),

    CURRENT_STORAGE_CONFIGURATION_ALLOCATED_STORAGE("CurrentStorageConfigurationAllocatedStorage"),

    CURRENT_STORAGE_CONFIGURATION_MAX_ALLOCATED_STORAGE("CurrentStorageConfigurationMaxAllocatedStorage"),

    CURRENT_STORAGE_CONFIGURATION_IOPS("CurrentStorageConfigurationIOPS"),

    CURRENT_STORAGE_CONFIGURATION_STORAGE_THROUGHPUT("CurrentStorageConfigurationStorageThroughput"),

    CURRENT_INSTANCE_ON_DEMAND_HOURLY_PRICE("CurrentInstanceOnDemandHourlyPrice"),

    CURRENT_STORAGE_ON_DEMAND_MONTHLY_PRICE("CurrentStorageOnDemandMonthlyPrice"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_STORAGE_SPACE_UTILIZATION_MAXIMUM("UtilizationMetricsEBSVolumeStorageSpaceUtilizationMaximum"),

    UTILIZATION_METRICS_NETWORK_RECEIVE_THROUGHPUT_MAXIMUM("UtilizationMetricsNetworkReceiveThroughputMaximum"),

    UTILIZATION_METRICS_NETWORK_TRANSMIT_THROUGHPUT_MAXIMUM("UtilizationMetricsNetworkTransmitThroughputMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_READ_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeReadIOPSMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_WRITE_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeWriteIOPSMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_READ_THROUGHPUT_MAXIMUM("UtilizationMetricsEBSVolumeReadThroughputMaximum"),

    UTILIZATION_METRICS_EBS_VOLUME_WRITE_THROUGHPUT_MAXIMUM("UtilizationMetricsEBSVolumeWriteThroughputMaximum"),

    UTILIZATION_METRICS_DATABASE_CONNECTIONS_MAXIMUM("UtilizationMetricsDatabaseConnectionsMaximum"),

    INSTANCE_FINDING("InstanceFinding"),

    INSTANCE_FINDING_REASON_CODES("InstanceFindingReasonCodes"),

    STORAGE_FINDING("StorageFinding"),

    STORAGE_FINDING_REASON_CODES("StorageFindingReasonCodes"),

    INSTANCE_RECOMMENDATION_OPTIONS_DB_INSTANCE_CLASS("InstanceRecommendationOptionsDBInstanceClass"),

    INSTANCE_RECOMMENDATION_OPTIONS_RANK("InstanceRecommendationOptionsRank"),

    INSTANCE_RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("InstanceRecommendationOptionsPerformanceRisk"),

    INSTANCE_RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM(
            "InstanceRecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),

    STORAGE_RECOMMENDATION_OPTIONS_STORAGE_TYPE("StorageRecommendationOptionsStorageType"),

    STORAGE_RECOMMENDATION_OPTIONS_ALLOCATED_STORAGE("StorageRecommendationOptionsAllocatedStorage"),

    STORAGE_RECOMMENDATION_OPTIONS_MAX_ALLOCATED_STORAGE("StorageRecommendationOptionsMaxAllocatedStorage"),

    STORAGE_RECOMMENDATION_OPTIONS_IOPS("StorageRecommendationOptionsIOPS"),

    STORAGE_RECOMMENDATION_OPTIONS_STORAGE_THROUGHPUT("StorageRecommendationOptionsStorageThroughput"),

    STORAGE_RECOMMENDATION_OPTIONS_RANK("StorageRecommendationOptionsRank"),

    INSTANCE_RECOMMENDATION_OPTIONS_INSTANCE_ON_DEMAND_HOURLY_PRICE("InstanceRecommendationOptionsInstanceOnDemandHourlyPrice"),

    INSTANCE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("InstanceRecommendationOptionsSavingsOpportunityPercentage"),

    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY(
            "InstanceRecommendationOptionsEstimatedMonthlySavingsCurrency"),

    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("InstanceRecommendationOptionsEstimatedMonthlySavingsValue"),

    INSTANCE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE(
            "InstanceRecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),

    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS(
            "InstanceRecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),

    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS(
            "InstanceRecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),

    STORAGE_RECOMMENDATION_OPTIONS_ON_DEMAND_MONTHLY_PRICE("StorageRecommendationOptionsOnDemandMonthlyPrice"),

    STORAGE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("StorageRecommendationOptionsSavingsOpportunityPercentage"),

    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY(
            "StorageRecommendationOptionsEstimatedMonthlySavingsCurrency"),

    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("StorageRecommendationOptionsEstimatedMonthlySavingsValue"),

    STORAGE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE(
            "StorageRecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),

    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS(
            "StorageRecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),

    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS(
            "StorageRecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES("EffectiveRecommendationPreferencesCpuVendorArchitectures"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS(
            "EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_LOOK_BACK_PERIOD("EffectiveRecommendationPreferencesLookBackPeriod"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_SAVINGS_ESTIMATION_MODE("EffectiveRecommendationPreferencesSavingsEstimationMode"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    TAGS("Tags"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableRDSDBField> VALUE_MAP = EnumUtils.uniqueIndex(ExportableRDSDBField.class,
            ExportableRDSDBField::toString);

    private final String value;

    private ExportableRDSDBField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableRDSDBField corresponding to the value
     */
    public static ExportableRDSDBField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableRDSDBField}s
     */
    public static Set<ExportableRDSDBField> knownValues() {
        Set<ExportableRDSDBField> knownValues = EnumSet.allOf(ExportableRDSDBField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
